/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.DeriveMode;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableCorrelate
extends Correlate
implements EnumerableRel {
    public EnumerableCorrelate(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        super(cluster, traits, (List<RelHint>)ImmutableList.of(), left, right, correlationId, requiredColumns, joinType);
    }

    public static EnumerableCorrelate create(RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.enumerableCorrelate(mq, left, right, joinType));
        return new EnumerableCorrelate(cluster, traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public EnumerableCorrelate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        return new EnumerableCorrelate(this.getCluster(), traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return EnumerableTraitsUtils.passThroughTraitsForJoin(required, this.joinType, this.left.getRowType().getFieldCount(), this.getTraitSet());
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        return EnumerableTraitsUtils.deriveTraitsForJoin(childTraits, childId, this.joinType, this.traitSet, this.right.getTraitSet());
    }

    @Override
    public DeriveMode getDeriveMode() {
        return DeriveMode.LEFT_FIRST;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression corrRef;
        ParameterExpression corrArg;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        BlockBuilder corrBlock = new BlockBuilder();
        Type corrVarType = leftResult.physType.getJavaRowType();
        if (!Primitive.is((Type)corrVarType)) {
            corrRef = corrArg = Expressions.parameter((int)16, (Type)corrVarType, (String)this.getCorrelVariable());
        } else {
            corrArg = Expressions.parameter((int)16, (Type)Primitive.box((Type)corrVarType), (String)("$box" + this.getCorrelVariable()));
            corrRef = (ParameterExpression)corrBlock.append(this.getCorrelVariable(), Expressions.unbox((Expression)corrArg));
        }
        implementor.registerCorrelVariable(this.getCorrelVariable(), corrRef, corrBlock, leftResult.physType);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        implementor.clearCorrelVariable(this.getCorrelVariable());
        corrBlock.add((Statement)rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        Expression selector = EnumUtils.joinSelector(this.joinType, physType, (List<PhysType>)ImmutableList.of((Object)leftResult.physType, (Object)rightResult.physType));
        builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltInMethod.CORRELATE_JOIN.method, (Expression[])new Expression[]{Expressions.constant((Object)EnumUtils.toLinq4jJoinType(this.joinType)), Expressions.lambda((BlockStatement)corrBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{corrArg}), selector}));
        return implementor.result(physType, builder.toBlock());
    }
}

