/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.hive.serde2.lazy;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.TimestampParser;
import org.apache.kylin.common.exception.KylinRuntimeException;

@SerDeSpec(schemaProps={"columns", "columns.types", "field.delim", "colelction.delim", "mapkey.delim", "serialization.format", "serialization.null.format", "serialization.escape.crlf", "serialization.last.column.takes.rest", "escape.delim", "quote.delim", "serialization.encoding", "hive.serialization.extend.nesting.levels", "hive.serialization.extend.additional.nesting.levels"})
public class LazyQuoteAwareSerDe
extends LazySimpleSerDe {
    private QuoteAwareStruct myStruct;

    public static List<String[]> parseCsvLines(List<String> lines) {
        return LazyQuoteAwareSerDe.parseCsvLines(lines, ",", "\\", "\"");
    }

    public static List<String[]> parseCsvLines(List<String> lines, String separator, String escape, String quote) {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        int colCountEst = lines.stream().map(l -> l.chars().filter(c -> c == separator.charAt(0)).count() + 1L).max(Long::compare).orElse(0L).intValue();
        try {
            Properties tbl = new Properties();
            tbl.put("field.delim", separator);
            tbl.put("escape.delim", escape);
            tbl.put("quote.delim", quote);
            tbl.put("columns", IntStream.range(0, colCountEst).boxed().map(i -> "col" + i).collect(Collectors.joining(",")));
            tbl.put("columns.types", StringUtils.repeat((String)"string", (String)":", (int)colCountEst));
            LazyQuoteAwareSerDe serde = new LazyQuoteAwareSerDe();
            serde.initialize(new Configuration(), tbl);
            StructObjectInspector soi = (StructObjectInspector)serde.getObjectInspector();
            List fields = soi.getAllStructFieldRefs();
            ArrayList<String[]> ret = new ArrayList<String[]>();
            int nonNullColLen = 0;
            for (String line : lines) {
                LazyStruct struct = (LazyStruct)serde.deserialize((Writable)new Text(line));
                String[] row = new String[fields.size()];
                for (int i2 = 0; i2 < fields.size(); ++i2) {
                    LazyPrimitive val = (LazyPrimitive)soi.getStructFieldData((Object)struct, (StructField)fields.get(i2));
                    String string = row[i2] = val == null ? null : val.getWritableObject().toString();
                    if (val == null) continue;
                    nonNullColLen = Math.max(nonNullColLen, i2 + 1);
                }
                ret.add(row);
            }
            if (nonNullColLen < fields.size()) {
                for (int i3 = 0; i3 < ret.size(); ++i3) {
                    String[] row = (String[])ret.get(i3);
                    ret.set(i3, Arrays.copyOf(row, nonNullColLen));
                }
            }
            return ret;
        }
        catch (Exception ex) {
            throw new KylinRuntimeException((Throwable)ex);
        }
    }

    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        super.initialize(job, tbl);
        byte quote = 34;
        if (tbl.containsKey("quote.delim")) {
            quote = (byte)tbl.getProperty("quote.delim").charAt(0);
        }
        boolean numberForceRead = tbl.containsKey("number.force") && !"false".equals(tbl.getProperty("number.force"));
        this.myStruct = new QuoteAwareStruct((LazySimpleStructObjectInspector)this.getObjectInspector(), quote, numberForceRead);
        try {
            FieldUtils.writeField((Object)((Object)this), (String)"cachedLazyStruct", (Object)((Object)this.myStruct), (boolean)true);
        }
        catch (Exception e) {
            throw new KylinRuntimeException((Throwable)e);
        }
    }

    public boolean hasExtraFieldWarn() {
        return this.myStruct.selfExtraFieldWarned;
    }

    public boolean hasMissingFieldWarn() {
        return this.myStruct.selfMissingFieldWarned;
    }

    public static class PrimitiveParser {
        public static final String[] DATE_PTNS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "MM/dd/yyyy", "yyyy.MM.dd", "yyyyMMdd", "yyyyMM", "yyyy-MM", "yyyy/MM"};
        static final TimestampParser dateParser = new TimestampParser(DATE_PTNS);
        public static final String[] TIMESTAMP_PTNS = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH:mm:ss", "MM/dd/yyyy HH:mm", "MM/dd/yyyy HH:mm:ss"};
        static final TimestampParser timestampParser = new TimestampParser(TIMESTAMP_PTNS);
        private static final int MAX_HEAD_SKIP = 2;
        private static final int MAX_TAIL_SKIP = 2;

        private PrimitiveParser() {
        }

        public static Date parseDate(String str) {
            if (str.length() < 6 || str.length() > 10) {
                throw new IllegalArgumentException("Invalid date value: " + str);
            }
            try {
                Timestamp ts = dateParser.parseTimestamp(str);
                return new Date(ts.getTime());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error date value '" + str + "'. Date format must be " + StringUtils.join((Object[])DATE_PTNS, (String)" or "), e);
            }
        }

        public static Timestamp parseTimestamp(String str) {
            if (str.length() < 12 || str.length() > 24) {
                throw new IllegalArgumentException("Invalid timestamp value: " + str);
            }
            try {
                return timestampParser.parseTimestamp(str);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error timestamp value '" + str + "'. Timestamp format must be " + StringUtils.join((Object[])TIMESTAMP_PTNS, (String)" or "));
            }
        }

        public static Boolean parseBoolean(String str) {
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equals("1")) {
                return true;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("f") || str.equals("0")) {
                return false;
            }
            throw new IllegalArgumentException("Not a boolean: " + str);
        }

        private static String extractNumberPart(String str, boolean force) {
            int s = 0;
            int e = str.length() - 1;
            if ((s = PrimitiveParser.findStartIndexOfNumber(str, force, s, e)) > (e = PrimitiveParser.findEndIndexOfNumber(str, force, s, e))) {
                throw new NumberFormatException("String '" + str + "' does not contain a number");
            }
            str = str.substring(s, e + 1);
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') continue;
                return str.replace(",", "");
            }
            return str;
        }

        private static int findEndIndexOfNumber(String str, boolean force, int s, int e) {
            int tailSkip = 0;
            while (s <= e) {
                char c = str.charAt(e);
                if (!force && ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || tailSkip > 2)) {
                    throw new NumberFormatException("String '" + str + "' does not contain a number");
                }
                if (c >= '0' && c <= '9') break;
                --e;
                ++tailSkip;
            }
            return e;
        }

        private static int findStartIndexOfNumber(String str, boolean force, int s, int e) {
            int headSkip = 0;
            while (s <= e) {
                char c = str.charAt(s);
                if (!force && ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || headSkip > 2)) {
                    throw new NumberFormatException("String '" + str + "' does not contain a number");
                }
                if (c == '-' || c == '+' || c >= '0' && c <= '9') break;
                ++s;
                ++headSkip;
            }
            return s;
        }

        public static Double parseDouble(String str) {
            return PrimitiveParser.parseDouble(str, false);
        }

        public static Double parseDouble(String str, boolean force) {
            return Double.parseDouble(PrimitiveParser.extractNumberPart(str, force));
        }

        public static Float parseFloat(String str) {
            return PrimitiveParser.parseFloat(str, false);
        }

        public static Float parseFloat(String str, boolean force) {
            return Float.valueOf(Float.parseFloat(PrimitiveParser.extractNumberPart(str, force)));
        }

        public static Integer parseInteger(String str) {
            return PrimitiveParser.parseInteger(str, false);
        }

        public static Integer parseInteger(String str, boolean force) {
            return Integer.parseInt(PrimitiveParser.extractNumberPart(str, force));
        }

        public static Long parseLong(String str) {
            return PrimitiveParser.parseLong(str, false);
        }

        public static Long parseLong(String str, boolean force) {
            return Long.parseLong(PrimitiveParser.extractNumberPart(str, force));
        }
    }

    public static class LazyLongEx
    extends LazyGenericNumber<LazyLongObjectInspector, LongWritable> {
        public LazyLongEx(LazyLongObjectInspector lazyLongObjectInspector, boolean forceRead) {
            super(lazyLongObjectInspector, forceRead);
        }

        @Override
        protected LongWritable newEmptyWritable() {
            return new LongWritable();
        }

        @Override
        protected void parseAndSet(String str, LongWritable data, boolean force) {
            data.set(PrimitiveParser.parseLong(str, force).longValue());
        }
    }

    public static class LazyIntEx
    extends LazyGenericNumber<LazyIntObjectInspector, IntWritable> {
        public LazyIntEx(LazyIntObjectInspector lazyIntegerObjectInspector, boolean forceRead) {
            super(lazyIntegerObjectInspector, forceRead);
        }

        @Override
        protected IntWritable newEmptyWritable() {
            return new IntWritable();
        }

        @Override
        protected void parseAndSet(String str, IntWritable data, boolean force) {
            data.set(PrimitiveParser.parseInteger(str, force).intValue());
        }
    }

    public static class LazyFloatEx
    extends LazyGenericNumber<LazyFloatObjectInspector, FloatWritable> {
        public LazyFloatEx(LazyFloatObjectInspector lazyFloatObjectInspector, boolean forceRead) {
            super(lazyFloatObjectInspector, forceRead);
        }

        @Override
        protected FloatWritable newEmptyWritable() {
            return new FloatWritable();
        }

        @Override
        protected void parseAndSet(String str, FloatWritable data, boolean force) {
            data.set(PrimitiveParser.parseFloat(str, force).floatValue());
        }
    }

    public static class LazyDoubleEx
    extends LazyGenericNumber<LazyDoubleObjectInspector, DoubleWritable> {
        public LazyDoubleEx(LazyDoubleObjectInspector lazyDoubleObjectInspector, boolean forceRead) {
            super(lazyDoubleObjectInspector, forceRead);
        }

        @Override
        protected DoubleWritable newEmptyWritable() {
            return new DoubleWritable();
        }

        @Override
        protected void parseAndSet(String str, DoubleWritable data, boolean force) {
            data.set(PrimitiveParser.parseDouble(str, force).doubleValue());
        }
    }

    public static abstract class LazyGenericNumber<OI extends ObjectInspector, T extends Writable>
    extends LazyPrimitive<OI, T> {
        private final boolean forceRead;

        protected LazyGenericNumber(OI oi, boolean forceRead) {
            super(oi);
            this.data = this.newEmptyWritable();
            this.forceRead = forceRead;
        }

        protected abstract T newEmptyWritable();

        protected abstract void parseAndSet(String var1, T var2, boolean var3);

        public void init(ByteArrayRef bytes, int start, int length) {
            if (!LazyUtils.isNumberMaybe((byte[])bytes.getData(), (int)start, (int)length)) {
                this.isNull = true;
                return;
            }
            try {
                String str = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
                this.parseAndSet(str, this.data, this.forceRead);
                this.isNull = false;
            }
            catch (RuntimeException | CharacterCodingException e) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "NUMBER");
            }
        }
    }

    public static class LazyTimestampEx
    extends LazyTimestamp {
        public LazyTimestampEx(LazyTimestampObjectInspector oi) {
            super(oi);
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            String s = new String(bytes.getData(), start, length, StandardCharsets.US_ASCII);
            Timestamp t = null;
            if (s.compareTo("NULL") == 0) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
            } else {
                try {
                    t = PrimitiveParser.parseTimestamp(s);
                    this.isNull = false;
                }
                catch (IllegalArgumentException e) {
                    this.isNull = true;
                    this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
                }
            }
            ((TimestampWritable)this.data).set(t);
        }
    }

    public static class LazyDateEx
    extends LazyDate {
        public LazyDateEx(LazyDateObjectInspector oi) {
            super(oi);
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            try {
                String s = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
                ((DateWritable)this.data).set(PrimitiveParser.parseDate(s));
                this.isNull = false;
            }
            catch (Exception e) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "DATE");
            }
        }
    }

    public static class LazyQuoteAwareString
    extends LazyString {
        private final byte quote;

        public LazyQuoteAwareString(LazyStringObjectInspector oi, byte quote) {
            super(oi);
            this.quote = quote;
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            if (((LazyStringObjectInspector)this.oi).isEscaped()) {
                byte escapeChar = ((LazyStringObjectInspector)this.oi).getEscapeChar();
                byte[] inputBytes = bytes.getData();
                LazyUtils.copyAndEscapeStringDataToText((byte[])inputBytes, (int)start, (int)length, (byte)escapeChar, (Text)((Text)this.data));
            } else {
                ((Text)this.data).set(bytes.getData(), start, length);
            }
            this.isNull = false;
        }

        public void initQuoted(ByteArrayRef bytes, int fieldByteBegin, int fieldLength) {
            this.init(bytes, fieldByteBegin, fieldLength);
            this.transformDoubleQuotes();
        }

        private void transformDoubleQuotes() {
            int i;
            if (this.isNull) {
                return;
            }
            byte[] bytes = ((Text)this.data).getBytes();
            int len = ((Text)this.data).getLength();
            if (len < 2) {
                return;
            }
            for (i = 0; i < len - 1 && (bytes[i] != this.quote || bytes[i + 1] != this.quote); ++i) {
            }
            if (i == len - 1) {
                return;
            }
            int target = i;
            while (i < len) {
                if (i >= len - 1 || bytes[i] != this.quote || bytes[i + 1] == this.quote) {
                    // empty if block
                }
                int n = target++;
                int n2 = ++i;
                ++i;
                bytes[n] = bytes[n2];
            }
            ((Text)this.data).set(bytes, 0, target);
        }
    }

    public static class QuoteAwareStruct
    extends LazyStruct {
        private final boolean quoteEnabled;
        private final byte quote;
        private final boolean numberForceRead;
        private boolean[] isFieldQuoted;
        boolean selfParsed;
        int[] selfStartPosition;
        LazyObjectBase[] selfFields;
        boolean[] selfFieldInited;
        boolean selfMissingFieldWarned = false;
        boolean selfExtraFieldWarned = false;
        private transient List<Object> cachedList;

        public QuoteAwareStruct(LazySimpleStructObjectInspector oi, Byte quote, boolean numberForceRead) {
            super(oi);
            this.quoteEnabled = quote != null;
            this.quote = quote == null ? (byte)0 : quote;
            this.numberForceRead = numberForceRead;
        }

        protected LazyObjectBase createLazyField(int fieldId, StructField fieldRef) {
            ObjectInspector foi = fieldRef.getFieldObjectInspector();
            if (foi instanceof LazyBooleanObjectInspector) {
                ((LazyBooleanObjectInspector)foi).setExtendedLiteral(true);
            }
            if (foi instanceof LazyStringObjectInspector) {
                return this.quoteEnabled ? new LazyQuoteAwareString((LazyStringObjectInspector)foi, this.quote) : new LazyString((LazyStringObjectInspector)foi);
            }
            if (foi instanceof LazyDateObjectInspector) {
                return new LazyDateEx((LazyDateObjectInspector)foi);
            }
            if (foi instanceof LazyTimestampObjectInspector) {
                return new LazyTimestampEx((LazyTimestampObjectInspector)foi);
            }
            if (foi instanceof LazyDoubleObjectInspector) {
                return new LazyDoubleEx((LazyDoubleObjectInspector)foi, this.numberForceRead);
            }
            if (foi instanceof LazyFloatObjectInspector) {
                return new LazyFloatEx((LazyFloatObjectInspector)foi, this.numberForceRead);
            }
            if (foi instanceof LazyIntObjectInspector) {
                return new LazyIntEx((LazyIntObjectInspector)foi, this.numberForceRead);
            }
            if (foi instanceof LazyLongObjectInspector) {
                return new LazyLongEx((LazyLongObjectInspector)foi, this.numberForceRead);
            }
            return LazyFactory.createLazyObject((ObjectInspector)foi);
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            super.init(bytes, start, length);
            this.selfParsed = false;
        }

        public Object getField(int fieldId) {
            if (!this.selfParsed) {
                this.parse0();
            }
            return this.uncheckedGetField0(fieldId);
        }

        private void parse0() {
            byte separator = ((LazySimpleStructObjectInspector)this.oi).getSeparator();
            boolean lastColumnTakesRest = ((LazySimpleStructObjectInspector)this.oi).getLastColumnTakesRest();
            boolean isEscaped = ((LazySimpleStructObjectInspector)this.oi).isEscaped();
            byte escapeChar = ((LazySimpleStructObjectInspector)this.oi).getEscapeChar();
            this.initFieldQuoted();
            int structByteEnd = this.start + this.length;
            int fieldId = 0;
            int fieldByteBegin = this.start;
            int fieldByteEnd = this.start;
            byte[] bytes = this.bytes.getData();
            while (fieldByteEnd <= structByteEnd) {
                boolean isSep = this.checkEndField(separator, structByteEnd, fieldByteBegin, fieldByteEnd, bytes);
                if (fieldByteEnd == structByteEnd || isSep) {
                    fieldByteEnd = this.getFieldByteEnd(lastColumnTakesRest, structByteEnd, fieldId, fieldByteEnd);
                    this.checkFieldQuoted(fieldId, fieldByteBegin, fieldByteEnd, bytes);
                    this.selfStartPosition[fieldId] = fieldByteBegin;
                    if (++fieldId == this.selfFields.length || fieldByteEnd == structByteEnd) {
                        for (int i = fieldId; i <= this.selfFields.length; ++i) {
                            this.selfStartPosition[i] = fieldByteEnd + 1;
                        }
                        break;
                    }
                    fieldByteBegin = fieldByteEnd + 1;
                    ++fieldByteEnd;
                    continue;
                }
                if (isEscaped && bytes[fieldByteEnd] == escapeChar && fieldByteEnd + 1 < structByteEnd) {
                    fieldByteEnd += 2;
                    continue;
                }
                ++fieldByteEnd;
            }
            this.checkExtraBytesAtTheEnd(structByteEnd, fieldByteEnd);
            this.checkMissingFields(fieldId);
            Arrays.fill(this.selfFieldInited, false);
            this.selfParsed = true;
        }

        private int getFieldByteEnd(boolean lastColumnTakesRest, int structByteEnd, int fieldId, int fieldByteEnd) {
            if (lastColumnTakesRest && fieldId == this.selfFields.length - 1) {
                fieldByteEnd = structByteEnd;
            }
            return fieldByteEnd;
        }

        private void initFieldQuoted() {
            if (this.selfFields == null) {
                this.initLazyFields2(((LazySimpleStructObjectInspector)this.oi).getAllStructFieldRefs());
                this.isFieldQuoted = new boolean[this.selfFields.length];
            }
            Arrays.fill(this.isFieldQuoted, false);
        }

        private void checkFieldQuoted(int fieldId, int fieldByteBegin, int fieldByteEnd, byte[] bytes) {
            if (this.quoteEnabled) {
                this.isFieldQuoted[fieldId] = fieldByteEnd - fieldByteBegin >= 2 && bytes[fieldByteBegin] == this.quote && bytes[fieldByteEnd - 1] == this.quote;
            }
        }

        private void checkMissingFields(int fieldId) {
            if (!this.selfMissingFieldWarned && fieldId < this.selfFields.length) {
                this.selfMissingFieldWarned = true;
            }
        }

        private void checkExtraBytesAtTheEnd(int structByteEnd, int fieldByteEnd) {
            if (!this.selfExtraFieldWarned && fieldByteEnd < structByteEnd) {
                this.selfExtraFieldWarned = true;
            }
        }

        private boolean checkEndField(byte separator, int structByteEnd, int fieldByteBegin, int fieldByteEnd, byte[] bytes) {
            boolean isSep;
            boolean bl = isSep = fieldByteEnd == structByteEnd || bytes[fieldByteEnd] == separator;
            if (isSep && this.quoteEnabled && fieldByteBegin < structByteEnd && bytes[fieldByteBegin] == this.quote && (fieldByteEnd < fieldByteBegin + 2 || bytes[fieldByteEnd - 1] != this.quote)) {
                isSep = false;
            }
            return isSep;
        }

        private void initLazyFields2(List<? extends StructField> fieldRefs) {
            this.selfFields = new LazyObjectBase[fieldRefs.size()];
            for (int i = 0; i < this.selfFields.length; ++i) {
                try {
                    this.selfFields[i] = this.createLazyField(i, fieldRefs.get(i));
                    continue;
                }
                catch (Exception e) {
                    throw new KylinRuntimeException((Throwable)e);
                }
            }
            this.selfFieldInited = new boolean[this.selfFields.length];
            this.selfStartPosition = new int[this.selfFields.length + 1];
        }

        private Object uncheckedGetField0(int fieldId) {
            if (this.selfFieldInited[fieldId]) {
                return this.selfFields[fieldId].getObject();
            }
            this.selfFieldInited[fieldId] = true;
            int fieldByteBegin = this.selfStartPosition[fieldId];
            int fieldLength = this.selfStartPosition[fieldId + 1] - this.selfStartPosition[fieldId] - 1;
            if (this.isFieldQuoted[fieldId]) {
                ++fieldByteBegin;
                fieldLength -= 2;
            }
            if (this.isNull(((LazySimpleStructObjectInspector)this.oi).getNullSequence(), this.bytes, fieldByteBegin, fieldLength)) {
                this.selfFields[fieldId].setNull();
            } else if (this.isFieldQuoted[fieldId] && this.selfFields[fieldId] instanceof LazyQuoteAwareString) {
                ((LazyQuoteAwareString)this.selfFields[fieldId]).initQuoted(this.bytes, fieldByteBegin, fieldLength);
            } else {
                this.selfFields[fieldId].init(this.bytes, fieldByteBegin, fieldLength);
            }
            return this.selfFields[fieldId].getObject();
        }

        public List<Object> getFieldsAsList() {
            if (!this.selfParsed) {
                this.parse0();
            }
            if (this.cachedList == null) {
                this.cachedList = new ArrayList<Object>();
            } else {
                this.cachedList.clear();
            }
            for (int i = 0; i < this.selfFields.length; ++i) {
                this.cachedList.add(this.uncheckedGetField0(i));
            }
            return this.cachedList;
        }
    }
}

