/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.PreconditionMessage;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.Maps;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.javax.annotation.Nonnull;
import alluxio.util.ConfigurationUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancedConfiguration
implements AlluxioConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InstancedConfiguration.class);
    public static final AlluxioConfiguration EMPTY_CONFIGURATION = new InstancedConfiguration(new AlluxioProperties());
    protected AlluxioProperties mProperties;
    private final boolean mClusterDefaultsLoaded;

    public static InstancedConfiguration defaults() {
        return new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    public InstancedConfiguration(AlluxioProperties properties) {
        this.mProperties = properties;
        this.mClusterDefaultsLoaded = false;
    }

    public InstancedConfiguration(AlluxioProperties properties, boolean clusterDefaultsLoaded) {
        this.mProperties = properties;
        this.mClusterDefaultsLoaded = clusterDefaultsLoaded;
    }

    public InstancedConfiguration(AlluxioConfiguration conf) {
        this.mProperties = conf.copyProperties();
        this.mClusterDefaultsLoaded = conf.clusterDefaultsLoaded();
    }

    @Override
    public AlluxioProperties copyProperties() {
        return this.mProperties.copy();
    }

    @Override
    public Object get(PropertyKey key) {
        return this.get(key, ConfigurationValueOptions.defaults());
    }

    @Override
    public Object get(PropertyKey key, ConfigurationValueOptions options) {
        Object value = this.mProperties.get(key);
        if (value == null) {
            throw new RuntimeException(ExceptionMessage.UNDEFINED_CONFIGURATION_KEY.getMessage(key));
        }
        if (!(value instanceof String)) {
            return value;
        }
        if (!options.shouldUseRawValue()) {
            try {
                value = this.lookup(key, (String)value);
            }
            catch (UnresolvablePropertyException e) {
                throw new RuntimeException("Could not resolve key \"" + key.getName() + "\": " + e.getMessage(), e);
            }
        }
        if (options.shouldUseDisplayValue()) {
            PropertyKey.DisplayType displayType = key.getDisplayType();
            switch (displayType) {
                case DEFAULT: {
                    break;
                }
                case CREDENTIALS: {
                    value = "******";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid displayType %s for property %s", displayType.name(), key.getName()));
                }
            }
        }
        return value;
    }

    private boolean isResolvable(PropertyKey key) {
        Object value = this.mProperties.get(key);
        try {
            if (value instanceof String) {
                this.lookup(key, (String)value);
            }
        }
        catch (UnresolvablePropertyException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSet(PropertyKey key) {
        return this.mProperties.isSet(key) && this.isResolvable(key);
    }

    @Override
    public boolean isSetByUser(PropertyKey key) {
        return this.mProperties.isSetByUser(key) && this.isResolvable(key);
    }

    public void set(PropertyKey key, Object value) {
        this.set(key, value, Source.RUNTIME);
    }

    public void set(@Nonnull PropertyKey key, @Nonnull Object value, @Nonnull Source source) {
        Preconditions.checkArgument(!value.equals(""), "The key \"%s\" cannot be have an empty string as a value. Use ServerConfiguration.unset to remove a key from the configuration.", (Object)key);
        Preconditions.checkArgument(key.validateValue(value), "Invalid value for property key %s: %s", (Object)key, value);
        value = key.formatValue(value);
        this.mProperties.put(key, value, source);
    }

    public void unset(PropertyKey key) {
        Preconditions.checkNotNull(key, "key");
        this.mProperties.remove(key);
    }

    public void merge(Map<?, ?> properties, Source source) {
        this.mProperties.merge(properties, source);
    }

    @Override
    public Set<PropertyKey> keySet() {
        return this.mProperties.keySet();
    }

    @Override
    public Set<PropertyKey> userKeySet() {
        return this.mProperties.userKeySet();
    }

    @Override
    public String getString(PropertyKey key) {
        return (String)this.get(key);
    }

    @Override
    public int getInt(PropertyKey key) {
        return (Integer)this.get(key);
    }

    @Override
    public double getDouble(PropertyKey key) {
        return (Double)this.get(key);
    }

    @Override
    public boolean getBoolean(PropertyKey key) {
        Object rawValue = this.get(key);
        return (Boolean)rawValue;
    }

    @Override
    public List<String> getList(PropertyKey key) {
        String value = (String)this.get(key);
        return ConfigurationUtils.parseAsList(value, key.getDelimiter());
    }

    @Override
    public <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        Preconditions.checkArgument(key.getEnumType().equals(enumType), "PropertyKey %s is not of enum type", (Object)key);
        return (T)((Enum)enumType.cast(this.get(key)));
    }

    @Override
    public long getBytes(PropertyKey key) {
        return (Long)this.get(key);
    }

    @Override
    public long getMs(PropertyKey key) {
        return (Long)this.get(key);
    }

    @Override
    public Duration getDuration(PropertyKey key) {
        return Duration.ofMillis(this.getMs(key));
    }

    @Override
    public <T> Class<T> getClass(PropertyKey key) {
        Object value = this.get(key);
        if (value instanceof Class) {
            return (Class)value;
        }
        try {
            return Class.forName((String)value);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Requested class %s can not be loaded", value));
        }
    }

    @Override
    public Map<String, Object> getNestedProperties(PropertyKey prefixKey) {
        HashMap<String, Object> ret = Maps.newHashMap();
        for (Map.Entry<PropertyKey, Object> entry : this.mProperties.entrySet()) {
            String key = entry.getKey().getName();
            if (!prefixKey.isNested(key)) continue;
            String suffixKey = key.substring(prefixKey.length() + 1);
            ret.put(suffixKey, entry.getValue());
        }
        return ret;
    }

    @Override
    public Source getSource(PropertyKey key) {
        return this.mProperties.getSource(key);
    }

    @Override
    public Map<String, Object> toMap(ConfigurationValueOptions opts) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.keySet().forEach(key -> map.put(key.getName(), this.getOrDefault((PropertyKey)key, null, opts)));
        return map;
    }

    @Override
    public void validate() {
        if (!this.getBoolean(PropertyKey.CONF_VALIDATION_ENABLED)) {
            return;
        }
        for (PropertyKey key : this.keySet()) {
            Preconditions.checkState(this.getSource(key).getType() != Source.Type.SITE_PROPERTY || !key.isIgnoredSiteProperty(), "%s is not accepted in alluxio-site.properties, and must be specified as a JVM property. If no JVM property is present, Alluxio will use default value '%s'.", (Object)key.getName(), key.getDefaultValue());
            if (!PropertyKey.isDeprecated(key) || this.getSource(key).compareTo(Source.DEFAULT) == 0) continue;
            LOG.warn("{} is deprecated. Please avoid using this key in the future. {}", (Object)key.getName(), (Object)PropertyKey.getDeprecationMessage(key));
        }
        this.checkTimeouts();
        this.checkWorkerPorts();
        this.checkUserFileBufferBytes();
        this.checkZkConfiguration();
        this.checkTieredLocality();
        this.checkTieredStorage();
    }

    @Override
    public boolean clusterDefaultsLoaded() {
        return this.mClusterDefaultsLoaded;
    }

    @Override
    public String hash() {
        return this.mProperties.hash();
    }

    private Object lookup(PropertyKey key, String base) throws UnresolvablePropertyException {
        return this.lookupRecursively(key, base, new HashSet<String>());
    }

    private Object lookupRecursively(PropertyKey originalKey, String base, Set<String> seen) throws UnresolvablePropertyException {
        if (base == null) {
            throw new UnresolvablePropertyException("Can't resolve property with null value");
        }
        String resolved = base;
        Object resolvedValue = null;
        PropertyKey key = null;
        Matcher matcher = PropertyKey.CONF_REGEX.matcher(base);
        while (matcher.find()) {
            String match = matcher.group(2).trim();
            if (!seen.add(match)) {
                throw new RuntimeException(ExceptionMessage.KEY_CIRCULAR_DEPENDENCY.getMessage(match));
            }
            if (!PropertyKey.isValid(match)) {
                throw new RuntimeException(ExceptionMessage.INVALID_CONFIGURATION_KEY.getMessage(match));
            }
            key = PropertyKey.fromString(match);
            Object value = this.mProperties.get(key);
            String stringValue = null;
            if (value instanceof String) {
                stringValue = String.valueOf(this.lookupRecursively(key, (String)value, seen));
            } else if (value != null) {
                stringValue = String.valueOf(value);
            }
            seen.remove(match);
            if (stringValue == null) {
                throw new UnresolvablePropertyException(ExceptionMessage.UNDEFINED_CONFIGURATION_KEY.getMessage(match));
            }
            resolved = resolved.replaceFirst("(\\$\\{([^{}]*)\\})", Matcher.quoteReplacement(stringValue));
        }
        resolvedValue = key != null ? originalKey.parseValue(resolved) : resolved;
        return resolvedValue;
    }

    private void checkWorkerPorts() {
        int maxWorkersPerHost = this.getInt(PropertyKey.INTEGRATION_YARN_WORKERS_PER_HOST_MAX);
        if (maxWorkersPerHost > 1) {
            String message = "%s cannot be specified when allowing multiple workers per host with alluxio.integration.yarn.workers.per.host.max=" + maxWorkersPerHost;
            Preconditions.checkState(System.getProperty("alluxio.worker.rpc.port") == null, String.format(message, PropertyKey.WORKER_RPC_PORT));
            Preconditions.checkState(System.getProperty("alluxio.worker.web.port") == null, String.format(message, PropertyKey.WORKER_WEB_PORT));
        }
    }

    private void checkTimeouts() {
        long retryInterval;
        long waitTime = this.getMs(PropertyKey.MASTER_WORKER_CONNECT_WAIT_TIME);
        if (waitTime < (retryInterval = this.getMs(PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS))) {
            LOG.warn("{}={}ms is smaller than {}={}ms. Workers might not have enough time to register. Consider either increasing {} or decreasing {}", new Object[]{PropertyKey.MASTER_WORKER_CONNECT_WAIT_TIME, waitTime, PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS, retryInterval, PropertyKey.MASTER_WORKER_CONNECT_WAIT_TIME, PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS});
        }
        this.checkHeartbeatTimeout(PropertyKey.MASTER_STANDBY_HEARTBEAT_INTERVAL, PropertyKey.MASTER_HEARTBEAT_TIMEOUT);
    }

    private void checkHeartbeatTimeout(PropertyKey intervalKey, PropertyKey timeoutKey) {
        long timeout;
        long interval = this.getMs(intervalKey);
        Preconditions.checkState(interval < (timeout = this.getMs(timeoutKey)), "heartbeat interval (%s=%s) must be less than heartbeat timeout (%s=%s)", (Object)intervalKey, (Object)interval, (Object)timeoutKey, (Object)timeout);
    }

    private void checkUserFileBufferBytes() {
        if (!this.isSet(PropertyKey.USER_FILE_BUFFER_BYTES)) {
            return;
        }
        long usrFileBufferBytes = this.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES);
        Preconditions.checkState((usrFileBufferBytes & Integer.MAX_VALUE) == usrFileBufferBytes, PreconditionMessage.INVALID_USER_FILE_BUFFER_BYTES.toString(), (Object)"alluxio.user.file.buffer.bytes", usrFileBufferBytes);
    }

    private void checkZkConfiguration() {
        Preconditions.checkState(this.isSet(PropertyKey.ZOOKEEPER_ADDRESS) == this.getBoolean(PropertyKey.ZOOKEEPER_ENABLED), PreconditionMessage.INCONSISTENT_ZK_CONFIGURATION.toString(), (Object)"alluxio.zookeeper.address", (Object)"alluxio.zookeeper.enabled");
    }

    private void checkTieredLocality() {
        HashSet<String> tiers = Sets.newHashSet(this.getList(PropertyKey.LOCALITY_ORDER));
        HashSet<? extends PropertyKey> predefinedKeys = new HashSet<PropertyKey>(PropertyKey.defaultKeys());
        for (PropertyKey key : this.mProperties.keySet()) {
            String tierName;
            Matcher matcher;
            if (predefinedKeys.contains(key) || !(matcher = PropertyKey.Template.LOCALITY_TIER.match(key.toString())).matches() || matcher.group(1) == null || tiers.contains(tierName = matcher.group(1))) continue;
            throw new IllegalStateException(String.format("Tier %s is configured by %s, but does not exist in the tier list %s configured by %s", tierName, key, tiers, PropertyKey.LOCALITY_ORDER));
        }
    }

    @VisibleForTesting
    void checkTieredStorage() {
        int globalTiers = this.getInt(PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVELS);
        HashSet<String> globalTierAliasSet = new HashSet<String>();
        for (int i = 0; i < globalTiers; ++i) {
            globalTierAliasSet.add(this.getString(PropertyKey.Template.MASTER_TIERED_STORE_GLOBAL_LEVEL_ALIAS.format(i)));
        }
        int workerTiers = this.getInt(PropertyKey.WORKER_TIERED_STORE_LEVELS);
        Preconditions.checkState(workerTiers <= globalTiers, "%s tiers on worker (configured by %s), larger than global %s tiers (configured by %s) ", (Object)workerTiers, (Object)PropertyKey.WORKER_TIERED_STORE_LEVELS, (Object)globalTiers, (Object)PropertyKey.MASTER_TIERED_STORE_GLOBAL_LEVELS);
        for (int i = 0; i < workerTiers; ++i) {
            PropertyKey key = PropertyKey.Template.WORKER_TIERED_STORE_LEVEL_ALIAS.format(i);
            String alias = this.getString(key);
            Preconditions.checkState(globalTierAliasSet.contains(alias), "Alias \"%s\" on tier %s on worker (configured by %s) is not found in global tiered storage setting: %s", (Object)alias, (Object)i, (Object)key, (Object)String.join((CharSequence)", ", globalTierAliasSet));
        }
    }

    private class UnresolvablePropertyException
    extends Exception {
        public UnresolvablePropertyException(String msg) {
            super(msg);
        }
    }
}

