/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.TimeBoundPageStore;
import alluxio.client.file.cache.store.LocalPageStore;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.MemoryPageStore;
import alluxio.client.file.cache.store.MemoryPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.client.file.cache.store.RocksPageStore;
import alluxio.client.file.cache.store.RocksPageStoreOptions;
import alluxio.exception.PageNotFoundException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.util.io.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PageStore
extends AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(PageStore.class);

    public static PageStore create(PageStoreOptions options) throws IOException {
        PageStore.initialize(options);
        return PageStore.open(options);
    }

    public static PageStore open(PageStoreOptions options) throws IOException {
        PageStore pageStore;
        LOG.info("Opening PageStore with option={}", (Object)options.toString());
        switch (options.getType()) {
            case LOCAL: {
                pageStore = new LocalPageStore((LocalPageStoreOptions)options.toOptions());
                break;
            }
            case ROCKS: {
                pageStore = RocksPageStore.open((RocksPageStoreOptions)options.toOptions());
                break;
            }
            case MEM: {
                pageStore = new MemoryPageStore((MemoryPageStoreOptions)options.toOptions());
                break;
            }
            default: {
                throw new IllegalArgumentException("Incompatible PageStore " + (Object)((Object)options.getType()) + " specified");
            }
        }
        if (options.getTimeoutDuration() > 0L) {
            return new TimeBoundPageStore(pageStore, options);
        }
        return pageStore;
    }

    public static List<Path> getStorePath(PageStoreType storeType, String rootDir) {
        String[] rootDirs = rootDir.split(",");
        return Arrays.stream(rootDirs).map(dir -> Paths.get(dir, storeType.name())).collect(Collectors.toList());
    }

    public static void initialize(PageStoreOptions options) throws IOException {
        if (options.getType() == PageStoreType.MEM) {
            return;
        }
        for (Path rootPath : options.getRootDirs()) {
            Files.createDirectories(rootPath, new FileAttribute[0]);
            LOG.info("Cleaning cache directory {}", (Object)rootPath);
            Stream<Path> stream = Files.list(rootPath);
            Throwable throwable = null;
            try {
                stream.forEach(path -> {
                    try {
                        FileUtils.deletePathRecursively(path.toString());
                    }
                    catch (IOException e) {
                        Metrics.CACHE_CLEAN_ERRORS.inc();
                        LOG.warn("failed to delete {} in cache directory: {}", path, (Object)e.toString());
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    public void put(PageId var1, byte[] var2) throws ResourceExhaustedException, IOException;

    default public int get(PageId pageId, byte[] buffer) throws IOException, PageNotFoundException {
        return this.get(pageId, 0, buffer.length, buffer, 0);
    }

    public int get(PageId var1, int var2, int var3, byte[] var4, int var5) throws IOException, PageNotFoundException;

    public void delete(PageId var1) throws IOException, PageNotFoundException;

    public Stream<PageInfo> getPages() throws IOException;

    public long getCacheSize();

    public static final class Metrics {
        private static final Counter CACHE_CLEAN_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CLEAN_ERRORS.getName());
    }
}

