/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v1;

import org.apache.gluten.row.SparkRowInfo;
import org.apache.gluten.vectorized.CHBlockConverterJniWrapper;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BlockStripe;
import org.apache.spark.sql.execution.datasources.BlockStripes;
import org.apache.spark.sql.execution.utils.CHExecUtil;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.jetbrains.annotations.NotNull;
import scala.collection.Iterator;

public class CHBlockStripes
extends BlockStripes {
    private final SparkRowInfo sparkRowInfo = CHBlockConverterJniWrapper.convertColumnarToRow(this.originBlockAddress, this.headingRowIndice);
    private final Iterator<InternalRow> headingRowIter = CHExecUtil.getRowIterFromSparkRowInfo(this.sparkRowInfo, this.originBlockNumColumns, this.headingRowIndice.length);
    private int index = -1;

    public CHBlockStripes(BlockStripes bs) {
        super(bs.originBlockAddress, bs.blockAddresses, bs.headingRowIndice, bs.originBlockNumColumns);
    }

    @NotNull
    public java.util.Iterator<BlockStripe> iterator() {
        return new java.util.Iterator<BlockStripe>(){

            @Override
            public boolean hasNext() {
                return CHBlockStripes.this.headingRowIter.hasNext();
            }

            @Override
            public BlockStripe next() {
                CHBlockStripes.this.index = CHBlockStripes.this.index + 1;
                final InternalRow headingRow = (InternalRow)CHBlockStripes.this.headingRowIter.next();
                return new BlockStripe(){

                    public ColumnarBatch getColumnarBatch() {
                        CHNativeBlock nativeBlock = new CHNativeBlock(CHBlockStripes.this.blockAddresses[CHBlockStripes.this.index]);
                        return nativeBlock.toColumnarBatch();
                    }

                    public InternalRow getHeadingRow() {
                        return headingRow;
                    }
                };
            }
        };
    }

    public void release() {
        for (long address : this.blockAddresses) {
            CHBlockConverterJniWrapper.freeBlock(address);
        }
    }
}

