/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import java.util.Date;
import org.apache.gluten.memory.CHThreadGroup;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.TaskOutputFileAlreadyExistException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.delta.ClickhouseSnapshot$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.catalog.ClickHouseTableV2;
import org.apache.spark.sql.delta.catalog.ClickHouseTableV2$;
import org.apache.spark.sql.delta.commands.OptimizeTableCommandOverwrites;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.CHDatasourceJniWrapper;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.v1.CHMergeTreeWriterInjects$;
import org.apache.spark.sql.execution.datasources.v1.PlanWithSplitInfo;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddFileTags$;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddMergeTreeParts;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.utils.CHDataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class OptimizeTableCommandOverwrites$
implements Logging {
    public static OptimizeTableCommandOverwrites$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OptimizeTableCommandOverwrites$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private WriteTaskResult executeTask(OptimizeTableCommandOverwrites.TaskDescription description, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber) {
        WriteTaskResult writeTaskResult;
        CHThreadGroup.registerNewThreadGroup();
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(description.jobIdInstant()), sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", jobId.toString());
        hadoopConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, taskAttemptId);
        try {
            writeTaskResult = (WriteTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                PlanWithSplitInfo planWithSplitInfo = CHMergeTreeWriterInjects$.MODULE$.genMergeTreeWriteRel(description.path(), description.database(), description.tableName(), description.snapshotId(), description.orderByKey(), description.lowCardKey(), description.minmaxIndexKey(), description.bfIndexKey(), description.setIndexKey(), description.primaryKey(), description.partitionColumns(), description.partList(), description.tableSchema(), description.clickhouseTableConfigs(), (Seq<Attribute>)description.tableSchema().toAttributes());
                String returnedMetrics = CHDatasourceJniWrapper.nativeMergeMTParts(planWithSplitInfo.splitInfo(), (String)description.partitionDir().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)description.bucketDir().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                if (returnedMetrics != null && new StringOps(Predef$.MODULE$.augmentString(returnedMetrics)).nonEmpty()) {
                    Seq<AddFile> addFiles = AddFileTags$.MODULE$.partsMetricsToAddFile(description.database(), description.tableName(), description.path(), returnedMetrics, (Seq<String>)((Seq)new .colon.colon((Object)Utils$.MODULE$.localHostName(), (List)Nil$.MODULE$)));
                    Tuple2 tuple22 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable & scala.Serializable)() -> new FileCommitProtocol.TaskCommitMessage((Object)addFiles.toSeq()));
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    FileCommitProtocol.TaskCommitMessage taskCommitMessage = (FileCommitProtocol.TaskCommitMessage)tuple22._1();
                    long taskCommitTime = tuple22._2$mcJ$sp();
                    tuple2 = new Tuple2((Object)taskCommitMessage, (Object)BoxesRunTime.boxToLong((long)taskCommitTime));
                } else {
                    throw new IllegalStateException();
                }
                Tuple2 tuple23 = tuple2;
                FileCommitProtocol.TaskCommitMessage taskCommitMessage = (FileCommitProtocol.TaskCommitMessage)tuple23._1();
                long taskCommitTime = tuple23._2$mcJ$sp();
                return new WriteTaskResult(taskCommitMessage, null);
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Job ").append(jobId).append(" aborted.").toString()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FetchFailedException) {
                FetchFailedException fetchFailedException = (FetchFailedException)throwable2;
                throw fetchFailedException;
            }
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                if (SQLConf$.MODULE$.get().fastFailFileFormatOutput()) {
                    throw new TaskOutputFileAlreadyExistException((Throwable)fileAlreadyExistsException);
                }
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw QueryExecutionErrors$.MODULE$.taskFailedWhileWritingRowsError(throwable3);
            }
            throw throwable;
        }
        return writeTaskResult;
    }

    public Seq<FileAction> runOptimizeBinJobClickhouse(OptimisticTransaction txn, Map<String, String> partitionValues, String bucketNum, Seq<AddFile> bin, long maxFileSize) {
        ClickHouseTableV2 tableV2 = ClickHouseTableV2$.MODULE$.getTable(txn.deltaLog());
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
        RDD rddWithNonEmptyPartitions = sparkSession.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))), 1, ClassTag$.MODULE$.apply(InternalRow.class));
        long jobIdInstant = new Date().getTime();
        WriteTaskResult[] ret = new WriteTaskResult[rddWithNonEmptyPartitions.partitions().length];
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConfWithOptions(txn.metadata().configuration().$plus$plus(txn.deltaLog().options())));
        None$ partitionDir = tableV2.partitionColumns().isEmpty() ? None$.MODULE$ : new Some((Object)((TraversableOnce)tableV2.partitionColumns().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(1).append((String)c).append("=").append(partitionValues.apply(c)).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/"));
        None$ bucketDir = tableV2.bucketOption().isEmpty() ? None$.MODULE$ : new Some((Object)bucketNum);
        OptimizeTableCommandOverwrites.TaskDescription description = new OptimizeTableCommandOverwrites.TaskDescription(txn.deltaLog().dataPath().toString(), tableV2.dataBaseName(), tableV2.tableName(), ClickhouseSnapshot$.MODULE$.genSnapshotId(tableV2.snapshot()), tableV2.orderByKey(), tableV2.lowCardKey(), tableV2.minmaxIndexKey(), tableV2.bfIndexKey(), tableV2.setIndexKey(), tableV2.primaryKey(), tableV2.partitionColumns(), (Seq<String>)((Seq)bin.map((Function1 & Serializable & scala.Serializable)x$2 -> ((AddMergeTreeParts)((Object)x$2)).name(), Seq$.MODULE$.canBuildFrom())), tableV2.schema(), tableV2.clickhouseTableConfigs(), serializableHadoopConf, jobIdInstant, (Option<String>)partitionDir, (Option<String>)bucketDir);
        sparkSession.sparkContext().runJob(rddWithNonEmptyPartitions, (Function2 & Serializable & scala.Serializable)(taskContext, x$3) -> MODULE$.executeTask(description, taskContext.stageId(), taskContext.partitionId(), (int)taskContext.taskAttemptId() & Integer.MAX_VALUE), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddWithNonEmptyPartitions.partitions())).indices(), (Function2 & Serializable & scala.Serializable)(index, res) -> {
            ret[BoxesRunTime.unboxToInt((Object)index)] = res;
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(WriteTaskResult.class));
        Seq addFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4.commitMsg().obj(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddFile.class))))).toSeq();
        Seq removeFiles = (Seq)bin.map((Function1 & Serializable & scala.Serializable)f -> f.removeWithTimestamp(new SystemClock().getTimeMillis(), false), Seq$.MODULE$.canBuildFrom());
        return (Seq)addFiles.$plus$plus((GenTraversableOnce)removeFiles, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public DeltaLog getDeltaLogClickhouse(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        block7: {
            block8: {
                block10: {
                    block9: {
                        block6: {
                            if (!path.nonEmpty()) break block6;
                            v0 = new Path((String)path.get());
                            break block7;
                        }
                        if (!tableIdentifier.nonEmpty()) break block8;
                        metadata$lzy = new LazyRef();
                        sessionCatalog = spark.sessionState().catalog();
                        if (!CHDataSourceUtils$.MODULE$.isClickhousePath(spark, (TableIdentifier)tableIdentifier.get())) break block9;
                        v0 = new Path(((TableIdentifier)tableIdentifier.get()).table());
                        break block7;
                    }
                    if (!CHDataSourceUtils$.MODULE$.isClickHouseTable(spark, (TableIdentifier)tableIdentifier.get())) break block10;
                    v0 = new Path(OptimizeTableCommandOverwrites$.metadata$1(metadata$lzy, sessionCatalog, tableIdentifier).location());
                    break block7;
                }
                var10_8 = false;
                var11_9 = null;
                var12_10 = DeltaTableIdentifier$.MODULE$.apply(spark, (TableIdentifier)tableIdentifier.get());
                if (!(var12_10 instanceof Some)) ** GOTO lbl-1000
                var10_8 = true;
                var11_9 = (Some)var12_10;
                id = (DeltaTableIdentifier)var11_9.value();
                if (id.path().nonEmpty()) {
                    var6_12 = new Path((String)id.path().get());
                } else if (var10_8 && (id = (DeltaTableIdentifier)var11_9.value()).table().nonEmpty()) {
                    var6_12 = new Path(OptimizeTableCommandOverwrites$.metadata$1(metadata$lzy, sessionCatalog, tableIdentifier).location());
                } else {
                    v1 = OptimizeTableCommandOverwrites$.metadata$1(metadata$lzy, sessionCatalog, tableIdentifier).tableType();
                    var15_14 = CatalogTableType$.MODULE$.VIEW();
                    if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                        throw DeltaErrors$.MODULE$.viewNotSupported(operationName);
                    }
                    throw DeltaErrors$.MODULE$.notADeltaTableException(operationName);
                }
                v0 = var6_12;
                break block7;
            }
            throw DeltaErrors$.MODULE$.missingTableIdentifierException(operationName);
        }
        tablePath = v0;
        startTime = new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        deltaLog = DeltaLog$.MODULE$.forTable(spark, tablePath, hadoopConf);
        x$1 = startTime;
        x$2 = deltaLog.update$default$1();
        if (deltaLog.update(x$2, (Option<Object>)x$1).version() < 0L) {
            throw DeltaErrors$.MODULE$.notADeltaTableException(operationName, new DeltaTableIdentifier(path, tableIdentifier));
        }
        return deltaLog;
    }

    public Map<String, String> getDeltaLogClickhouse$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public Seq<Tuple2<Tuple2<String, Map<String, String>>, Seq<AddFile>>> groupFilesIntoBinsClickhouse(Seq<Tuple2<Tuple2<String, Map<String, String>>, Seq<AddFile>>> partitionsToCompact, long maxTargetFileSize) {
        return (Seq)partitionsToCompact.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 partition = (Tuple2)tuple2._1();
            Seq files = (Seq)tuple2._2();
            ArrayBuffer bins = new ArrayBuffer();
            ArrayBuffer currentBin = new ArrayBuffer();
            LongRef currentBinSize = LongRef.create((long)0L);
            ((IterableLike)files.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.size()), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                OptimizeTableCommandOverwrites$.$anonfun$groupFilesIntoBinsClickhouse$3(currentBinSize, maxTargetFileSize, bins, currentBin, file);
                return BoxedUnit.UNIT;
            });
            Object object = currentBin.nonEmpty() ? bins.$plus$eq((Object)currentBin.toVector()) : BoxedUnit.UNIT;
            ArrayBuffer arrayBuffer = (ArrayBuffer)((TraversableLike)bins.map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)partition, b), ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptimizeTableCommandOverwrites$.$anonfun$groupFilesIntoBinsClickhouse$5(x$6)));
            return arrayBuffer;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final /* synthetic */ CatalogTable metadata$lzycompute$1(LazyRef metadata$lzy$1, SessionCatalog sessionCatalog$1, Option tableIdentifier$1) {
        CatalogTable catalogTable;
        LazyRef lazyRef = metadata$lzy$1;
        synchronized (lazyRef) {
            catalogTable = metadata$lzy$1.initialized() ? (CatalogTable)metadata$lzy$1.value() : (CatalogTable)metadata$lzy$1.initialize((Object)sessionCatalog$1.getTableMetadata((TableIdentifier)tableIdentifier$1.get()));
        }
        return catalogTable;
    }

    private static final CatalogTable metadata$1(LazyRef metadata$lzy$1, SessionCatalog sessionCatalog$1, Option tableIdentifier$1) {
        return metadata$lzy$1.initialized() ? (CatalogTable)metadata$lzy$1.value() : OptimizeTableCommandOverwrites$.metadata$lzycompute$1(metadata$lzy$1, sessionCatalog$1, tableIdentifier$1);
    }

    public static final /* synthetic */ void $anonfun$groupFilesIntoBinsClickhouse$3(LongRef currentBinSize$1, long maxTargetFileSize$1, ArrayBuffer bins$1, ArrayBuffer currentBin$1, AddFile file) {
        if (file.size() + currentBinSize$1.elem > maxTargetFileSize$1) {
            bins$1.$plus$eq((Object)currentBin$1.toVector());
            currentBin$1.clear();
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem = file.size();
        } else {
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem += file.size();
        }
    }

    public static final /* synthetic */ boolean $anonfun$groupFilesIntoBinsClickhouse$5(Tuple2 x$6) {
        return ((SeqLike)x$6._2()).size() > 1;
    }

    private OptimizeTableCommandOverwrites$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

