/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.io.InputStream;
import org.apache.gluten.backendsapi.clickhouse.CHBackendSettings;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.gluten.vectorized.ShuffleInputStream;
import org.apache.spark.storage.CHShuffleReadStreamFactory;

public class CHStreamReader
implements AutoCloseable {
    private final ShuffleInputStream inputStream;
    private long nativeShuffleReader;

    public CHStreamReader(InputStream inputStream, boolean forceCompress, boolean isCustomizedShuffleCodec) {
        this(CHShuffleReadStreamFactory.create(inputStream, forceCompress, isCustomizedShuffleCodec));
    }

    public CHStreamReader(ShuffleInputStream shuffleInputStream) {
        this.inputStream = shuffleInputStream;
        this.nativeShuffleReader = CHStreamReader.createNativeShuffleReader(this.inputStream, this.inputStream.isCompressed(), CHBackendSettings.maxShuffleReadRows(), CHBackendSettings.maxShuffleReadBytes());
    }

    private static native long createNativeShuffleReader(ShuffleInputStream var0, boolean var1, long var2, long var4);

    private native long nativeNext(long var1);

    public CHNativeBlock next() {
        long block = this.nativeNext(this.nativeShuffleReader);
        return new CHNativeBlock(block);
    }

    private native void nativeClose(long var1);

    @Override
    public void close() throws Exception {
        this.inputStream.close();
        this.nativeClose(this.nativeShuffleReader);
        this.nativeShuffleReader = 0L;
    }
}

