/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobDiagInfoTool
extends AbstractInfoExtractorTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobDiagInfoTool.class);
    private static final Option OPTION_STREAMING_JOB_ID = OptionBuilder.getInstance().withArgName("streamingJob").hasArg().isRequired(true).withDescription("specify the Streaming Job ID to extract information. ").create("streamingJob");
    private static final Option OPTION_STREAMINIG_PROJECT = OptionBuilder.getInstance().withArgName("project").hasArg().isRequired(false).withDescription("specify the Project ").create("project");
    private static final Option OPTION_STREAMING_INCLUDE_YARN_LOGS = OptionBuilder.getInstance().withArgName("includeYarnLogs").hasArg().isRequired(false).withDescription("set this to true if want to extract related streaming yarn logs too. Default true").create("includeYarnLogs");
    private static final Option OPTION_STREAMING_INCLUDE_CLIENT = OptionBuilder.getInstance().withArgName("includeClient").hasArg().isRequired(false).withDescription("Specify whether to include client info to extract. Default true.").create("includeClient");
    private static final Option OPTION_STREAMING_INCLUDE_CONF = OptionBuilder.getInstance().withArgName("includeConf").hasArg().isRequired(false).withDescription("Specify whether to include conf files to extract. Default true.").create("includeConf");
    private static final Option OPTION_STREAMING_META = OptionBuilder.getInstance().withArgName("includeMeta").hasArg().isRequired(false).withDescription("Specify whether to include metadata to extract. Default true.").create("includeMeta");
    private static final Option OPTION_STREAMING_AUDIT_LOG = OptionBuilder.getInstance().withArgName("includeAuditLog").hasArg().isRequired(false).withDescription("Specify whether to include auditLog to extract. Default true.").create("includeAuditLog");
    private static final String OPT_STREAMING_JOB = "-job";

    public StreamingJobDiagInfoTool() {
        this.setPackageType("streaming-job");
        this.options.addOption(OPTION_STREAMINIG_PROJECT);
        this.options.addOption(OPTION_STREAMING_JOB_ID);
        this.options.addOption(OPTION_STREAMING_INCLUDE_CLIENT);
        this.options.addOption(OPTION_STREAMING_INCLUDE_YARN_LOGS);
        this.options.addOption(OPTION_STREAMING_INCLUDE_CONF);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_STREAMING_META);
        this.options.addOption(OPTION_STREAMING_AUDIT_LOG);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        String modelId;
        String jobId = optionsHelper.getOptionValue(OPTION_STREAMING_JOB_ID);
        boolean includeClient = this.getBooleanOption(optionsHelper, OPTION_STREAMING_INCLUDE_CLIENT, true);
        boolean includeConf = this.getBooleanOption(optionsHelper, OPTION_STREAMING_INCLUDE_CONF, true);
        boolean includeMeta = this.getBooleanOption(optionsHelper, OPTION_STREAMING_META, true);
        boolean includeAuditLog = this.getBooleanOption(optionsHelper, OPTION_STREAMING_AUDIT_LOG, false);
        boolean includeBin = true;
        long diagStartTime = System.currentTimeMillis();
        File recordTimeFile = new File(exportDir, "time_used_info");
        StreamingJobMeta job = this.getJobById(jobId);
        if (Objects.isNull(job)) {
            log.error("Can not find the streaming jobId: {}", (Object)jobId);
            throw new RuntimeException(String.format(Locale.ROOT, "Can not find the jobId: %s", jobId));
        }
        String project = job.getProject();
        long createTime = job.getCreateTime();
        long endTime = job.getLastModified() != 0L ? job.getLastModified() : System.currentTimeMillis();
        log.info("job project: {}, job Id: {}, createTime: {}, endTime: {}", new Object[]{project, jobId, createTime, endTime});
        if (includeMeta) {
            File metadataDir = new File(exportDir, "metadata");
            FileUtils.forceMkdir((File)metadataDir);
            String[] metaToolArgs = new String[]{"-backup", "-dir", metadataDir.getAbsolutePath(), "-project", project, "-excludeTableExd"};
            this.dumpMetadata(metaToolArgs, recordTimeFile);
        }
        if (includeAuditLog) {
            File auditLogDir = new File(exportDir, "audit_log");
            FileUtils.forceMkdir((File)auditLogDir);
            String[] auditLogToolArgs = new String[]{OPT_STREAMING_JOB, jobId, "-project", project, "-dir", auditLogDir.getAbsolutePath()};
            this.exportAuditLog(auditLogToolArgs, recordTimeFile);
        }
        if (StringUtils.isNotEmpty((CharSequence)(modelId = job.getModelId()))) {
            this.exportRecCandidate(project, modelId, exportDir, false, recordTimeFile);
        }
        String[] sparkLogArgs = new String[]{"-dir", exportDir.getAbsolutePath(), OPT_STREAMING_JOB, jobId, "-project", project};
        this.dumpStreamingSparkLog(sparkLogArgs, recordTimeFile);
        if (includeClient) {
            this.exportClient(recordTimeFile);
        }
        this.exportJstack(recordTimeFile);
        this.exportConf(exportDir, recordTimeFile, includeConf, true);
        this.exportKgLogs(exportDir, createTime, endTime, recordTimeFile);
        this.exportInfluxDBMetrics(exportDir, recordTimeFile);
        this.executeTimeoutTask(this.taskQueue);
        this.executorService.shutdown();
        this.awaitDiagPackageTermination(this.getKapConfig().getDiagPackageTimeout());
        this.recordTaskStartTime(DiagSubTaskEnum.LOG);
        KylinLogTool.extractKylinLog(exportDir, jobId);
        KylinLogTool.extractOtherLogs(exportDir, createTime, endTime);
        this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG, recordTimeFile);
        DiagnosticFilesChecker.writeMsgToFile("Total files", System.currentTimeMillis() - diagStartTime, recordTimeFile);
    }

    public StreamingJobMeta getJobById(String jobId) {
        List projectList = NProjectManager.getInstance((KylinConfig)this.getKylinConfig()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        for (String project : projectList) {
            StreamingJobMeta streamJob = StreamingJobManager.getInstance((KylinConfig)this.getKylinConfig(), (String)project).getStreamingJobByUuid(jobId);
            if (!Objects.nonNull(streamJob)) continue;
            return streamJob;
        }
        return null;
    }
}

