/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.util.concurrent.Future;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.snapshot.SnapshotSourceTableStatsTool;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagClientTool
extends AbstractInfoExtractorTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().withArgName("project").hasArg().isRequired(false).withDescription("Specify realizations in which project to extract").create("project");
    private static final Option OPTION_CONF = OptionBuilder.getInstance().withArgName("includeConf").hasArg().isRequired(false).withDescription("Specify whether to include conf files to extract. Default true.").create("includeConf");
    private static final Option OPTION_META = OptionBuilder.getInstance().withArgName("includeMeta").hasArg().isRequired(false).withDescription("Specify whether to include metadata to extract. Default true.").create("includeMeta");
    private static final Option OPTION_LOG = OptionBuilder.getInstance().withArgName("includeLog").hasArg().isRequired(false).withDescription("Specify whether to include logs to extract. Default true.").create("includeLog");
    private static final Option OPTION_SPARK = OptionBuilder.getInstance().withArgName("includeSpark").hasArg().isRequired(false).withDescription("Specify whether to include spark conf to extract. Default false.").create("includeSpark");
    private static final Option OPTION_CLIENT = OptionBuilder.getInstance().withArgName("includeClient").hasArg().isRequired(false).withDescription("Specify whether to include client info to extract. Default true.").create("includeClient");
    private static final Option OPTION_AUDIT_LOG = OptionBuilder.getInstance().withArgName("includeAuditLog").hasArg().isRequired(false).withDescription("Specify whether to include auditLog to extract. Default true.").create("includeAuditLog");
    private static final Option OPTION_BEFORE_DAY = OptionBuilder.getInstance().withArgName("beforeDay").hasArg().isRequired(false).withDescription("Specify the range of time to extract use info. Default last 30 days.").create("beforeDay");
    private static final Option OPTION_CATE_BASE = OptionBuilder.getInstance().withArgName("base").hasArg().isRequired(false).withDescription("package components include base").create("base");
    private static final Option OPTION_CATE_QUERY = OptionBuilder.getInstance().withArgName("query").hasArg().isRequired(false).withDescription("package components include slow and failed query").create("query");
    private static final Option OPTION_CATE_META = OptionBuilder.getInstance().withArgName("meta").hasArg().isRequired(false).withDescription("package components include wrong metadata operation").create("meta");

    public DiagClientTool() {
        this.setPackageType("full");
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_CONF);
        this.options.addOption(OPTION_CLIENT);
        this.options.addOption(OPTION_SPARK);
        this.options.addOption(OPTION_CURRENT_TIME);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_CATE_BASE);
        this.options.addOption(OPTION_CATE_QUERY);
        this.options.addOption(OPTION_CATE_META);
        this.options.addOption(OPTION_META);
        this.options.addOption(OPTION_AUDIT_LOG);
        this.options.addOption(OPTION_BEFORE_DAY);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        long endTime;
        boolean includeConf = this.getBooleanOption(optionsHelper, OPTION_CONF, this.getBooleanOption(optionsHelper, OPTION_CATE_BASE, true));
        boolean includeMeta = this.getBooleanOption(optionsHelper, OPTION_META, this.getBooleanOption(optionsHelper, OPTION_CATE_BASE, true));
        boolean includeClient = this.getBooleanOption(optionsHelper, OPTION_CLIENT, this.getBooleanOption(optionsHelper, OPTION_CATE_BASE, true));
        boolean includeLog = this.getBooleanOption(optionsHelper, OPTION_LOG, this.getBooleanOption(optionsHelper, OPTION_CATE_BASE, true));
        boolean includeAuditLog = this.getBooleanOption(optionsHelper, OPTION_AUDIT_LOG, this.getBooleanOption(optionsHelper, OPTION_CATE_BASE, false));
        boolean includeBin = true;
        long startTime = this.getLongOption(optionsHelper, OPTION_START_TIME, this.getDefaultStartTime());
        if (startTime >= (endTime = this.getLongOption(optionsHelper, OPTION_END_TIME, this.getDefaultEndTime()))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_TIMESTAMP_COMPARE, new Object[0]);
        }
        int useInfoBeforeDay = this.getIntOption(optionsHelper, OPTION_BEFORE_DAY, 30);
        logger.info("Time range: start={}, end={}", (Object)startTime, (Object)endTime);
        long start = System.currentTimeMillis();
        File recordTime = new File(exportDir, "time_used_info");
        if (includeMeta) {
            File metaDir = new File(exportDir, "metadata");
            FileUtils.forceMkdir((File)metaDir);
            String[] metaToolArgs = new String[]{"-backup", "-dir", metaDir.getAbsolutePath(), "-compress", "false", "-excludeTableExd"};
            this.dumpMetadata(metaToolArgs, recordTime);
            this.exportJobInfo(startTime, endTime, recordTime);
            this.exportFavoriteRule(null, recordTime);
            this.exportAsyncTask(null, recordTime);
            this.exportQueryHistoryOffset(null, recordTime);
        }
        if (includeAuditLog) {
            File auditLogDir = new File(exportDir, "audit_log");
            FileUtils.forceMkdir((File)auditLogDir);
            String[] auditLogToolArgs = new String[]{"-startTime", String.valueOf(startTime), "-endTime", String.valueOf(endTime), "-dir", auditLogDir.getAbsolutePath()};
            this.exportAuditLog(auditLogToolArgs, recordTime);
        }
        this.exportRecCandidate(null, null, exportDir, true, recordTime);
        if (includeClient) {
            this.exportClient(recordTime);
        }
        String[] sparkLogArgs = new String[]{"-dir", exportDir.getAbsolutePath(), "-startTime", String.valueOf(startTime), "-endTime", String.valueOf(endTime)};
        this.dumpStreamingSparkLog(sparkLogArgs, recordTime);
        this.exportJstack(recordTime);
        this.exportConf(exportDir, recordTime, includeConf, true);
        this.exportInfluxDBMetrics(exportDir, recordTime);
        this.exportSparkLog(exportDir, startTime, endTime, recordTime, null);
        this.exportCandidateLog(exportDir, recordTime, startTime, endTime);
        this.exportKgLogs(exportDir, startTime, endTime, recordTime);
        this.exportSystemUsageInfo(recordTime, DateTime.now().minusDays(useInfoBeforeDay).withTimeAtStartOfDay().getMillis(), Long.MAX_VALUE);
        this.extractSnapshotAutoUpdate(exportDir, recordTime);
        this.executeTimeoutTask(this.taskQueue);
        this.executorService.shutdown();
        this.awaitDiagPackageTermination(this.getKapConfig().getDiagPackageTimeout());
        if (includeLog) {
            this.recordTaskStartTime(DiagSubTaskEnum.LOG);
            KylinLogTool.extractKylinLog(exportDir, startTime, endTime);
            KylinLogTool.extractOtherLogs(exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG, recordTime);
        }
        DiagnosticFilesChecker.writeMsgToFile("Total files", System.currentTimeMillis() - start, recordTime);
    }

    public void extractSnapshotAutoUpdate(File exportDir, File recordTime) {
        Future<?> sourceTableStatsTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SOURCE_TABLE_STATS);
            SnapshotSourceTableStatsTool.extractSnapshotAutoUpdate(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SOURCE_TABLE_STATS, recordTime);
        });
        this.scheduleTimeoutTask(sourceTableStatsTask, DiagSubTaskEnum.SOURCE_TABLE_STATS);
    }
}

