/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.mapred.OrcMapredRecordWriter;

public class OrcOutputFormat<V extends Writable>
extends FileOutputFormat<NullWritable, V> {
    public static OrcFile.WriterOptions buildOptions(Configuration conf) {
        return OrcFile.writerOptions((Configuration)conf).version(OrcFile.Version.byName((String)OrcConf.WRITE_FORMAT.getString(conf))).setSchema(TypeDescription.fromString((String)OrcConf.MAPRED_OUTPUT_SCHEMA.getString(conf))).compress(CompressionKind.valueOf((String)OrcConf.COMPRESS.getString(conf))).encodingStrategy(OrcFile.EncodingStrategy.valueOf((String)OrcConf.ENCODING_STRATEGY.getString(conf))).bloomFilterColumns(OrcConf.BLOOM_FILTER_COLUMNS.getString(conf)).bloomFilterFpp(OrcConf.BLOOM_FILTER_FPP.getDouble(conf)).blockSize(OrcConf.BLOCK_SIZE.getLong(conf)).blockPadding(OrcConf.BLOCK_PADDING.getBoolean(conf)).stripeSize(OrcConf.STRIPE_SIZE.getLong(conf)).rowIndexStride((int)OrcConf.ROW_INDEX_STRIDE.getLong(conf)).bufferSize((int)OrcConf.BUFFER_SIZE.getLong(conf)).paddingTolerance(OrcConf.BLOCK_PADDING_TOLERANCE.getDouble(conf)).encrypt(OrcConf.ENCRYPTION.getString(conf)).masks(OrcConf.DATA_MASK.getString(conf));
    }

    public RecordWriter<NullWritable, V> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable progressable) throws IOException {
        Path path = OrcOutputFormat.getTaskOutputPath((JobConf)conf, (String)name);
        Writer writer = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcOutputFormat.buildOptions((Configuration)conf).fileSystem(fileSystem));
        return new OrcMapredRecordWriter(writer);
    }
}

