/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.rest.webmvc.mapping.Associations;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.EntityAssociationContext;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;

public class EntityAssociationsExtractor
implements EntityOperationsExtractor {
    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        Associations associations = context.getAssociations();
        context.entity().ifPresent(entity -> entity.doWithAssociations(association -> {
            if (associations.isLinkableAssociation(association)) {
                EntityAssociationContext associationContext = new EntityAssociationContext(context, association);
                handlers.addAll(context.getAssociationExtractors().stream().flatMap(extractor -> extractor.extract(associationContext).stream()).collect(Collectors.toList()));
            }
        }));
        return handlers;
    }
}

