/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.ref;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;

public class MeasureRef
extends RecommendationRef {
    public MeasureRef(MeasureDesc measure, int id, boolean existed) {
        this.setId(id);
        this.setEntity(measure);
        this.setContent(JsonUtil.writeValueAsStringQuietly((Object)measure));
        this.setName(measure.getName());
        this.setExisted(existed);
    }

    @Override
    public void rebuild(String userDefinedName) {
        NDataModel.Measure measure = this.getMeasure();
        measure.setName(userDefinedName);
        FunctionDesc function = measure.getFunction();
        List<ParameterDesc> parameters = function.getParameters();
        List<RecommendationRef> dependencies = this.getDependencies();
        Preconditions.checkArgument((parameters.size() == dependencies.size() ? 1 : 0) != 0);
        for (int i = 0; i < dependencies.size(); ++i) {
            parameters.get(i).setValue(dependencies.get(i).getName());
        }
        this.setEntity(measure);
        this.setContent(JsonUtil.writeValueAsStringQuietly((Object)measure));
        this.setName(measure.getName());
    }

    public NDataModel.Measure getMeasure() {
        return (NDataModel.Measure)this.getEntity();
    }

    @Override
    public String getDataType() {
        return this.getMeasure().getFunction().getReturnType();
    }

    private boolean isDependenciesIdentical(MeasureRef measureRef) {
        return Objects.equals(this.getDependencies(), measureRef.getDependencies());
    }

    private boolean isFunctionIdentical(MeasureRef measureRef) {
        return Objects.equals(this.getMeasure().getFunction().getExpression(), measureRef.getMeasure().getFunction().getExpression());
    }

    public boolean isIdentical(RecommendationRef ref) {
        if (ref == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(ref instanceof MeasureRef));
        MeasureRef measureRef = (MeasureRef)ref;
        return this.isFunctionIdentical(measureRef) && this.isDependenciesIdentical(measureRef);
    }

    @Generated
    public MeasureRef() {
    }
}

