/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.metadata.query.JdbcQueryHistoryStore;
import org.apache.kylin.metadata.query.NoopJdbcQueryHistoryStore;
import org.apache.kylin.metadata.query.QueryDailyStatistic;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryDAO;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistoryRequest;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.QueryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSQueryHistoryDAO
implements QueryHistoryDAO {
    private static final Logger logger = LoggerFactory.getLogger(RDBMSQueryHistoryDAO.class);
    private String queryMetricMeasurement;
    private final String realizationMetricMeasurement;
    private final JdbcQueryHistoryStore jdbcQueryHisStore;
    public static final String WEEK = "week";
    public static final String DAY = "day";

    public static RDBMSQueryHistoryDAO getInstance() {
        return (RDBMSQueryHistoryDAO)Singletons.getInstance(RDBMSQueryHistoryDAO.class);
    }

    public RDBMSQueryHistoryDAO() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing RDBMSQueryHistoryDAO with KylinConfig Id: {} ", (Object)System.identityHashCode(config));
        }
        String metadataIdentifier = StorageURL.replaceUrl((StorageURL)config.getMetadataUrl());
        this.queryMetricMeasurement = metadataIdentifier + "_" + "query_history";
        this.realizationMetricMeasurement = metadataIdentifier + "_" + "query_history_realization";
        this.jdbcQueryHisStore = "noop".equals(config.getQueryHistoryUrl().toString()) ? new NoopJdbcQueryHistoryStore() : new JdbcQueryHistoryStore(config);
    }

    @Override
    public String getQueryMetricMeasurement() {
        return this.queryMetricMeasurement;
    }

    @Override
    public String getRealizationMetricMeasurement() {
        return this.realizationMetricMeasurement;
    }

    @Override
    public List<QueryDailyStatistic> getQueryDailyStatistic(long startTime, long endTime) {
        return this.jdbcQueryHisStore.queryHistoryDailyStatistic(startTime, endTime);
    }

    public int insert(QueryMetrics metrics) {
        return this.jdbcQueryHisStore.insert(metrics);
    }

    public void insert(List<QueryMetrics> metricsList) {
        this.jdbcQueryHisStore.insert(metricsList);
    }

    public void dropQueryHistoryTable() throws SQLException {
        this.jdbcQueryHisStore.dropQueryHistoryTable();
    }

    public void deleteAllQueryHistory() {
        this.jdbcQueryHisStore.deleteQueryHistory();
    }

    public void deleteQueryHistoryByProject(String project) {
        this.jdbcQueryHisStore.deleteQueryHistory(project);
    }

    public void deleteAllQueryHistoryRealizationForProject(String project) {
        this.jdbcQueryHisStore.deleteQueryHistoryRealization(project);
    }

    @Override
    public QueryHistory getByQueryId(String queryId) {
        return this.jdbcQueryHisStore.queryByQueryId(queryId);
    }

    public List<QueryHistory> getByQueryIds(List<String> queryIds) {
        return this.jdbcQueryHisStore.queryByQueryIds(queryIds);
    }

    @Override
    public Long getQueryHistoryMinQueryTime() {
        return this.jdbcQueryHisStore.queryQueryHistoryMinQueryTime();
    }

    @Override
    public void deleteQueryHistoriesIfMaxSizeReached() throws InterruptedException {
        long maxSize = KylinConfig.getInstanceFromEnv().getQueryHistoryMaxSize();
        long totalCount = this.jdbcQueryHisStore.getCountOnQueryHistory();
        if (totalCount > maxSize) {
            this.deleteQueryHistoryAndRealization((int)(totalCount - maxSize));
        }
    }

    @Override
    public void deleteQueryHistoriesIfRetainTimeReached() throws InterruptedException {
        long rangeOutCount = this.jdbcQueryHisStore.getCountOnQueryHistory(RDBMSQueryHistoryDAO.getRetainTime());
        if (rangeOutCount > 0L) {
            this.deleteQueryHistoryAndRealization((int)rangeOutCount);
        }
    }

    public void deleteQueryHistoryAndRealization(int deleteCount) throws InterruptedException {
        int singleLimit = KylinConfig.getInstanceFromEnv().getQueryHistorySingleDeletionSize();
        RDBMSQueryHistoryDAO.largeSplitToSmallTask(deleteCount, singleLimit, currentCount -> {
            QueryHistory queryHistory = this.jdbcQueryHisStore.getOldestQueryHistory(currentCount);
            int deletedRows = this.jdbcQueryHisStore.deleteQueryHistory(queryHistory.getId());
            this.jdbcQueryHisStore.deleteQueryHistoryRealization(queryHistory.getQueryTime());
            return deletedRows;
        }, "Cleanup all query history");
    }

    @Override
    public void deleteOldestQueryHistoriesByProject(String project, int deleteCount) throws InterruptedException {
        int singleLimit = KylinConfig.getInstanceFromEnv().getQueryHistorySingleDeletionSize();
        RDBMSQueryHistoryDAO.largeSplitToSmallTask(deleteCount, singleLimit, currentCount -> {
            QueryHistory queryHistory = this.jdbcQueryHisStore.getOldestQueryHistory(project, currentCount);
            int deletedRows = this.jdbcQueryHisStore.deleteQueryHistory(project, queryHistory.getId());
            this.jdbcQueryHisStore.deleteQueryHistoryRealization(project, queryHistory.getQueryTime());
            return deletedRows;
        }, "Cleanup project<" + project + "> query history");
    }

    public void batchUpdateQueryHistoriesInfo(List<Pair<Long, QueryHistoryInfo>> idToQHInfoList) {
        this.jdbcQueryHisStore.updateQueryHistoryInfo(idToQHInfoList);
    }

    public static long getRetainTime() {
        return new Date(System.currentTimeMillis() - KylinConfig.getInstanceFromEnv().getQueryHistorySurvivalThreshold()).getTime();
    }

    public void dropProjectMeasurement(String project) {
        this.jdbcQueryHisStore.deleteQueryHistory(project);
        this.jdbcQueryHisStore.deleteQueryHistoryRealization(project);
    }

    public List<QueryHistory> getAllQueryHistories() {
        return this.jdbcQueryHisStore.queryAllQueryHistories();
    }

    public List<QueryHistory> queryQueryHistoriesByIdOffset(long idOffset, int batchSize, String project) {
        return this.jdbcQueryHisStore.queryQueryHistoriesByIdOffset(idOffset, batchSize, project);
    }

    @Override
    public List<QueryHistory> getQueryHistoriesByConditions(QueryHistoryRequest request, int limit, int page) {
        return this.jdbcQueryHisStore.queryQueryHistoriesByConditions(request, limit, page * limit);
    }

    @Override
    public List<QueryHistory> getQueryHistoriesByConditionsWithOffset(QueryHistoryRequest request, int limit, int offset) {
        return this.jdbcQueryHisStore.queryQueryHistoriesByConditions(request, limit, offset);
    }

    @Override
    public long getQueryHistoriesSize(QueryHistoryRequest request, String project) {
        return this.jdbcQueryHisStore.queryQueryHistoriesSize(request).getCount();
    }

    @Override
    public List<QueryHistory> getQueryHistoriesSubmitters(QueryHistoryRequest request, int size) {
        return this.jdbcQueryHisStore.queryQueryHistoriesSubmitters(request, size);
    }

    @Override
    public List<QueryStatistics> getQueryHistoriesModelIds(QueryHistoryRequest request) {
        return this.jdbcQueryHisStore.queryQueryHistoriesModelIds(request);
    }

    @Override
    public QueryStatistics getQueryCountAndAvgDuration(long startTime, long endTime, String project) {
        List<QueryStatistics> result = this.jdbcQueryHisStore.queryCountAndAvgDuration(startTime, endTime, project);
        if (CollectionUtils.isEmpty(result)) {
            return new QueryStatistics();
        }
        return result.get(0);
    }

    @Override
    public QueryStatistics getQueryCountAndAvgDurationRealization(long startTime, long endTime, String project) {
        List<QueryStatistics> result = this.jdbcQueryHisStore.queryCountAndAvgDurationRealization(startTime, endTime, project);
        if (CollectionUtils.isEmpty(result)) {
            return new QueryStatistics();
        }
        return result.get(0);
    }

    @Override
    public List<QueryStatistics> getQueryCountByModel(long startTime, long endTime, String project) {
        return this.jdbcQueryHisStore.queryCountByModel(startTime, endTime, project);
    }

    @Override
    public QueryStatistics getQueryCountByRange(long startTime, long endTime, String project) {
        return this.jdbcQueryHisStore.queryRecentQueryCount(startTime, endTime, project);
    }

    @Override
    public long getQueryHistoryCountBeyondOffset(long offset, String project) {
        return this.jdbcQueryHisStore.queryQueryHistoryCountBeyondOffset(offset, project);
    }

    public long getQueryHistoryMaxId(String project) {
        return this.jdbcQueryHisStore.queryQueryHistoryMaxId(project);
    }

    @Override
    public List<QueryStatistics> getQueryCountByTime(long startTime, long endTime, String timeDimension, String project) {
        return this.jdbcQueryHisStore.queryCountByTime(startTime, endTime, timeDimension, project);
    }

    @Override
    public List<QueryStatistics> getQueryCountRealizationByTime(long startTime, long endTime, String timeDimension, String project) {
        return this.jdbcQueryHisStore.queryCountRealizationByTime(startTime, endTime, timeDimension, project);
    }

    @Override
    public List<QueryStatistics> getAvgDurationByModel(long startTime, long endTime, String project) {
        return this.jdbcQueryHisStore.queryAvgDurationByModel(startTime, endTime, project);
    }

    @Override
    public List<QueryStatistics> getAvgDurationByTime(long startTime, long endTime, String timeDimension, String project) {
        return this.jdbcQueryHisStore.queryAvgDurationByTime(startTime, endTime, timeDimension, project);
    }

    @Override
    public List<QueryStatistics> getAvgDurationRealizationByTime(long startTime, long endTime, String timeDimension, String project) {
        return this.jdbcQueryHisStore.queryAvgDurationRealizationByTime(startTime, endTime, timeDimension, project);
    }

    @Override
    public Map<String, Long> getQueryCountByProject() {
        return this.jdbcQueryHisStore.getCountGroupByProject();
    }

    public static void fillZeroForQueryStatistics(List<QueryStatistics> queryStatistics, long startTime, long endTime, String dimension) {
        if (!dimension.equalsIgnoreCase(DAY) && !dimension.equalsIgnoreCase(WEEK)) {
            return;
        }
        if (dimension.equalsIgnoreCase(WEEK)) {
            startTime = TimeUtil.getWeekStart((long)startTime);
            endTime = TimeUtil.getWeekStart((long)endTime);
        }
        Set instantSet = queryStatistics.stream().map(QueryStatistics::getTime).collect(Collectors.toSet());
        int rawOffsetTime = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone()).getRawOffset();
        long startOffSetTime = Instant.ofEpochMilli(startTime).plusMillis(rawOffsetTime).toEpochMilli();
        Instant startInstant = Instant.ofEpochMilli(startOffSetTime - startOffSetTime % 86400000L);
        long endOffSetTime = Instant.ofEpochMilli(endTime).plusMillis(rawOffsetTime).toEpochMilli();
        Instant endInstant = Instant.ofEpochMilli(endOffSetTime - endOffSetTime % 86400000L);
        while (!startInstant.isAfter(endInstant)) {
            if (!instantSet.contains(startInstant)) {
                QueryStatistics zeroStatistics = new QueryStatistics();
                zeroStatistics.setCount(0L);
                zeroStatistics.setTime(startInstant);
                queryStatistics.add(zeroStatistics);
            }
            if (dimension.equalsIgnoreCase(DAY)) {
                startInstant = startInstant.plus(Duration.ofDays(1L));
                continue;
            }
            if (!dimension.equalsIgnoreCase(WEEK)) continue;
            startInstant = startInstant.plus(Duration.ofDays(7L));
        }
    }

    public static void largeSplitToSmallTask(int totalCount, int singleSize, IntFunction<Integer> function, String description) throws InterruptedException {
        int currentCount;
        for (int retainCount = totalCount; retainCount > 0; retainCount -= currentCount) {
            int actualCount;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupted during splitting a large query task!");
            }
            currentCount = Math.min(retainCount, singleSize);
            if (currentCount == (actualCount = function.apply(currentCount).intValue()) || !logger.isWarnEnabled()) continue;
            logger.warn("The task {} was not performed as expected, expect:{}, actual:{}", new Object[]{description, currentCount, actualCount});
        }
    }

    @Generated
    public void setQueryMetricMeasurement(String queryMetricMeasurement) {
        this.queryMetricMeasurement = queryMetricMeasurement;
    }
}

