/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMetricsContext
extends QueryMetrics {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetricsContext.class);
    private static final ThreadLocal<QueryMetricsContext> contexts = new ThreadLocal();

    private QueryMetricsContext(String queryId, String defaultServer) {
        super(queryId, defaultServer);
    }

    public static void start(String queryId, String defaultServer) {
        if (QueryMetricsContext.isStarted()) {
            logger.warn("Query metric context already started in thread named {}", (Object)Thread.currentThread().getName());
            return;
        }
        contexts.set(new QueryMetricsContext(queryId, defaultServer));
    }

    public static boolean isStarted() {
        return contexts.get() != null;
    }

    public static QueryMetricsContext collect(QueryContext context) {
        QueryMetricsContext current = QueryMetricsContext.obtainCurrentQueryMetrics();
        current.doCollect(context);
        return current;
    }

    public static void reset() {
        contexts.remove();
    }

    private static QueryMetricsContext obtainCurrentQueryMetrics() {
        QueryMetricsContext current = null;
        current = contexts.get();
        Preconditions.checkState((current != null ? 1 : 0) != 0, (Object)"Query metric context is not started.");
        return current;
    }

    private void doCollect(QueryContext context) {
        this.sql = context.getMetrics().getCorrectedSql();
        this.sqlPattern = context.getMetrics().getSqlPattern();
        this.queryTime = context.getMetrics().getQueryStartTime();
        TimeZone timeZone = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone());
        LocalDate date = Instant.ofEpochMilli(this.queryTime).atZone(timeZone.toZoneId()).toLocalDate();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM", Locale.getDefault(Locale.Category.FORMAT));
        this.month = date.withDayOfMonth(1).format(formatter);
        this.queryFirstDayOfMonth = TimeUtil.getMonthStart((long)this.queryTime);
        this.queryDay = TimeUtil.getDayStart((long)this.queryTime);
        this.queryFirstDayOfWeek = TimeUtil.getWeekStart((long)this.queryTime);
        this.submitter = context.getAclInfo().getUsername();
        this.server = context.getMetrics().getServer();
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
            QueryContext.currentTrace().endLastSpan();
            this.queryDuration = System.currentTimeMillis() - this.queryTime;
        } else {
            this.queryDuration = QueryContext.current().getQueryTagInfo().isStorageCacheUsed() ? 0L : QueryContext.currentMetrics().duration();
        }
        this.totalScanBytes = context.getMetrics().getTotalScanBytes();
        this.totalScanCount = context.getMetrics().getTotalScanRows();
        this.queryJobCount = context.getMetrics().getQueryJobCount();
        this.queryStageCount = context.getMetrics().getQueryStageCount();
        this.queryTaskCount = context.getMetrics().getQueryTaskCount();
        this.cpuTime = context.getMetrics().getCpuTime();
        this.isPushdown = context.getQueryTagInfo().isPushdown();
        this.isTimeout = context.getQueryTagInfo().isTimeout();
        if (context.getQueryTagInfo().isStorageCacheUsed() && context.getEngineType() != null) {
            this.engineType = context.getEngineType();
        } else if (context.getQueryTagInfo().isPushdown()) {
            this.engineType = context.getPushdownEngine();
        } else if (context.getQueryTagInfo().isConstantQuery()) {
            this.engineType = QueryHistory.EngineType.CONSTANTS.name();
        } else if (!context.getMetrics().isException()) {
            this.engineType = QueryHistory.EngineType.NATIVE.name();
        }
        String string = this.queryStatus = context.getMetrics().isException() ? "FAILED" : "SUCCEEDED";
        if (context.getQueryTagInfo().isHitExceptionCache() || context.getQueryTagInfo().isStorageCacheUsed()) {
            this.isCacheHit = true;
            this.cacheType = context.getQueryTagInfo().getStorageCacheType();
        }
        this.resultRowCount = context.getMetrics().getResultRowCount();
        this.queryMsg = context.getMetrics().getQueryMsg();
        this.isIndexHit = !context.getMetrics().isException() && !context.getQueryTagInfo().isPushdown() && !this.engineType.equals(QueryHistory.EngineType.CONSTANTS.name());
        this.projectName = context.getProject();
        this.collectErrorType(context);
        List<QueryMetrics.RealizationMetrics> realizationMetricList = this.collectRealizationMetrics(QueryContext.current().getQueryRealizations());
        QueryHistoryInfo queryHistoryInfo = new QueryHistoryInfo(context.getMetrics().isExactlyMatch(), context.getMetrics().getSegCount(), Objects.nonNull(this.errorType) && !this.errorType.equals("No realization found"));
        queryHistoryInfo.setRealizationMetrics(realizationMetricList);
        queryHistoryInfo.setQueryMetrics(this.collectQueryMetrics());
        ArrayList<List<String>> querySnapshots = new ArrayList<List<String>>();
        for (NativeQueryRealization qcReal : QueryContext.current().getQueryRealizations()) {
            if (CollectionUtils.isEmpty((Collection)qcReal.getLookupTables())) continue;
            querySnapshots.add(qcReal.getLookupTables());
        }
        queryHistoryInfo.setQuerySnapshots(querySnapshots);
        queryHistoryInfo.setCacheType(this.cacheType);
        queryHistoryInfo.setQueryMsg(this.queryMsg);
        queryHistoryInfo.setHostName(AddressUtil.getHostName());
        queryHistoryInfo.setPort(KylinConfig.getInstanceFromEnv().getServerPort());
        this.queryHistoryInfo = queryHistoryInfo;
        this.queryHistoryInfo.setTraces(QueryMetricsContext.createTraces(context));
    }

    public static List<QueryHistoryInfo.QueryTraceSpan> createTraces(QueryContext context) {
        return context.getQueryTrace().spans().stream().map(span -> {
            if (!KapConfig.getInstanceFromEnv().isQuerySparkJobTraceEnabled() && "PREPARE_AND_SUBMIT_JOB".equals(span.getName())) {
                return new QueryHistoryInfo.QueryTraceSpan("SPARK_JOB_EXECUTION", (String)QueryTrace.SPAN_GROUPS.get("SPARK_JOB_EXECUTION"), span.getDuration());
            }
            return new QueryHistoryInfo.QueryTraceSpan(span.getName(), span.getGroup(), span.getDuration());
        }).collect(Collectors.toList());
    }

    private void collectErrorType(QueryContext context) {
        Throwable cause = context.getMetrics().getFinalCause();
        for (Throwable olapErrorCause = context.getMetrics().getOlapCause(); olapErrorCause != null; olapErrorCause = olapErrorCause.getCause()) {
            if (olapErrorCause instanceof NoRealizationFoundException) {
                this.errorType = "No realization found";
                return;
            }
            if (!(olapErrorCause instanceof RoutingIndicatorException)) continue;
            this.errorType = "Not Supported By OLAP SQL";
            return;
        }
        while (cause != null) {
            if (cause instanceof SqlValidatorException || cause instanceof SqlParseException || cause.getClass().getName().contains("ParseException")) {
                this.errorType = "Syntax error";
                return;
            }
            cause = cause.getCause();
        }
        if (context.getMetrics().getFinalCause() != null) {
            this.errorType = "Other error";
        }
    }

    public List<QueryMetrics.QueryMetric> collectQueryMetrics() {
        ArrayList<QueryMetrics.QueryMetric> queryMetrics = new ArrayList<QueryMetrics.QueryMetric>();
        queryMetrics.add(new QueryMetrics.QueryMetric("cpu_time", Long.valueOf(this.cpuTime)));
        return queryMetrics;
    }

    public List<QueryMetrics.RealizationMetrics> collectRealizationMetrics(List<NativeQueryRealization> queryRealizations) {
        ArrayList<QueryMetrics.RealizationMetrics> realizationMetricList = new ArrayList<QueryMetrics.RealizationMetrics>();
        if (CollectionUtils.isEmpty(queryRealizations)) {
            return realizationMetricList;
        }
        for (NativeQueryRealization realization : queryRealizations) {
            QueryMetrics.RealizationMetrics realizationMetrics = new QueryMetrics.RealizationMetrics(Objects.toString(realization.getLayoutId(), null), realization.getType(), realization.getModelId(), realization.getLookupTables());
            realizationMetrics.setQueryId(this.queryId);
            realizationMetrics.setDuration(this.queryDuration);
            realizationMetrics.setQueryTime(this.queryTime);
            realizationMetrics.setProjectName(this.projectName);
            realizationMetrics.setQueryDay(this.queryDay);
            realizationMetrics.setQueryFirstDayOfWeek(this.queryFirstDayOfWeek);
            realizationMetrics.setQueryFirstDayOfMonth(this.queryFirstDayOfMonth);
            realizationMetrics.setStreamingLayout(realization.isStreamingLayout());
            realizationMetrics.setSnapshots(realization.getLookupTables());
            realizationMetricList.add(realizationMetrics);
            if (realization.getType() == null) continue;
            switch (realization.getType()) {
                case "Table Index": {
                    this.tableIndexUsed = true;
                    break;
                }
                case "Agg Index": {
                    this.aggIndexUsed = true;
                    break;
                }
                case "Table Snapshot": {
                    this.tableSnapshotUsed = true;
                    break;
                }
            }
        }
        return realizationMetricList;
    }
}

