/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.metadata.model.schema.SchemaNode;

public enum SchemaNodeType {
    TABLE_COLUMN{

        @Override
        public String getSubject(String key) {
            return key.substring(0, key.lastIndexOf(46));
        }

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return key.substring(key.lastIndexOf(46) + 1);
        }
    }
    ,
    MODEL_COLUMN{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    MODEL_CC,
    MODEL_TABLE{

        @Override
        public String getSubject(String key) {
            return key;
        }

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return key;
        }
    }
    ,
    MODEL_FACT,
    MODEL_DIM,
    MODEL_PARTITION(true){

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("column");
        }
    }
    ,
    MODEL_MULTIPLE_PARTITION(true){

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return String.join((CharSequence)",", (List)attributes.get("columns"));
        }
    }
    ,
    MODEL_JOIN(true),
    MODEL_FILTER(true){

        @Override
        public String getSubject(String key) {
            return key;
        }

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("condition");
        }
    }
    ,
    MODEL_DIMENSION{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    MODEL_MEASURE{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    WHITE_LIST_INDEX{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    TO_BE_DELETED_INDEX{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    RULE_BASED_INDEX{

        @Override
        public String getDetail(String key, Map<String, Object> attributes) {
            return (String)attributes.get("id");
        }
    }
    ,
    AGG_GROUP,
    INDEX_AGG_SHARD,
    INDEX_AGG_EXTEND_PARTITION;

    boolean causeModelBroken;

    private SchemaNodeType() {
        this(false);
    }

    private SchemaNodeType(boolean causeModelBroken) {
        this.causeModelBroken = causeModelBroken;
    }

    public SchemaNode withKey(String key) {
        return new SchemaNode(this, key);
    }

    public boolean isModelNode() {
        return this != TABLE_COLUMN && this != MODEL_TABLE;
    }

    public String getSubject(String key) {
        return key.split("/")[0];
    }

    public String getDetail(String key, Map<String, Object> attributes) {
        String[] words = key.split("/");
        if (words.length == 2) {
            return words[1];
        }
        return this.toString();
    }

    @Generated
    public boolean isCauseModelBroken() {
        return this.causeModelBroken;
    }
}

