/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.alias;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.Litmus;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionComparator {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionComparator.class);
    private static final Set<String> SPECIAL_FUNCTIONS = ImmutableSet.of((Object)"CURRENT_DATE", (Object)"CURRENT_TIMESTAMP", (Object)"CURRENT_TIME", (Object)"PI");

    private ExpressionComparator() {
    }

    public static boolean isNodeEqual(SqlNode queryNode, SqlNode exprNode, AliasMapping aliasMapping, AliasDeduce aliasDeduce) {
        if (aliasMapping == null) {
            return false;
        }
        return ExpressionComparator.isNodeEqual(queryNode, exprNode, new AliasMatchingSqlNodeComparator(aliasMapping, aliasDeduce));
    }

    public static boolean isNodeEqual(SqlNode queryNode, SqlNode exprNode, SqlNodeComparator nodeComparator) {
        try {
            Preconditions.checkNotNull((Object)nodeComparator);
            return nodeComparator.isSqlNodeEqual(queryNode, exprNode);
        }
        catch (Exception e) {
            logger.error("Exception while running isNodeEqual, return false", (Throwable)e);
            return false;
        }
    }

    public static abstract class SqlNodeComparator {
        private static final Set<SqlKind> COMMUTATIVE_OPERATORS = Sets.newHashSet((Object[])new SqlKind[]{SqlKind.PLUS, SqlKind.TIMES});

        protected abstract boolean isSqlIdentifierEqual(SqlIdentifier var1, SqlIdentifier var2);

        public boolean isSqlNodeEqual(SqlNode queryNode, SqlNode exprNode) {
            if (queryNode == null) {
                return exprNode == null;
            }
            if (exprNode == null) {
                return false;
            }
            if (!Objects.equals(queryNode.getClass().getSimpleName(), exprNode.getClass().getSimpleName())) {
                return false;
            }
            if (queryNode instanceof SqlCall) {
                SqlCall thisNode = (SqlCall)queryNode;
                SqlCall thatNode = (SqlCall)exprNode;
                if (!thisNode.getOperator().getName().equalsIgnoreCase(thatNode.getOperator().getName())) {
                    return false;
                }
                if (this.isCommutativeOperator(thisNode.getOperator())) {
                    return this.isNodeListEqualRegardlessOfOrdering(thisNode.getOperandList(), thatNode.getOperandList());
                }
                return this.isNodeListEqual(thisNode.getOperandList(), thatNode.getOperandList());
            }
            if (queryNode instanceof SqlLiteral) {
                SqlLiteral thisNode = (SqlLiteral)queryNode;
                SqlLiteral thatNode = (SqlLiteral)exprNode;
                return Objects.equals(thisNode.getValue(), thatNode.getValue());
            }
            if (queryNode instanceof SqlNodeList) {
                SqlNodeList thisNode = (SqlNodeList)queryNode;
                SqlNodeList thatNode = (SqlNodeList)exprNode;
                if (thisNode.getList().size() != thatNode.getList().size()) {
                    return false;
                }
                for (int i = 0; i < thisNode.getList().size(); ++i) {
                    SqlNode thatChild;
                    SqlNode thisChild = (SqlNode)thisNode.getList().get(i);
                    if (this.isSqlNodeEqual(thisChild, thatChild = (SqlNode)thatNode.getList().get(i))) continue;
                    return false;
                }
                return true;
            }
            if (queryNode instanceof SqlIdentifier) {
                SqlIdentifier thisNode = (SqlIdentifier)queryNode;
                SqlIdentifier thatNode = (SqlIdentifier)exprNode;
                if (thisNode.names.size() == 1 && !thisNode.isComponentQuoted(0) && SPECIAL_FUNCTIONS.contains(thisNode.toString())) {
                    return false;
                }
                return this.isSqlIdentifierEqual(thisNode, thatNode);
            }
            if (queryNode instanceof SqlDataTypeSpec) {
                SqlDataTypeSpec thisNode = (SqlDataTypeSpec)queryNode;
                SqlDataTypeSpec thatNode = (SqlDataTypeSpec)exprNode;
                return this.isSqlDataTypeSpecEqual(thisNode, thatNode);
            }
            if (queryNode instanceof SqlIntervalQualifier) {
                SqlIntervalQualifier thisNode = (SqlIntervalQualifier)queryNode;
                SqlIntervalQualifier thatNode = (SqlIntervalQualifier)exprNode;
                return this.isSqlIntervalQualifierEqual(thisNode, thatNode);
            }
            return false;
        }

        private boolean isSqlIntervalQualifierEqual(SqlIntervalQualifier querySqlIntervalQualifier, SqlIntervalQualifier exprIntervalQualifier) {
            return querySqlIntervalQualifier.getUnit() == exprIntervalQualifier.getUnit();
        }

        protected boolean isSqlDataTypeSpecEqual(SqlDataTypeSpec querySqlDataTypeSpec, SqlDataTypeSpec exprSqlDataTypeSpec) {
            return querySqlDataTypeSpec.equalsDeep((SqlNode)exprSqlDataTypeSpec, Litmus.IGNORE);
        }

        private boolean isCommutativeOperator(SqlOperator operator) {
            return COMMUTATIVE_OPERATORS.contains(operator.getKind());
        }

        private boolean isNodeListEqualRegardlessOfOrdering(List<SqlNode> queryNodeList, List<SqlNode> exprNodeList) {
            if (queryNodeList.size() != exprNodeList.size()) {
                return false;
            }
            LinkedList remExprNodes = Lists.newLinkedList(exprNodeList);
            for (SqlNode queryNode : queryNodeList) {
                int found = -1;
                for (int i = 0; i < remExprNodes.size(); ++i) {
                    if (!this.isSqlNodeEqual(queryNode, (SqlNode)remExprNodes.get(i))) continue;
                    found = i;
                    break;
                }
                if (found == -1) {
                    return false;
                }
                remExprNodes.remove(found);
            }
            return true;
        }

        private boolean isNodeListEqual(List<SqlNode> queryNodeList, List<SqlNode> exprNodeList) {
            if (queryNodeList.size() != exprNodeList.size()) {
                return false;
            }
            for (int i = 0; i < queryNodeList.size(); ++i) {
                if (this.isSqlNodeEqual(queryNodeList.get(i), exprNodeList.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class AliasMatchingSqlNodeComparator
    extends SqlNodeComparator {
        private final AliasMapping aliasMapping;
        private final AliasDeduce aliasDeduce;

        public AliasMatchingSqlNodeComparator(AliasMapping aliasMapping, AliasDeduce aliasDeduce) {
            this.aliasMapping = aliasMapping;
            this.aliasDeduce = aliasDeduce;
        }

        @Override
        protected boolean isSqlIdentifierEqual(SqlIdentifier querySqlIdentifier, SqlIdentifier exprSqlIdentifier) {
            if (this.aliasMapping == null || this.aliasMapping.getAliasMap() == null) {
                return false;
            }
            Preconditions.checkState((exprSqlIdentifier.names.size() == 2 ? 1 : 0) != 0);
            String queryAlias = null;
            String queryCol = null;
            if (querySqlIdentifier.isStar()) {
                return exprSqlIdentifier.isStar();
            }
            if (exprSqlIdentifier.isStar()) {
                return false;
            }
            try {
                if (querySqlIdentifier.names.size() == 1) {
                    queryCol = (String)querySqlIdentifier.names.get(0);
                    queryAlias = this.aliasDeduce.deduceAlias(queryCol);
                } else if (querySqlIdentifier.names.size() == 2) {
                    queryCol = (String)querySqlIdentifier.names.get(1);
                    queryAlias = (String)querySqlIdentifier.names.get(0);
                }
                String modelAlias = (String)this.aliasMapping.getAliasMap().get(queryAlias);
                Preconditions.checkNotNull((Object)modelAlias);
                Preconditions.checkNotNull((Object)queryCol);
                String identity = modelAlias + "." + queryCol;
                if (this.aliasMapping.getExcludedColumns().contains(identity)) {
                    return false;
                }
                return StringUtils.equalsIgnoreCase((CharSequence)modelAlias, (CharSequence)((CharSequence)exprSqlIdentifier.names.get(0))) && StringUtils.equalsIgnoreCase((CharSequence)queryCol, (CharSequence)((CharSequence)exprSqlIdentifier.names.get(1)));
            }
            catch (IllegalStateException | NullPointerException e) {
                logger.trace("met exception when doing expressions[{}, {}] comparison", new Object[]{querySqlIdentifier, exprSqlIdentifier, e});
                return false;
            }
        }
    }
}

