/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.constant.ObsConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableExtDesc
extends RootPersistentEntity
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableExtDesc.class);
    public static final String S3_ROLE_PROPERTY_KEY = ObsConfig.S3.getRolePropertiesKey();
    public static final String LOCATION_PROPERTY_KEY = "location";
    public static final String S3_ENDPOINT_KEY = ObsConfig.S3.getEndpointPropertiesKey();
    public static final String SEPARATOR = "/";
    @JsonProperty(value="table_name")
    private String identity;
    @JsonProperty(value="last_build_job_id")
    private String jodID;
    @JsonProperty(value="columns_stats")
    private List<ColumnStats> columnStats = new ArrayList<ColumnStats>();
    @JsonProperty(value="sample_rows")
    private List<String[]> sampleRows = new ArrayList<String[]>();
    @JsonProperty(value="total_rows")
    private long totalRows;
    @JsonProperty(value="data_source_properties")
    private Map<String, String> dataSourceProps = new HashMap<String, String>();
    @JsonProperty(value="row_count_status")
    private RowCountStatus rowCountStatus;
    @JsonProperty(value="original_size")
    private long originalSize = -1L;
    @JsonProperty(value="query_hit_count")
    private int snapshotHitCount = 0;
    @JsonProperty(value="excluded")
    private boolean excluded;
    @JsonProperty(value="excluded_columns")
    private Set<String> excludedColumns = Sets.newLinkedHashSet();

    public static String concatRawResourcePath(String nameOnPath) {
        return "/table_exd/" + nameOnPath + ".json";
    }

    public TableExtDesc() {
    }

    public TableExtDesc(TableExtDesc other) {
        this.uuid = other.uuid;
        this.lastModified = other.lastModified;
        this.identity = other.identity;
        this.jodID = other.jodID;
        this.columnStats = other.columnStats;
        this.sampleRows = other.sampleRows;
        this.totalRows = other.totalRows;
        this.dataSourceProps = other.dataSourceProps;
        this.project = other.project;
        this.originalSize = other.originalSize;
        this.snapshotHitCount = other.snapshotHitCount;
        this.excluded = other.excluded;
        this.excludedColumns = other.excludedColumns;
        this.rowCountStatus = other.rowCountStatus;
    }

    public boolean testExcluded(ColumnDesc column) {
        return this.excluded || this.excludedColumns.contains(column.getName());
    }

    public String resourceName() {
        return TableExtDesc.generateResourceName(this.getProject(), this.getIdentity());
    }

    public static String generateResourceName(String project, String identity) {
        return project + "." + identity;
    }

    public MetadataType resourceType() {
        return MetadataType.TABLE_EXD;
    }

    public void addDataSourceProp(String key, String value) {
        this.dataSourceProps.put(key, value);
    }

    public String getCardinality() {
        StringBuilder cardinality = new StringBuilder();
        for (ColumnStats stat : this.columnStats) {
            cardinality.append(stat.getCardinality());
            cardinality.append(",");
        }
        return cardinality.toString();
    }

    public void setCardinality(String cardinality) {
        if (StringUtils.isEmpty((CharSequence)cardinality)) {
            return;
        }
        String[] cardi = cardinality.split(",");
        if (this.columnStats.isEmpty()) {
            for (String aCardi : cardi) {
                ColumnStats columnStat = new ColumnStats();
                columnStat.setCardinality(Long.parseLong(aCardi));
                this.columnStats.add(columnStat);
            }
        } else if (this.columnStats.size() == cardi.length) {
            for (int i = 0; i < cardi.length; ++i) {
                this.columnStats.get(i).setCardinality(Long.parseLong(cardi[i]));
            }
        } else {
            throw new IllegalArgumentException("The given cardinality columns don't match tables " + this.identity);
        }
    }

    public <T extends RootPersistentEntity> void copyPropertiesTo(T copy) {
        TableExtDesc extDesc = (TableExtDesc)copy;
        extDesc.setColumnStats(this.getAllColumnStats());
        for (Map.Entry<String, String> entry : this.getDataSourceProps().entrySet()) {
            extDesc.addDataSourceProp(entry.getKey(), entry.getValue());
        }
        super.copyPropertiesTo((RootPersistentEntity)extDesc);
    }

    public List<ColumnStats> getAllColumnStats() {
        return this.columnStats;
    }

    public ColumnStats getColumnStatsByName(String colName) {
        HashMap columnStatsMap = Maps.newHashMap();
        for (ColumnStats col : this.columnStats) {
            columnStatsMap.putIfAbsent(col.getColumnName(), col);
        }
        return columnStatsMap.getOrDefault(colName, null);
    }

    public boolean isExcludedCol(String colName) {
        return this.excluded || this.getExcludedColumns().contains(colName);
    }

    public int countExcludedColSize() {
        if (!this.isExcluded()) {
            return this.getExcludedColumns().size();
        }
        return this.getTableDesc().getColumns().length;
    }

    private TableDesc getTableDesc() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        return NTableMetadataManager.getInstance(kylinConfig, this.project).getTableDesc(this.getIdentity());
    }

    public void init(String project) {
        this.project = project;
        if (this.identity != null) {
            this.identity = this.identity.toUpperCase(Locale.ROOT);
        }
    }

    public RoleCredentialInfo getRoleCredentialInfo() {
        String location = this.dataSourceProps.get(LOCATION_PROPERTY_KEY);
        ObsConfig obsConfig = ObsConfig.getByLocation((String)location).orElse(ObsConfig.S3);
        String role = this.dataSourceProps.get(obsConfig.getRolePropertiesKey());
        String endpoint = this.dataSourceProps.get(obsConfig.getEndpointPropertiesKey());
        String region = this.dataSourceProps.get(obsConfig.getRegionPropertiesKey());
        if (Strings.isNullOrEmpty((String)location)) {
            return null;
        }
        String bucket = null;
        try {
            bucket = new URI(location).getAuthority();
        }
        catch (Exception e) {
            log.warn("invalid object storage location {}", (Object)location, (Object)e);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            return null;
        }
        return new RoleCredentialInfo(bucket, role, endpoint, obsConfig.getType(), region);
    }

    public int hashCode() {
        return this.getIdentity().hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return "TableExtDesc{name='" + (null == this.identity ? "NULL" : this.identity) + '\'' + ", columns_samples=" + (null == this.columnStats ? "null" : Arrays.toString(this.columnStats.toArray()));
    }

    @Generated
    public String getIdentity() {
        return this.identity;
    }

    @Generated
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Generated
    public String getJodID() {
        return this.jodID;
    }

    @Generated
    public void setJodID(String jodID) {
        this.jodID = jodID;
    }

    @Generated
    public void setColumnStats(List<ColumnStats> columnStats) {
        this.columnStats = columnStats;
    }

    @Generated
    public List<String[]> getSampleRows() {
        return this.sampleRows;
    }

    @Generated
    public void setSampleRows(List<String[]> sampleRows) {
        this.sampleRows = sampleRows;
    }

    @Generated
    public long getTotalRows() {
        return this.totalRows;
    }

    @Generated
    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    @Generated
    public Map<String, String> getDataSourceProps() {
        return this.dataSourceProps;
    }

    @Generated
    public RowCountStatus getRowCountStatus() {
        return this.rowCountStatus;
    }

    @Generated
    public void setRowCountStatus(RowCountStatus rowCountStatus) {
        this.rowCountStatus = rowCountStatus;
    }

    @Generated
    public long getOriginalSize() {
        return this.originalSize;
    }

    @Generated
    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    @Generated
    public int getSnapshotHitCount() {
        return this.snapshotHitCount;
    }

    @Generated
    public void setSnapshotHitCount(int snapshotHitCount) {
        this.snapshotHitCount = snapshotHitCount;
    }

    @Generated
    public boolean isExcluded() {
        return this.excluded;
    }

    @Generated
    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    @Generated
    public Set<String> getExcludedColumns() {
        return this.excludedColumns;
    }

    @Generated
    public void setExcludedColumns(Set<String> excludedColumns) {
        this.excludedColumns = excludedColumns;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ColumnStats
    implements Comparable<ColumnStats>,
    Serializable {
        @JsonBackReference
        private TableExtDesc tableExtDesc;
        @JsonProperty(value="column_name")
        private String columnName;
        @JsonProperty(value="max_numeral")
        private double maxNumeral = Double.NaN;
        @JsonProperty(value="min_numeral")
        private double minNumeral = Double.NaN;
        @JsonProperty(value="max_value")
        private String maxValue;
        @JsonProperty(value="min_value")
        private String minValue;
        @JsonProperty(value="max_length")
        private Integer maxLength;
        @JsonProperty(value="min_length")
        private Integer minLength;
        @JsonProperty(value="max_length_value")
        private String maxLengthValue;
        @JsonProperty(value="min_length_value")
        private String minLengthValue;
        @JsonProperty(value="null_count")
        private long nullCount;
        @JsonProperty(value="exceed_precision_count")
        private long exceedPrecisionCount;
        @JsonProperty(value="exceed_precision_max_length_value")
        private String exceedPrecisionMaxLengthValue;
        @JsonProperty(value="cardinality")
        private long cardinality;
        @JsonProperty(value="data_skew_samples")
        private Map<String, Long> dataSkewSamples = new HashMap<String, Long>();
        @JsonIgnore
        private transient Map<String, HLLCounter> rangeHLLC = new HashMap<String, HLLCounter>();
        @JsonIgnore
        private transient HLLCounter totalHLLC;
        @JsonIgnore
        private transient long totalCardinality;

        @Override
        public int compareTo(ColumnStats o) {
            return 0;
        }

        public void init() {
            if (this.rangeHLLC.isEmpty()) {
                return;
            }
            Iterator<HLLCounter> hllcIterator = this.rangeHLLC.values().iterator();
            this.totalHLLC = new HLLCounter(hllcIterator.next());
            while (hllcIterator.hasNext()) {
                this.totalHLLC.merge(hllcIterator.next());
            }
            this.cardinality = this.totalCardinality = this.totalHLLC.getCountEstimate();
        }

        public void updateBasicStats(double maxNumeral, double minNumeral, int maxLength, int minLength, String maxLengthValue, String minLengthValue) {
            if (Double.isNaN(this.maxNumeral) || maxNumeral > this.maxNumeral) {
                this.maxNumeral = maxNumeral;
            }
            if (Double.isNaN(this.minNumeral) || minNumeral < this.minNumeral) {
                this.minNumeral = minNumeral;
            }
            if (this.maxLength == null || maxLength > this.maxLength) {
                this.maxLength = maxLength;
                this.maxLengthValue = maxLengthValue;
            }
            if (this.minLength == null || minLength < this.minLength) {
                this.minLength = minLength;
                this.minLengthValue = minLengthValue;
            }
        }

        @JsonIgnore
        public long getTotalCardinality() {
            return this.totalCardinality;
        }

        public void addNullCount(long incre) {
            this.nullCount += incre;
        }

        public void setColumnSamples(String max, String min, String maxLenValue, String minLenValue) {
            this.maxValue = max;
            this.minValue = min;
            this.maxLengthValue = maxLenValue;
            this.minLengthValue = minLenValue;
        }

        public static ColumnStats getColumnStats(NTableMetadataManager tableMetadataManager, TblColRef colRef) {
            ColumnStats ret = null;
            TableExtDesc tableExtDesc = tableMetadataManager.getTableExtIfExists(colRef.getTableRef().getTableDesc());
            if (tableExtDesc != null) {
                ret = tableExtDesc.getColumnStatsByName(colRef.getColumnDesc().getName());
            }
            return ret;
        }

        @Generated
        public ColumnStats() {
        }

        @Generated
        public TableExtDesc getTableExtDesc() {
            return this.tableExtDesc;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public double getMaxNumeral() {
            return this.maxNumeral;
        }

        @Generated
        public double getMinNumeral() {
            return this.minNumeral;
        }

        @Generated
        public String getMaxValue() {
            return this.maxValue;
        }

        @Generated
        public String getMinValue() {
            return this.minValue;
        }

        @Generated
        public Integer getMaxLength() {
            return this.maxLength;
        }

        @Generated
        public Integer getMinLength() {
            return this.minLength;
        }

        @Generated
        public String getMaxLengthValue() {
            return this.maxLengthValue;
        }

        @Generated
        public String getMinLengthValue() {
            return this.minLengthValue;
        }

        @Generated
        public long getNullCount() {
            return this.nullCount;
        }

        @Generated
        public long getExceedPrecisionCount() {
            return this.exceedPrecisionCount;
        }

        @Generated
        public String getExceedPrecisionMaxLengthValue() {
            return this.exceedPrecisionMaxLengthValue;
        }

        @Generated
        public long getCardinality() {
            return this.cardinality;
        }

        @Generated
        public Map<String, Long> getDataSkewSamples() {
            return this.dataSkewSamples;
        }

        @Generated
        public Map<String, HLLCounter> getRangeHLLC() {
            return this.rangeHLLC;
        }

        @Generated
        public HLLCounter getTotalHLLC() {
            return this.totalHLLC;
        }

        @Generated
        public void setTableExtDesc(TableExtDesc tableExtDesc) {
            this.tableExtDesc = tableExtDesc;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public void setMaxNumeral(double maxNumeral) {
            this.maxNumeral = maxNumeral;
        }

        @Generated
        public void setMinNumeral(double minNumeral) {
            this.minNumeral = minNumeral;
        }

        @Generated
        public void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Generated
        public void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Generated
        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Generated
        public void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Generated
        public void setMaxLengthValue(String maxLengthValue) {
            this.maxLengthValue = maxLengthValue;
        }

        @Generated
        public void setMinLengthValue(String minLengthValue) {
            this.minLengthValue = minLengthValue;
        }

        @Generated
        public void setNullCount(long nullCount) {
            this.nullCount = nullCount;
        }

        @Generated
        public void setExceedPrecisionCount(long exceedPrecisionCount) {
            this.exceedPrecisionCount = exceedPrecisionCount;
        }

        @Generated
        public void setExceedPrecisionMaxLengthValue(String exceedPrecisionMaxLengthValue) {
            this.exceedPrecisionMaxLengthValue = exceedPrecisionMaxLengthValue;
        }

        @Generated
        public void setCardinality(long cardinality) {
            this.cardinality = cardinality;
        }

        @Generated
        public void setDataSkewSamples(Map<String, Long> dataSkewSamples) {
            this.dataSkewSamples = dataSkewSamples;
        }

        @Generated
        public void setRangeHLLC(Map<String, HLLCounter> rangeHLLC) {
            this.rangeHLLC = rangeHLLC;
        }

        @Generated
        public void setTotalHLLC(HLLCounter totalHLLC) {
            this.totalHLLC = totalHLLC;
        }

        @Generated
        public void setTotalCardinality(long totalCardinality) {
            this.totalCardinality = totalCardinality;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnStats)) {
                return false;
            }
            ColumnStats other = (ColumnStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TableExtDesc this$tableExtDesc = this.getTableExtDesc();
            TableExtDesc other$tableExtDesc = other.getTableExtDesc();
            if (this$tableExtDesc == null ? other$tableExtDesc != null : !((Object)this$tableExtDesc).equals(other$tableExtDesc)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            if (Double.compare(this.getMaxNumeral(), other.getMaxNumeral()) != 0) {
                return false;
            }
            if (Double.compare(this.getMinNumeral(), other.getMinNumeral()) != 0) {
                return false;
            }
            String this$maxValue = this.getMaxValue();
            String other$maxValue = other.getMaxValue();
            if (this$maxValue == null ? other$maxValue != null : !this$maxValue.equals(other$maxValue)) {
                return false;
            }
            String this$minValue = this.getMinValue();
            String other$minValue = other.getMinValue();
            if (this$minValue == null ? other$minValue != null : !this$minValue.equals(other$minValue)) {
                return false;
            }
            Integer this$maxLength = this.getMaxLength();
            Integer other$maxLength = other.getMaxLength();
            if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
                return false;
            }
            Integer this$minLength = this.getMinLength();
            Integer other$minLength = other.getMinLength();
            if (this$minLength == null ? other$minLength != null : !((Object)this$minLength).equals(other$minLength)) {
                return false;
            }
            String this$maxLengthValue = this.getMaxLengthValue();
            String other$maxLengthValue = other.getMaxLengthValue();
            if (this$maxLengthValue == null ? other$maxLengthValue != null : !this$maxLengthValue.equals(other$maxLengthValue)) {
                return false;
            }
            String this$minLengthValue = this.getMinLengthValue();
            String other$minLengthValue = other.getMinLengthValue();
            if (this$minLengthValue == null ? other$minLengthValue != null : !this$minLengthValue.equals(other$minLengthValue)) {
                return false;
            }
            if (this.getNullCount() != other.getNullCount()) {
                return false;
            }
            if (this.getExceedPrecisionCount() != other.getExceedPrecisionCount()) {
                return false;
            }
            String this$exceedPrecisionMaxLengthValue = this.getExceedPrecisionMaxLengthValue();
            String other$exceedPrecisionMaxLengthValue = other.getExceedPrecisionMaxLengthValue();
            if (this$exceedPrecisionMaxLengthValue == null ? other$exceedPrecisionMaxLengthValue != null : !this$exceedPrecisionMaxLengthValue.equals(other$exceedPrecisionMaxLengthValue)) {
                return false;
            }
            if (this.getCardinality() != other.getCardinality()) {
                return false;
            }
            Map<String, Long> this$dataSkewSamples = this.getDataSkewSamples();
            Map<String, Long> other$dataSkewSamples = other.getDataSkewSamples();
            return !(this$dataSkewSamples == null ? other$dataSkewSamples != null : !((Object)this$dataSkewSamples).equals(other$dataSkewSamples));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnStats;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TableExtDesc $tableExtDesc = this.getTableExtDesc();
            result = result * 59 + ($tableExtDesc == null ? 43 : ((Object)$tableExtDesc).hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            long $maxNumeral = Double.doubleToLongBits(this.getMaxNumeral());
            result = result * 59 + (int)($maxNumeral >>> 32 ^ $maxNumeral);
            long $minNumeral = Double.doubleToLongBits(this.getMinNumeral());
            result = result * 59 + (int)($minNumeral >>> 32 ^ $minNumeral);
            String $maxValue = this.getMaxValue();
            result = result * 59 + ($maxValue == null ? 43 : $maxValue.hashCode());
            String $minValue = this.getMinValue();
            result = result * 59 + ($minValue == null ? 43 : $minValue.hashCode());
            Integer $maxLength = this.getMaxLength();
            result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
            Integer $minLength = this.getMinLength();
            result = result * 59 + ($minLength == null ? 43 : ((Object)$minLength).hashCode());
            String $maxLengthValue = this.getMaxLengthValue();
            result = result * 59 + ($maxLengthValue == null ? 43 : $maxLengthValue.hashCode());
            String $minLengthValue = this.getMinLengthValue();
            result = result * 59 + ($minLengthValue == null ? 43 : $minLengthValue.hashCode());
            long $nullCount = this.getNullCount();
            result = result * 59 + (int)($nullCount >>> 32 ^ $nullCount);
            long $exceedPrecisionCount = this.getExceedPrecisionCount();
            result = result * 59 + (int)($exceedPrecisionCount >>> 32 ^ $exceedPrecisionCount);
            String $exceedPrecisionMaxLengthValue = this.getExceedPrecisionMaxLengthValue();
            result = result * 59 + ($exceedPrecisionMaxLengthValue == null ? 43 : $exceedPrecisionMaxLengthValue.hashCode());
            long $cardinality = this.getCardinality();
            result = result * 59 + (int)($cardinality >>> 32 ^ $cardinality);
            Map<String, Long> $dataSkewSamples = this.getDataSkewSamples();
            result = result * 59 + ($dataSkewSamples == null ? 43 : ((Object)$dataSkewSamples).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TableExtDesc.ColumnStats(tableExtDesc=" + this.getTableExtDesc() + ", columnName=" + this.getColumnName() + ", maxNumeral=" + this.getMaxNumeral() + ", minNumeral=" + this.getMinNumeral() + ", maxValue=" + this.getMaxValue() + ", minValue=" + this.getMinValue() + ", maxLength=" + this.getMaxLength() + ", minLength=" + this.getMinLength() + ", maxLengthValue=" + this.getMaxLengthValue() + ", minLengthValue=" + this.getMinLengthValue() + ", nullCount=" + this.getNullCount() + ", exceedPrecisionCount=" + this.getExceedPrecisionCount() + ", exceedPrecisionMaxLengthValue=" + this.getExceedPrecisionMaxLengthValue() + ", cardinality=" + this.getCardinality() + ", dataSkewSamples=" + this.getDataSkewSamples() + ", rangeHLLC=" + this.getRangeHLLC() + ", totalHLLC=" + this.getTotalHLLC() + ", totalCardinality=" + this.getTotalCardinality() + ")";
        }
    }

    public static class RoleCredentialInfo {
        private String bucket;
        private String role;
        private String endpoint;
        private String type;
        private String region;

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setRegion(String region) {
            this.region = region;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleCredentialInfo)) {
                return false;
            }
            RoleCredentialInfo other = (RoleCredentialInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$bucket = this.getBucket();
            String other$bucket = other.getBucket();
            if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RoleCredentialInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bucket = this.getBucket();
            result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }

        @Generated
        public RoleCredentialInfo(String bucket, String role, String endpoint, String type, String region) {
            this.bucket = bucket;
            this.role = role;
            this.endpoint = endpoint;
            this.type = type;
            this.region = region;
        }
    }

    public static enum RowCountStatus {
        OK("ok"),
        TENTATIVE("tentative");

        private final String status;

        private RowCountStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

