/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class AntiFlatChecker {
    private final Set<String> antiFlattenLookups = Sets.newHashSet();
    private final Map<String, String> antiFlattenLookupCCs = Maps.newHashMap();
    private final Map<String, Set<String>> joinTableAliasMap = Maps.newHashMap();

    public AntiFlatChecker(List<JoinTableDesc> joinTables, NDataModel model) {
        if (model == null || model.isBroken() || CollectionUtils.isEmpty(model.getJoinTables())) {
            return;
        }
        model.getJoinTables().forEach(join -> {
            this.joinTableAliasMap.putIfAbsent(join.getTable(), Sets.newHashSet());
            this.joinTableAliasMap.get(join.getTable()).add(join.getAlias());
        });
        if (joinTables == null) {
            return;
        }
        HashMap aliasToIdentityMap = Maps.newHashMap();
        joinTables.forEach(joinTable -> {
            aliasToIdentityMap.put(joinTable.getAlias(), joinTable.getTable());
            if (!joinTable.isFlattenable()) {
                this.antiFlattenLookups.add(joinTable.getTable());
            }
        });
        joinTables.forEach(joinTable -> {
            TblColRef[] fkColumns = joinTable.getJoin().getForeignKeyColumns();
            TableRef foreignTableRef = joinTable.getJoin().getForeignTableRef();
            if (fkColumns != null && fkColumns.length > 0) {
                String tableWithSchema;
                TblColRef firstFK = fkColumns[0];
                String tableAlias = firstFK.getTableAlias();
                if (this.canTreatAsAntiLookup(aliasToIdentityMap, (JoinTableDesc)joinTable, tableAlias, tableWithSchema = firstFK.getTableWithSchema())) {
                    this.antiFlattenLookups.add(joinTable.getTable());
                }
            } else if (foreignTableRef != null) {
                String tableIdentity = foreignTableRef.getTableIdentity();
                String tableAlias = foreignTableRef.getAlias();
                if (this.canTreatAsAntiLookup(aliasToIdentityMap, (JoinTableDesc)joinTable, tableAlias, tableIdentity)) {
                    this.antiFlattenLookups.add(joinTable.getTable());
                }
            }
        });
    }

    private boolean canTreatAsAntiLookup(Map<String, String> aliasToIdentityMap, JoinTableDesc joinTable, String fkTableAlias, String fkTableIdentity) {
        return !joinTable.isFlattenable() || aliasToIdentityMap.containsKey(fkTableAlias) && this.antiFlattenLookups.contains(fkTableIdentity);
    }

    public boolean isColOfAntiLookup(TblColRef colRef) {
        if (!colRef.getColumnDesc().isComputedColumn()) {
            return this.antiFlattenLookups.contains(colRef.getTableWithSchema());
        }
        String innerExpression = colRef.getColumnDesc().getComputedColumnExpr();
        return this.isCCOfAntiLookup(innerExpression);
    }

    public boolean isCCOfAntiLookup(TblColRef tblColRef) {
        List<TblColRef> operands = tblColRef.getOperands();
        if (operands == null) {
            if (tblColRef.getTable() == null) {
                return false;
            }
            return this.antiFlattenLookups.contains(tblColRef.getTableWithSchema());
        }
        for (TblColRef colRef : operands) {
            if (!this.isCCOfAntiLookup(colRef)) continue;
            return true;
        }
        return false;
    }

    public boolean isCCOfAntiLookup(String innerExp) {
        if (this.antiFlattenLookupCCs.containsKey(innerExp)) {
            return true;
        }
        for (String table : this.antiFlattenLookups) {
            Set<String> aliasSet = this.joinTableAliasMap.get(table);
            if (aliasSet == null) continue;
            for (String alias : aliasSet) {
                String aliasWithBacktick = String.format(Locale.ROOT, "`%s`", alias);
                if (!innerExp.contains(aliasWithBacktick)) continue;
                this.antiFlattenLookupCCs.putIfAbsent(innerExp, alias);
                return true;
            }
        }
        return false;
    }

    public boolean isMeasureOfAntiLookup(FunctionDesc functionDesc) {
        List<TblColRef> colRefs = functionDesc.getColRefs();
        if (colRefs == null || colRefs.isEmpty()) {
            return false;
        }
        for (TblColRef colRef : colRefs) {
            if (!(colRef.isInnerColumn() ? this.isCCOfAntiLookup(colRef) : this.isColOfAntiLookup(colRef))) continue;
            return true;
        }
        return false;
    }

    public String detectAntiFlattenLookup(ComputedColumnDesc computedColumn) {
        String innerExp = computedColumn.getInnerExpression();
        if (this.isCCOfAntiLookup(innerExp)) {
            return this.antiFlattenLookupCCs.get(innerExp);
        }
        return null;
    }

    public List<ComputedColumnDesc> getInvalidComputedColumns(NDataModel model) {
        if (model.isBroken()) {
            return Lists.newArrayList();
        }
        ArrayList ccList = Lists.newArrayList();
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            if (!this.isCCOfAntiLookup(cc.getInnerExpression())) continue;
            ccList.add(JsonUtil.deepCopyQuietly((Object)cc, ComputedColumnDesc.class));
        }
        return ccList;
    }

    public Set<Integer> getInvalidDimensions(NDataModel model) {
        if (model.isBroken()) {
            return Sets.newHashSet();
        }
        HashSet dimensions = Sets.newHashSet();
        for (NDataModel.NamedColumn column : model.getAllNamedColumns()) {
            TblColRef colRef;
            if (!column.isDimension() || !this.isColOfAntiLookup(colRef = (TblColRef)model.getEffectiveCols().get((Object)column.getId()))) continue;
            dimensions.add(column.getId());
        }
        return dimensions;
    }

    public Set<Integer> getInvalidMeasures(NDataModel model) {
        if (model.isBroken()) {
            return Sets.newHashSet();
        }
        HashSet measures = Sets.newHashSet();
        block0: for (NDataModel.Measure measure : model.getAllMeasures()) {
            if (measure.isTomb()) continue;
            List<ParameterDesc> parameters = measure.getFunction().getParameters();
            for (ParameterDesc parameter : parameters) {
                if (parameter.isConstant() || !this.isColOfAntiLookup(parameter.getColRef())) continue;
                measures.add(measure.getId());
                continue block0;
            }
        }
        return measures;
    }

    public Set<Long> getInvalidIndexes(IndexPlan indexPlan, Set<Integer> invalidScope) {
        if (indexPlan == null || indexPlan.isBroken()) {
            return Sets.newHashSet();
        }
        HashSet indexes = Sets.newHashSet();
        indexPlan.getAllLayoutsMap().forEach((layoutId, layout) -> {
            for (Integer id : layout.getColOrder()) {
                if (!invalidScope.contains(id)) continue;
                indexes.add(layoutId);
                break;
            }
        });
        return indexes;
    }

    public String detectFilterCondition(String exp) {
        for (String table : this.antiFlattenLookups) {
            Set<String> aliasSet = this.joinTableAliasMap.get(table);
            if (aliasSet == null) continue;
            for (String alias : aliasSet) {
                String aliasWithBacktick = String.format(Locale.ROOT, "`%s`", alias);
                if (!exp.contains(aliasWithBacktick)) continue;
                return alias;
            }
        }
        return null;
    }

    @Generated
    public Set<String> getAntiFlattenLookups() {
        return this.antiFlattenLookups;
    }
}

