/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.Arrays;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetStore;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryIdOffsetManager {
    public static List<QueryHistoryIdOffset.OffsetType> ALL_OFFSET_TYPE = Arrays.asList(QueryHistoryIdOffset.OffsetType.META, QueryHistoryIdOffset.OffsetType.ACCELERATE);
    private final QueryHistoryIdOffsetStore jdbcIdOffsetStore;
    private final String project;

    private QueryHistoryIdOffsetManager(String project) throws Exception {
        this.project = project;
        this.jdbcIdOffsetStore = new QueryHistoryIdOffsetStore(KylinConfig.getInstanceFromEnv());
    }

    public static QueryHistoryIdOffsetManager getInstance(String project) {
        return (QueryHistoryIdOffsetManager)Singletons.getInstance((String)project, QueryHistoryIdOffsetManager.class);
    }

    public DataSourceTransactionManager getTransactionManager() {
        return this.jdbcIdOffsetStore.getTransactionManager();
    }

    public void saveOrUpdate(QueryHistoryIdOffset idOffset) {
        if (idOffset.getId() == 0) {
            idOffset.setProject(this.project);
            idOffset.setCreateTime(System.currentTimeMillis());
            idOffset.setUpdateTime(idOffset.getCreateTime());
            this.jdbcIdOffsetStore.save(idOffset);
        } else {
            idOffset.setUpdateTime(System.currentTimeMillis());
            this.jdbcIdOffsetStore.update(idOffset);
        }
    }

    public void updateWithoutMvccCheck(QueryHistoryIdOffset idOffset) {
        QueryHistoryIdOffset offset = this.jdbcIdOffsetStore.queryByProject(this.project, idOffset.getType());
        if (offset == null) {
            idOffset.setProject(this.project);
            idOffset.setCreateTime(System.currentTimeMillis());
            idOffset.setUpdateTime(idOffset.getCreateTime());
            this.jdbcIdOffsetStore.save(idOffset);
        } else if (idOffset.getOffset() != offset.getOffset()) {
            idOffset.setUpdateTime(System.currentTimeMillis());
            this.jdbcIdOffsetStore.updateWithoutCheckMvcc(idOffset);
        }
    }

    public QueryHistoryIdOffset copyForWrite(QueryHistoryIdOffset idOffset) {
        return idOffset;
    }

    public void updateOffset(QueryHistoryIdOffset.OffsetType type, QueryHistoryIdOffsetUpdater updater) {
        QueryHistoryIdOffset cached = this.get(type);
        QueryHistoryIdOffset copy = this.copyForWrite(cached);
        updater.modify(copy);
        this.saveOrUpdate(copy);
    }

    public QueryHistoryIdOffset get(QueryHistoryIdOffset.OffsetType type) {
        QueryHistoryIdOffset offset = this.jdbcIdOffsetStore.queryByProject(this.project, type.getName());
        if (offset == null) {
            return new QueryHistoryIdOffset(0L, type);
        }
        return offset;
    }

    public void delete() {
        this.jdbcIdOffsetStore.deleteByProject(this.project);
    }

    public static interface QueryHistoryIdOffsetUpdater {
        public void modify(QueryHistoryIdOffset var1);
    }
}

