/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleMapper;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleTable;
import org.apache.kylin.util.MetadataStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class ModelFavoriteRuleStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelFavoriteRuleStore.class);
    public static final String MODEL_FAVORITE_RULE = "_model_favorite_rule";
    private final ModelFavoriteRuleTable table;
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public ModelFavoriteRuleStore(KylinConfig config) throws Exception {
        this(config, ModelFavoriteRuleStore.genTableName(config));
    }

    private ModelFavoriteRuleStore(KylinConfig config, String tableName) throws Exception {
        StorageURL url = config.getCoreMetadataDBUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new ModelFavoriteRuleTable(tableName);
        this.transactionManager = JdbcDataSource.getTransactionManager((DataSource)dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(MetadataStoreUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime(), MetadataStoreUtil.TableType.MODEL_FAVORITE_RULE));
    }

    private static String genTableName(KylinConfig config) {
        StorageURL url = config.getCoreMetadataDBUrl();
        String tablePrefix = config.isUTEnv() ? "test_opt" : url.getIdentifier();
        return tablePrefix + MODEL_FAVORITE_RULE;
    }

    public void save(FavoriteRule rule) {
        InsertStatementProvider<FavoriteRule> insertStatement;
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        int rows = mapper.insert(insertStatement = this.getInsertProvider(rule));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to insert favorite rule for model (%s)", rule.getModel()));
        }
        log.debug("Insert one favorite rule for model ({}) into database.", (Object)rule.getModel());
    }

    public void update(FavoriteRule rule) {
        UpdateStatementProvider updateStatement;
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateProvider(rule));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update favorite rule for model (%s)", rule.getModel()));
        }
        log.debug("Update one favorite rule for model ({})", (Object)rule.getModel());
    }

    public List<FavoriteRule> queryByProject(String project) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByProjectStatementProvider(project);
        return mapper.selectMany(statementProvider);
    }

    public List<FavoriteRule> queryByModel(String model) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByModelStatementProvider(model);
        return mapper.selectMany(statementProvider);
    }

    public FavoriteRule queryByName(String model, String name) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByNameStatementProvider(model, name);
        return mapper.selectOne(statementProvider);
    }

    public List<FavoriteRule> queryAll() {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    public void deleteByModel(String model) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.model, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete favorite rule for model ({})", (Object)model);
    }

    public void deleteByProject(String project) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where((BindableColumn)this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete model favorite rule for project ({})", (Object)project);
    }

    public void deleteByName(String model, String name) {
        ModelFavoriteRuleMapper mapper = (ModelFavoriteRuleMapper)this.sqlSessionTemplate.getMapper(ModelFavoriteRuleMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.model, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and((BindableColumn)this.table.name, (VisitableCondition)SqlBuilder.isEqualTo((Object)name), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete favorite rule for model ({})", (Object)model);
    }

    InsertStatementProvider<FavoriteRule> getInsertProvider(FavoriteRule rule) {
        InsertDSL provider = SqlBuilder.insert((Object)rule).into((SqlTable)this.table);
        return provider.map(this.table.model).toProperty("model").map(this.table.project).toProperty("project").map(this.table.conds).toProperty("conds").map(this.table.name).toProperty("name").map(this.table.enabled).toProperty("enabled").map(this.table.updateTime).toProperty("updateTime").map(this.table.createTime).toProperty("createTime").map(this.table.mvcc).toProperty("mvcc").build().render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateProvider(FavoriteRule rule) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.conds).equalTo(rule::getConds).set(this.table.updateTime).equalTo(rule::getUpdateTime).set(this.table.enabled).equalTo(rule::isEnabled).set(this.table.mvcc).equalTo((Object)(rule.getMvcc() + 1L)).where((BindableColumn)this.table.id, (VisitableCondition)SqlBuilder.isEqualTo(rule::getId), new AndOrCriteriaGroup[0])).and((BindableColumn)this.table.mvcc, (VisitableCondition)SqlBuilder.isEqualTo(rule::getMvcc), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByModelStatementProvider(String model) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.model, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByProjectStatementProvider(String project) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where((BindableColumn)this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByNameStatementProvider(String model, String name) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.model, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and((BindableColumn)this.table.name, (VisitableCondition)SqlBuilder.isEqualTo((Object)name), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(ModelFavoriteRuleTable ruleTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{ruleTable.id, ruleTable.project, ruleTable.model, ruleTable.conds, ruleTable.name, ruleTable.enabled, ruleTable.updateTime, ruleTable.createTime, ruleTable.mvcc});
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

