/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public abstract class BaseRuleManager {
    protected abstract DataSourceTransactionManager getTransactionManager();

    protected abstract FavoriteRule copyForWrite(FavoriteRule var1);

    protected abstract FavoriteRule getOrDefaultByName(String var1);

    protected abstract void saveOrUpdate(FavoriteRule var1);

    public void updateRule(FavoriteRule rule) {
        this.updateRule(rule.getConds(), rule.isEnabled(), rule.getName());
    }

    public void updateRule(List<FavoriteRule.AbstractCondition> conditions, boolean isEnabled, String ruleName) {
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)this.getTransactionManager(), () -> {
            FavoriteRule copy = this.copyForWrite(this.getOrDefaultByName(ruleName));
            copy.setEnabled(isEnabled);
            ArrayList newConditions = Lists.newArrayList();
            if (!conditions.isEmpty()) {
                newConditions.addAll(conditions);
            }
            copy.setConds(newConditions);
            this.saveOrUpdate(copy);
            return null;
        });
    }
}

