/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm.genetic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.ListPopulation;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.SelectionPolicy;

public class RouletteWheelSelection
implements SelectionPolicy {
    public ChromosomePair select(Population population) throws IllegalArgumentException {
        ArrayList chromosomes = Lists.newArrayList((Iterable)((ListPopulation)population).getChromosomes());
        double maxFitness = 0.0;
        double totalFitness = 0.0;
        for (Chromosome o : chromosomes) {
            double fitness = o.getFitness();
            totalFitness += fitness;
            if (!(fitness > maxFitness)) continue;
            maxFitness = fitness;
        }
        return new ChromosomePair(this.rouletteWheel(chromosomes, totalFitness), this.rouletteWheel(chromosomes, totalFitness));
    }

    private Chromosome rouletteWheel(List<Chromosome> chromosomes, double totalFitness) {
        double rnd = GeneticAlgorithm.getRandomGenerator().nextDouble() * totalFitness;
        double runningScore = 0.0;
        for (Chromosome o : chromosomes) {
            if (rnd >= runningScore && rnd <= runningScore + o.getFitness()) {
                return o;
            }
            runningScore += o.getFitness();
        }
        return null;
    }
}

