/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.OutOfMaxCombinationException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.guava30.shaded.common.base.Predicate;
import org.apache.kylin.guava30.shaded.common.collect.Iterators;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.collect.UnmodifiableIterator;
import org.apache.kylin.metadata.cube.cuboid.CuboidBigInteger;
import org.apache.kylin.metadata.cube.cuboid.CuboidScheduler;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.cuboid.OrderedSet;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KECuboidSchedulerV1
extends CuboidScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KECuboidSchedulerV1.class);
    public static final String INDEX_SCHEDULER_KEY = "kylin.index.rule-scheduler-data";
    public static final String METADATA_INCONSISTENT_ERROR_MSG_PATTERN = "Index metadata might be inconsistent. Please try refreshing all segments in the following model({}/{}), Reason: {}, critical stackTrace:\n{}";
    private final BigInteger max;
    private final int measureSize;
    private final boolean isBaseCuboidValid;
    private final transient Set<CuboidBigInteger> allCuboidIds;
    private final transient SetCreator newHashSet = HashSet::new;
    private final Map<CuboidBigInteger, Set<CuboidBigInteger>> childParents = Maps.newConcurrentMap();

    KECuboidSchedulerV1(IndexPlan indexPlan, RuleBasedIndex ruleBasedAggIndex, boolean skipAllCuboids) {
        super(indexPlan, ruleBasedAggIndex);
        this.max = ruleBasedAggIndex.getFullMask();
        this.measureSize = ruleBasedAggIndex.getMeasures().size();
        this.isBaseCuboidValid = ruleBasedAggIndex.getIndexPlan().getConfig().isBaseCuboidAlwaysValid();
        if (skipAllCuboids) {
            this.allCuboidIds = new OrderedSet<CuboidBigInteger>();
            return;
        }
        if (this.max.bitCount() == 0) {
            this.allCuboidIds = new OrderedSet<CuboidBigInteger>();
        } else {
            SetCreator newCuboidSet = OrderedSet::new;
            this.allCuboidIds = this.buildTreeBottomUp(newCuboidSet);
        }
    }

    @Override
    public int getCuboidCount() {
        return this.allCuboidIds.size();
    }

    @Override
    public void validateOrder() {
        List oldSortingResult;
        List newSortingResult = ((OrderedSet)this.allCuboidIds).getSortedList();
        String data = this.indexPlan.getOverrideProps().get(INDEX_SCHEDULER_KEY);
        if (StringUtils.isEmpty((CharSequence)data)) {
            Set<Object> oldAllCuboidIds = Sets.newHashSet();
            if (this.max.bitCount() > 0) {
                this.childParents.clear();
                oldAllCuboidIds = this.buildTreeBottomUp(this.newHashSet);
            }
            oldSortingResult = Sets.newHashSet((Iterable)oldAllCuboidIds).stream().map(CuboidBigInteger::getDimMeas).collect(Collectors.toList());
        } else {
            oldSortingResult = Stream.of(StringUtils.split((String)data, (String)",")).map(BigInteger::new).collect(Collectors.toList());
        }
        List newSortingOrder = newSortingResult.stream().map(CuboidBigInteger::getDimMeas).collect(Collectors.toList());
        if (!Objects.equals(newSortingOrder, oldSortingResult)) {
            log.error(METADATA_INCONSISTENT_ERROR_MSG_PATTERN, new Object[]{this.indexPlan.getProject(), this.indexPlan.getModelAlias(), ErrorCodeServer.RULE_BASED_INDEX_METADATA_INCONSISTENT, ThreadUtil.getKylinStackTrace()});
            log.debug("Set difference new:{}, old:{}", newSortingOrder, oldSortingResult);
        }
    }

    @Override
    public void updateOrder() {
        List newSortingResult = ((OrderedSet)this.allCuboidIds).getSortedList();
        this.indexPlan.getOverrideProps().put(INDEX_SCHEDULER_KEY, StringUtils.join(newSortingResult, (String)","));
    }

    @Override
    public List<CuboidScheduler.ColOrder> getAllColOrders() {
        return ((OrderedSet)this.allCuboidIds).getSortedList().stream().map(c -> this.extractDimAndMeaFromBigInt(c.getDimMeas())).collect(Collectors.toList());
    }

    private Set<CuboidBigInteger> getOnTreeParents(CuboidBigInteger child, SetCreator setCreatorFunc) {
        if (this.childParents.containsKey(child)) {
            return this.childParents.get(child);
        }
        Set<CuboidBigInteger> parentCandidate = setCreatorFunc.create();
        BigInteger childBits = child.getDimMeas();
        if (this.isBaseCuboidValid && childBits.equals(this.ruleBasedAggIndex.getFullMask())) {
            return parentCandidate;
        }
        for (NAggregationGroup agg : this.ruleBasedAggIndex.getAggregationGroups()) {
            if (childBits.equals(agg.getPartialCubeFullMask()) && this.isBaseCuboidValid) {
                parentCandidate.add(new CuboidBigInteger(this.ruleBasedAggIndex.getFullMask(), this.measureSize));
                continue;
            }
            if (!childBits.equals(BigInteger.ZERO) && !agg.isOnTree(childBits)) continue;
            parentCandidate.addAll(this.getOnTreeParents(child, agg, setCreatorFunc));
        }
        this.childParents.put(child, parentCandidate);
        return parentCandidate;
    }

    private Set<CuboidBigInteger> buildTreeBottomUp(SetCreator setCreatorFunc) {
        Set<CuboidBigInteger> cuboidHolder = setCreatorFunc.create();
        long maxCombination = this.getAggGroupCombinationSize() * 10L;
        maxCombination = maxCombination < 0L ? Integer.MAX_VALUE : maxCombination;
        Set<CuboidBigInteger> children = this.getOnTreeParentsByLayer((Collection<CuboidBigInteger>)Sets.newHashSet((Object[])new CuboidBigInteger[]{new CuboidBigInteger(BigInteger.ZERO)}), setCreatorFunc, maxCombination);
        while (!children.isEmpty()) {
            if ((long)(cuboidHolder.size() + children.size()) > maxCombination) {
                throw new OutOfMaxCombinationException((ErrorCodeProducer)ErrorCodeServer.OUT_OF_MAX_DIM_COMBINATION, new Object[]{maxCombination});
            }
            cuboidHolder.addAll(children);
            children = this.getOnTreeParentsByLayer(children, setCreatorFunc, maxCombination);
        }
        if (this.isBaseCuboidValid) {
            cuboidHolder.add(new CuboidBigInteger(this.ruleBasedAggIndex.getFullMask(), this.measureSize));
        }
        return cuboidHolder;
    }

    private Set<CuboidBigInteger> getOnTreeParentsByLayer(Collection<CuboidBigInteger> children, SetCreator setCreatorFunc, final long maxCombination) {
        Set<CuboidBigInteger> parents = setCreatorFunc.create();
        for (CuboidBigInteger child : children) {
            parents.addAll(this.getOnTreeParents(child, setCreatorFunc));
        }
        UnmodifiableIterator filteredParents = Iterators.filter(parents.iterator(), (Predicate)new Predicate<CuboidBigInteger>(){
            private int cuboidCount = 0;

            public boolean apply(@Nullable CuboidBigInteger cuboidId) {
                if (cuboidId == null) {
                    return false;
                }
                if ((long)this.cuboidCount > maxCombination) {
                    throw new OutOfMaxCombinationException((ErrorCodeProducer)ErrorCodeServer.OUT_OF_MAX_DIM_COMBINATION, new Object[]{maxCombination});
                }
                BigInteger cuboidBits = cuboidId.getDimMeas();
                if (cuboidBits.equals(KECuboidSchedulerV1.this.ruleBasedAggIndex.getFullMask()) && KECuboidSchedulerV1.this.isBaseCuboidValid) {
                    ++this.cuboidCount;
                    return true;
                }
                for (NAggregationGroup agg : KECuboidSchedulerV1.this.ruleBasedAggIndex.getAggregationGroups()) {
                    if (!agg.isOnTree(cuboidBits) || !agg.checkDimCap(cuboidBits)) continue;
                    ++this.cuboidCount;
                    return true;
                }
                return false;
            }
        });
        parents = setCreatorFunc.create();
        while (filteredParents.hasNext()) {
            parents.add((CuboidBigInteger)filteredParents.next());
        }
        return parents;
    }

    @Override
    public List<CuboidScheduler.ColOrder> calculateCuboidsForAggGroup(NAggregationGroup agg) {
        Set<CuboidBigInteger> cuboidHolder = this.newHashSet.create();
        Set<CuboidBigInteger> children = this.getOnTreeParentsByLayer((Collection<CuboidBigInteger>)Sets.newHashSet((Object[])new CuboidBigInteger[]{new CuboidBigInteger(BigInteger.ZERO)}), agg, this.newHashSet);
        while (!children.isEmpty()) {
            if ((long)(cuboidHolder.size() + children.size()) > this.getAggGroupCombinationSize()) {
                throw new OutOfMaxCombinationException((ErrorCodeProducer)ErrorCodeServer.OUT_OF_MAX_DIM_COMBINATION, new Object[]{this.getAggGroupCombinationSize()});
            }
            cuboidHolder.addAll(children);
            children = this.getOnTreeParentsByLayer(children, agg, this.newHashSet);
        }
        return cuboidHolder.stream().map(c -> this.extractDimAndMeaFromBigInt(c.getDimMeas())).collect(Collectors.toList());
    }

    private Set<CuboidBigInteger> getOnTreeParentsByLayer(Collection<CuboidBigInteger> children, NAggregationGroup agg, SetCreator setCreatorFunc) {
        Set<CuboidBigInteger> parents = setCreatorFunc.create();
        for (CuboidBigInteger child : children) {
            parents.addAll(this.getOnTreeParents(child, agg, setCreatorFunc));
        }
        UnmodifiableIterator filteredParent = Iterators.filter(parents.iterator(), cuboidId -> {
            if (cuboidId == null) {
                return false;
            }
            return agg.checkDimCap(cuboidId.getDimMeas());
        });
        parents = setCreatorFunc.create();
        while (filteredParent.hasNext()) {
            parents.add((CuboidBigInteger)filteredParent.next());
        }
        return parents;
    }

    private Set<CuboidBigInteger> getOnTreeParents(CuboidBigInteger child, NAggregationGroup agg, SetCreator setCreatorFunc) {
        Set<CuboidBigInteger> parentCandidate = setCreatorFunc.create();
        BigInteger tmpChild = child.getDimMeas();
        if (tmpChild.equals(agg.getPartialCubeFullMask())) {
            return parentCandidate;
        }
        if (!agg.getMandatoryColumnMask().equals(agg.getMeasureMask())) {
            if (agg.isMandatoryOnlyValid()) {
                if (this.fillBit(tmpChild, agg.getMandatoryColumnMask(), parentCandidate)) {
                    return parentCandidate;
                }
            } else {
                tmpChild = tmpChild.or(agg.getMandatoryColumnMask());
            }
        }
        for (BigInteger normal : agg.getNormalDimMeas()) {
            this.fillBit(tmpChild, normal, parentCandidate);
        }
        for (BigInteger joint : agg.getJoints()) {
            this.fillBit(tmpChild, joint, parentCandidate);
        }
        for (NAggregationGroup.HierarchyMask hierarchy : agg.getHierarchyMasks()) {
            for (BigInteger mask : hierarchy.getAllMasks()) {
                if (this.fillBit(tmpChild, mask, parentCandidate)) break;
            }
        }
        return parentCandidate;
    }

    private boolean fillBit(BigInteger origin, BigInteger other, Set<CuboidBigInteger> coll) {
        if (!origin.and(other).equals(other)) {
            coll.add(new CuboidBigInteger(origin.or(other), this.measureSize));
            return true;
        }
        return false;
    }

    private static interface SetCreator {
        public Set<CuboidBigInteger> create();
    }
}

