/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.cuboid.AggIndexMatcher;
import org.apache.kylin.metadata.cube.cuboid.TableIndexMatcher;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChooserContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChooserContext.class);
    final NDataModel model;
    final ImmutableMultimap<Integer, Integer> fk2Pk;
    final Map<TblColRef, Integer> tblColMap = Maps.newHashMap();
    final Map<String, List<Integer>> primaryKeyColumnIds = Maps.newHashMap();
    final Map<String, List<Integer>> foreignKeyColumnIds = Maps.newHashMap();
    final Map<Integer, TableExtDesc.ColumnStats> columnStatMap = Maps.newHashMap();
    final KylinConfig kylinConfig;
    SQLDigest sqlDigest;
    AggIndexMatcher aggIndexMatcher;
    TableIndexMatcher tableIndexMatcher;

    public ChooserContext(NDataModel model) {
        this.model = model;
        this.kylinConfig = NProjectManager.getProjectConfig(model.getProject());
        ImmutableMultimap.Builder fk2PkBuilder = ImmutableMultimap.builder();
        this.initModelContext(model, (ImmutableMultimap.Builder<Integer, Integer>)fk2PkBuilder);
        if (this.isBatchFusionModel()) {
            NDataModel streamingModel = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject()).getDataModelDesc(model.getFusionId());
            this.initModelContext(streamingModel, (ImmutableMultimap.Builder<Integer, Integer>)fk2PkBuilder);
        }
        this.fk2Pk = fk2PkBuilder.build();
    }

    public ChooserContext(SQLDigest sqlDigest, NDataflow dataflow) {
        this(dataflow.getModel());
        this.sqlDigest = sqlDigest;
        this.prepareIndexMatchers(sqlDigest, dataflow);
    }

    private void prepareIndexMatchers(SQLDigest sqlDigest, NDataflow dataflow) {
        String project = dataflow.getProject();
        ColExcludedChecker excludedChecker = new ColExcludedChecker(this.kylinConfig, project, this.model);
        if (log.isDebugEnabled()) {
            log.debug("When matching layouts, all deduced excluded columns are: {}", excludedChecker.getExcludedColNames());
        }
        AntiFlatChecker antiFlatChecker = new AntiFlatChecker(this.model.getJoinTables(), this.model);
        if (log.isDebugEnabled()) {
            log.debug("When matching layouts, all deduced anti-flatten lookup tables are: {}", antiFlatChecker.getAntiFlattenLookups());
        }
        this.aggIndexMatcher = new AggIndexMatcher(sqlDigest, this, dataflow, excludedChecker, antiFlatChecker);
        this.tableIndexMatcher = new TableIndexMatcher(sqlDigest, this, dataflow, excludedChecker, antiFlatChecker);
    }

    public boolean isIndexMatchersInvalid() {
        boolean invalid;
        boolean bl = invalid = !this.getAggIndexMatcher().isValid() && !this.getTableIndexMatcher().isValid();
        if (invalid) {
            log.warn("Unfortunately, the fast check has failed. It's possible that the queried columns contain null values, which could be due to the computed column not being present in the model.");
        }
        return invalid;
    }

    public TableExtDesc.ColumnStats getColumnStats(TblColRef ref) {
        int colId = this.tblColMap.getOrDefault(ref, -1);
        return this.columnStatMap.get(colId);
    }

    public TblColRef convertToRef(Integer colId) {
        return (TblColRef)this.model.getEffectiveCols().get((Object)colId);
    }

    public Collection<TblColRef> convertToRefs(Collection<Integer> colIds) {
        ArrayList refs = Lists.newArrayList();
        for (Integer colId : colIds) {
            refs.add(this.convertToRef(colId));
        }
        return refs;
    }

    public boolean isBatchFusionModel() {
        return this.model.isFusionModel() && !this.model.isStreaming();
    }

    private void initModelContext(NDataModel dataModel, ImmutableMultimap.Builder<Integer, Integer> fk2PkBuilder) {
        ImmutableBiMap<Integer, TblColRef> effectiveCols = dataModel.getEffectiveCols();
        effectiveCols.forEach((key, value) -> this.tblColMap.put((TblColRef)value, (Integer)key));
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager tblMetaMgr = NTableMetadataManager.getInstance(config, this.model.getProject());
        effectiveCols.keySet().forEach(colId -> {
            TableExtDesc.ColumnStats stats = TableExtDesc.ColumnStats.getColumnStats(tblMetaMgr, (TblColRef)effectiveCols.get(colId));
            this.columnStatMap.put((Integer)colId, stats);
        });
        if (CollectionUtils.isEmpty(dataModel.getJoinTables())) {
            return;
        }
        dataModel.getJoinTables().forEach(joinDesc -> {
            ArrayList pks = Lists.newArrayList();
            ArrayList fks = Lists.newArrayList();
            this.primaryKeyColumnIds.put(joinDesc.getAlias(), Arrays.stream(joinDesc.getJoin().getPrimaryKeyColumns()).map(this.tblColMap::get).collect(Collectors.toList()));
            this.foreignKeyColumnIds.put(joinDesc.getAlias(), Arrays.stream(joinDesc.getJoin().getForeignKeyColumns()).map(this.tblColMap::get).collect(Collectors.toList()));
            JoinDesc join = joinDesc.getJoin();
            int n = join.getForeignKeyColumns().length;
            for (int i = 0; i < n; ++i) {
                TblColRef pk = join.getPrimaryKeyColumns()[i];
                TblColRef fk = join.getForeignKeyColumns()[i];
                Integer pkId = this.tblColMap.get(pk);
                Integer fkId = this.tblColMap.get(fk);
                pks.add(pkId);
                fks.add(fkId);
                fk2PkBuilder.put((Object)fkId, (Object)pkId);
            }
            this.primaryKeyColumnIds.put(joinDesc.getAlias(), pks);
            this.foreignKeyColumnIds.put(joinDesc.getAlias(), fks);
        });
    }

    @Generated
    public NDataModel getModel() {
        return this.model;
    }

    @Generated
    public ImmutableMultimap<Integer, Integer> getFk2Pk() {
        return this.fk2Pk;
    }

    @Generated
    public Map<TblColRef, Integer> getTblColMap() {
        return this.tblColMap;
    }

    @Generated
    public Map<String, List<Integer>> getPrimaryKeyColumnIds() {
        return this.primaryKeyColumnIds;
    }

    @Generated
    public Map<String, List<Integer>> getForeignKeyColumnIds() {
        return this.foreignKeyColumnIds;
    }

    @Generated
    public Map<Integer, TableExtDesc.ColumnStats> getColumnStatMap() {
        return this.columnStatMap;
    }

    @Generated
    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    @Generated
    public SQLDigest getSqlDigest() {
        return this.sqlDigest;
    }

    @Generated
    public AggIndexMatcher getAggIndexMatcher() {
        return this.aggIndexMatcher;
    }

    @Generated
    public TableIndexMatcher getTableIndexMatcher() {
        return this.tableIndexMatcher;
    }
}

