/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cachesync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.TransparentResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CustomKeyEquivalenceCacheBuilder;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CacheReloadChecker;
import org.apache.kylin.metadata.model.exception.ModelBrokenException;
import org.apache.kylin.util.BrokenEntityProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedCrudAssist<T extends RootPersistentEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedCrudAssist.class);
    private final ResourceStore store;
    private final Class<T> entityType;
    private final MetadataType type;
    private final String project;
    private final Serializer<T> serializer;
    private final Cache<String, T> cache;
    private final CacheReloadChecker<T> checker;
    private boolean checkCopyOnWrite;

    public CachedCrudAssist(ResourceStore store, MetadataType type, String project, Class<T> entityType) {
        this.store = store;
        this.entityType = entityType;
        this.type = type;
        this.project = project;
        this.serializer = new JsonSerializer(entityType);
        this.cache = CustomKeyEquivalenceCacheBuilder.newBuilder(type).build();
        this.checker = new CacheReloadChecker(store, this);
        this.checkCopyOnWrite = store.getConfig().isCheckCopyOnWrite();
        Preconditions.checkArgument((type != MetadataType.ALL ? 1 : 0) != 0);
    }

    public Serializer<T> getSerializer() {
        return this.serializer;
    }

    public void setCheckCopyOnWrite(boolean check) {
        this.checkCopyOnWrite = check;
    }

    public T copyForWrite(T entity) {
        T reloadedEntity;
        if (entity == null) {
            return null;
        }
        if (UnitOfWork.isAlreadyInTransaction()) {
            UnitOfWork.get().getCopyForWriteItems().add(this.resourcePath(entity.resourceName()));
        }
        if ((reloadedEntity = this.get(entity.resourceName(), true)) == null) {
            if (entity.getMvcc() == -1L) {
                return this.copyIfCachedAndShared(entity);
            }
            return null;
        }
        if (reloadedEntity.isBroken()) {
            return this.copyIfCachedAndShared(entity);
        }
        return this.copyIfCachedAndShared(reloadedEntity);
    }

    public static <T extends RootPersistentEntity> T copyForWrite(T entity, Serializer<T> serializer, @Nullable BiConsumer<T, String> initEntity, ResourceStore store) {
        RootPersistentEntity reloadedEntity;
        if (entity == null) {
            return null;
        }
        if (UnitOfWork.isAlreadyInTransaction()) {
            UnitOfWork.get().getCopyForWriteItems().add(entity.getResourcePath());
        }
        if ((reloadedEntity = store.getResource(entity.getResourcePath(), serializer, true)) == null) {
            if (entity.getMvcc() == -1L) {
                return (T)JsonUtil.copyForWrite(entity, serializer, initEntity);
            }
            return null;
        }
        if (reloadedEntity.isBroken()) {
            return (T)JsonUtil.copyForWrite(entity, serializer, initEntity);
        }
        if (initEntity != null) {
            initEntity.accept(reloadedEntity, reloadedEntity.resourceName());
        }
        return (T)JsonUtil.copyForWrite((RootPersistentEntity)reloadedEntity, serializer, initEntity);
    }

    public T copyIfCachedAndShared(T entity) {
        return (T)JsonUtil.copyForWrite(entity, this.serializer, this::initEntityAfterReload);
    }

    public T copyBySerialization(T entity) {
        return (T)JsonUtil.copyBySerialization(entity, this.serializer, this::initEntityAfterReload);
    }

    public String resourcePath(String resourceName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)resourceName), (String)"The resource name \"{}\" cannot contain white character", (Object)resourceName);
        return MetadataType.mergeKeyWithType((String)resourceName, (MetadataType)this.type);
    }

    private String resourceName(String resourcePath) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith(this.type.name()));
        return (String)MetadataType.splitKeyWithType((String)resourcePath).getSecond();
    }

    public void reloadAll() {
        log.trace("Reloading {} from {}", (Object)this.entityType.getSimpleName(), (Object)this.store.getReadableResourcePath(this.type.name()));
        this.cache.invalidateAll();
        RawResourceFilter filter = StringUtils.isEmpty((CharSequence)this.project) ? new RawResourceFilter() : RawResourceFilter.equalFilter((String)"project", (String)this.project);
        List paths = this.store.collectResourceRecursively(this.type, filter);
        for (String path : paths) {
            this.reloadQuietlyAt(path);
        }
        log.trace("Loaded {} {}(s) out of {} resource from {}", new Object[]{this.cache.size(), this.entityType.getSimpleName(), paths.size(), this.store.getReadableResourcePath(this.type.name())});
    }

    private T reload(String resourceName) {
        return this.reloadAt(this.resourcePath(resourceName));
    }

    private T reloadQuietlyAt(String path) {
        try {
            return this.reloadAt(path);
        }
        catch (Exception ex) {
            log.error("Error loading {} at {}", new Object[]{this.entityType.getSimpleName(), path, ex});
            return null;
        }
    }

    public T reloadAt(String path) {
        RootPersistentEntity entity = null;
        try {
            entity = this.store.getResource(path, this.serializer);
            if (entity == null) {
                throw new IllegalStateException("No " + this.entityType.getSimpleName() + " found at " + path + ", returning null");
            }
            entity.setCachedAndShared(true);
            entity = this.initEntityAfterReload(entity, this.resourceName(path));
            if (!path.equalsIgnoreCase(this.resourcePath(entity.resourceName()))) {
                throw new IllegalStateException("The entity " + entity + " read from " + path + " will save to a different path " + this.resourcePath(entity.resourceName()));
            }
        }
        catch (Exception e) {
            log.warn("Error loading {} at {} entity, return a BrokenEntity", new Object[]{this.entityType.getSimpleName(), path, e});
            entity = this.initBrokenEntity(entity, this.resourceName(path));
        }
        this.cache.put((Object)entity.resourceName(), (Object)entity);
        return (T)entity;
    }

    public boolean exists(String resourceName) {
        return this.store.getResource(this.resourcePath(resourceName)) != null;
    }

    public T get(String resourceName) {
        return this.get(resourceName, false);
    }

    private T get(String resourceName, boolean needLock) {
        String resourcePath = this.resourcePath(resourceName);
        if (this.store instanceof TransparentResourceStore && needLock) {
            RootPersistentEntity entity = this.store.getResource(resourcePath, this.serializer, true);
            if (entity != null) {
                try {
                    entity = this.initEntityAfterReload(entity, resourceName);
                }
                catch (ModelBrokenException ignore) {
                    entity = this.initBrokenEntity(entity, resourceName);
                }
            }
            return (T)entity;
        }
        RawResource raw = this.store.getResource(resourcePath, needLock);
        if (raw == null || this.project != null && raw.getProject() != null && !this.project.equals(raw.getProject())) {
            this.cache.invalidate((Object)resourceName);
            return null;
        }
        if (this.checker.needReload(resourceName)) {
            this.reloadAt(resourcePath);
        }
        return (T)((RootPersistentEntity)this.cache.getIfPresent((Object)resourceName));
    }

    public void invalidateCache(String resourceName) {
        this.cache.invalidate((Object)resourceName);
    }

    protected abstract T initEntityAfterReload(T var1, String var2);

    protected T initBrokenEntity(T entity, String resourceName) {
        String resourcePath = this.resourcePath(resourceName);
        T brokenEntity = BrokenEntityProxy.getProxy(this.entityType, resourcePath);
        brokenEntity.setUuid(resourceName);
        if (entity != null) {
            brokenEntity.setMvcc(entity.getMvcc());
        }
        return brokenEntity;
    }

    public T save(T entity) {
        String resName;
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0);
        Preconditions.checkArgument((entity.getUuid() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.entityType.isInstance(entity));
        if (this.project != null) {
            entity.setProject(this.project);
        }
        Preconditions.checkArgument(((resName = entity.resourceName()) != null && resName.length() > 0 ? 1 : 0) != 0);
        if (this.checkCopyOnWrite && (entity.isCachedAndShared() || this.cache.getIfPresent((Object)resName) == entity)) {
            throw new IllegalStateException("Copy-on-write violation! The updating entity " + entity + " is a shared object in " + this.entityType.getSimpleName() + " cache, which should not be.");
        }
        String path = this.resourcePath(resName);
        log.trace("Saving {} at {}", (Object)this.entityType.getSimpleName(), (Object)path);
        this.store.checkAndPutResource(path, entity, this.serializer);
        return this.reload(resName);
    }

    public void delete(T entity) {
        this.delete(entity.resourceName());
    }

    public void delete(String resName) {
        Preconditions.checkArgument((resName != null ? 1 : 0) != 0);
        String path = this.resourcePath(resName);
        log.debug("Deleting {} at {}", (Object)this.entityType.getSimpleName(), (Object)path);
        this.store.deleteResource(path);
        this.cache.invalidate((Object)resName);
    }

    public List<T> listAll() {
        if (UnitOfWork.isAlreadyInTransaction() && log.isTraceEnabled()) {
            log.trace("list all,\n{}", (Object)ThreadUtil.getKylinStackTrace());
        }
        return this.listByFilter(new RawResourceFilter());
    }

    public List<T> listByFilter(RawResourceFilter filter) {
        if (!StringUtils.isEmpty((CharSequence)this.project)) {
            filter.addConditions("project", Collections.singletonList(this.project), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
        }
        return this.store.collectResourceRecursively(this.type, filter).stream().map(path -> this.get(this.resourceName((String)path))).filter(Objects::nonNull).collect(Collectors.toCollection(Lists::newArrayList));
    }

    protected List<T> listAllValidCache() {
        ArrayList all = Lists.newArrayList();
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            if (!this.exists((String)e.getKey())) continue;
            all.add(e.getValue());
        }
        return all;
    }

    public boolean contains(String name) {
        return this.store.getResource(this.resourcePath(name)) != null;
    }

    @Generated
    protected Cache<String, T> getCache() {
        return this.cache;
    }
}

