/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.corr;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.corr.CorrAggFunc;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;

public class CorrMeasureType
extends MeasureType {
    public static final String FUNC_CORR = "CORR";
    public static final String DATATYPE_CORR = "corr";
    private static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"CORR", CorrAggFunc.class);

    public MeasureIngester newIngester() {
        return null;
    }

    public MeasureAggregator newAggregator() {
        return null;
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    @Override
    public boolean expandable() {
        return true;
    }

    @Override
    public List<FunctionDesc> convertToInternalFunctionDesc(FunctionDesc functionDesc) {
        ArrayList parameterDescList = Lists.newArrayList();
        for (ParameterDesc parameter : functionDesc.getParameters()) {
            parameter.getColRef();
            parameterDescList.add(parameter);
        }
        ArrayList functionDescs = Lists.newArrayList();
        ArrayList descs = Lists.newArrayList();
        for (int i = 0; i < parameterDescList.size(); ++i) {
            for (int j = i; j < parameterDescList.size(); ++j) {
                ParameterDesc newParam = new ParameterDesc();
                newParam.setType("math_expression");
                newParam.setValue(String.format(Locale.ROOT, "%s * %s", ((ParameterDesc)parameterDescList.get(i)).getValue(), ((ParameterDesc)parameterDescList.get(j)).getValue()));
                descs.add(newParam);
            }
        }
        parameterDescList.addAll(descs);
        for (ParameterDesc param : parameterDescList) {
            FunctionDesc function = FunctionDesc.newInstance("SUM", Lists.newArrayList((Object[])new ParameterDesc[]{param}), null);
            functionDescs.add(function);
        }
        return functionDescs;
    }

    public static class Factory
    extends MeasureTypeFactory {
        public MeasureType createMeasureType(String funcName, DataType dataType) {
            return new CorrMeasureType();
        }

        @Override
        public String getAggrFunctionName() {
            return CorrMeasureType.FUNC_CORR;
        }

        @Override
        public String getAggrDataTypeName() {
            return CorrMeasureType.DATATYPE_CORR;
        }

        public Class<? extends DataTypeSerializer> getAggrDataTypeSerializer() {
            return null;
        }
    }
}

