/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class AbstractDateDimEnc
extends DimensionEncoding {
    private static final long serialVersionUID = 1L;
    private int fixedLen;
    private IValueCodec codec;

    public AbstractDateDimEnc() {
    }

    protected AbstractDateDimEnc(int fixedLen, IValueCodec codec) {
        this.fixedLen = fixedLen;
        this.codec = codec;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(String value, byte[] output, int outputOffset) {
        if (value == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        long code = this.codec.valueToCode(value);
        BytesUtil.writeLong((long)code, (byte[])output, (int)outputOffset, (int)this.fixedLen);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        if (AbstractDateDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        long code = BytesUtil.readLong((byte[])bytes, (int)offset, (int)this.fixedLen);
        if (code < 0L) {
            throw new IllegalArgumentException();
        }
        return this.codec.codeToValue(code);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new DataTypeSerializer<Object>(){

            private byte[] currentBuf() {
                byte[] buf = (byte[])this.current.get();
                if (buf == null) {
                    buf = new byte[AbstractDateDimEnc.this.fixedLen];
                    this.current.set(buf);
                }
                return buf;
            }

            public void serialize(Object value, ByteBuffer out) {
                byte[] buf = this.currentBuf();
                String valueStr = value == null ? null : value.toString();
                AbstractDateDimEnc.this.encode(valueStr, buf, 0);
                out.put(buf);
            }

            public Object deserialize(ByteBuffer in) {
                byte[] buf = this.currentBuf();
                in.get(buf);
                return AbstractDateDimEnc.this.decode(buf, 0, buf.length);
            }

            @Override
            public int peekLength(ByteBuffer in) {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public int maxLength() {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public int getStorageBytesEstimate() {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public Object valueOf(String str) {
                return str;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fixedLen);
        out.writeObject(this.codec);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readInt();
        this.codec = (IValueCodec)in.readObject();
    }

    static interface IValueCodec
    extends Serializable {
        public long valueToCode(String var1);

        public String codeToValue(long var1);
    }
}

