/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.delta.ColumnWithDefaultExprUtils$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.delta.commands.WriteIntoDelta;
import org.apache.spark.sql.delta.commands.WriteIntoDelta$;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaDataSource$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSink;
import org.apache.spark.sql.delta.sources.DeltaSource;
import org.apache.spark.sql.delta.sources.DeltaSource$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rc\u0001\u0002\u0015*\u0001YBQ\u0001\u0018\u0001\u0005\u0002uCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u0019\u0001\u0005B!DQ!\u001d\u0001\u0005BIDq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002Z\u0001!\t%a\u0017\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u00111\u0016\u0001\u0005B\u00055\u0006bBAV\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003S\u0004A\u0011IAv\u000f\u001d\ti/\u000bE\u0001\u0003_4a\u0001K\u0015\t\u0002\u0005E\bB\u0002/\r\t\u0003\u00119\u0001C\u0005\u0003\n1\u0011\r\u0011b\u0003\u0003\f!A!Q\b\u0007!\u0002\u0013\u0011i\u0001C\u0005\u0003@1\u0011\r\u0011\"\u0002\u0003B!A!\u0011\n\u0007!\u0002\u001b\u0011\u0019\u0005C\u0005\u0003L1\u0011\r\u0011\"\u0002\u0003N!A!Q\u000b\u0007!\u0002\u001b\u0011y\u0005C\u0005\u0003X1\u0011\r\u0011\"\u0002\u0003Z!A!\u0011\r\u0007!\u0002\u001b\u0011Y\u0006C\u0005\u0003d1\u0011\r\u0011\"\u0002\u0003f!A!Q\u000e\u0007!\u0002\u001b\u00119\u0007C\u0005\u0003p1\u0011\r\u0011\"\u0002\u0003r!A!\u0011\u0010\u0007!\u0002\u001b\u0011\u0019\bC\u0005\u0003|1\u0011\r\u0011\"\u0002\u0003~!A!Q\u0011\u0007!\u0002\u001b\u0011y\bC\u0005\u0003\b2\u0011\r\u0011\"\u0002\u0003\n\"A!\u0011\u0013\u0007!\u0002\u001b\u0011Y\tC\u0005\u0003\u00142\u0011\r\u0011\"\u0002\u0003\u0016\"A!Q\u0014\u0007!\u0002\u001b\u00119\nC\u0005\u0003 2\u0011\r\u0011\"\u0002\u0003\"\"A!\u0011\u0016\u0007!\u0002\u001b\u0011\u0019\u000bC\u0004\u0003,2!\tA!,\t\u000f\tMF\u0002\"\u0001\u00036\"9!1\u0018\u0007\u0005\u0002\tu\u0006b\u0002Br\u0019\u0011\u0005!Q\u001d\u0005\b\u00073aA\u0011AB\u000e\u0011\u001d\u0019i\u0004\u0004C\u0001\u0007\u007f\u0011q\u0002R3mi\u0006$\u0015\r^1T_V\u00148-\u001a\u0006\u0003U-\nqa]8ve\u000e,7O\u0003\u0002-[\u0005)A-\u001a7uC*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001MI\u0001aN\u001fC\u000b\"[eJ\u0016\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\u0002U\"A \u000b\u0005)j\u0013BA!@\u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002?\u0007&\u0011Ai\u0010\u0002\u0015'R\u0014X-Y7T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u0005y2\u0015BA$@\u0005I\u0019FO]3b[NKgn\u001b)s_ZLG-\u001a:\u0011\u0005yJ\u0015B\u0001&@\u0005e\u0019%/Z1uC\ndWMU3mCRLwN\u001c)s_ZLG-\u001a:\u0011\u0005yb\u0015BA'@\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016aB2bi\u0006dwn\u001a\u0006\u0003'6\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005U\u0003&!\u0004+bE2,\u0007K]8wS\u0012,'\u000f\u0005\u0002X56\t\u0001L\u0003\u0002ZW\u0005AQ.\u001a;fe&tw-\u0003\u0002\\1\naA)\u001a7uC2{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u0018\t\u0003?\u0002i\u0011!K\u0001\fS:4WM]*dQ\u0016l\u0017-F\u0001c!\t\u0019g-D\u0001e\u0015\t)W&A\u0003usB,7/\u0003\u0002hI\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u0005\tL\u0007\"\u00026\u0004\u0001\u0004Y\u0017aB8qi&|gn\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]6\nA!\u001e;jY&\u0011\u0001/\u001c\u0002\u0019\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004\u0018\u0001C4fiR\u000b'\r\\3\u0015\u000bM4\b0a\u0002\u0011\u0005=#\u0018BA;Q\u0005\u0015!\u0016M\u00197f\u0011\u00159H\u00011\u0001c\u0003\u0019\u00198\r[3nC\")\u0011\u0010\u0002a\u0001u\u0006a\u0001/\u0019:uSRLwN\\5oOB\u0019\u0001h_?\n\u0005qL$!B!se\u0006L\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002I\u000b1\"\u001a=qe\u0016\u001c8/[8og&\u0019\u0011QA@\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007bBA\u0005\t\u0001\u0007\u00111B\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003CA\u0007\u0003+\tI\"!\u0007\u000e\u0005\u0005=!b\u00018\u0002\u0012)\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u0005=!aA'baB!\u00111DA\u0015\u001d\u0011\ti\"!\n\u0011\u0007\u0005}\u0011(\u0004\u0002\u0002\")\u0019\u00111E\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t9#O\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0012(\u0001\u0007t_V\u00148-Z*dQ\u0016l\u0017\r\u0006\u0006\u00024\u0005e\u0012QIA'\u0003#\u0002b\u0001OA\u001b\u00033\u0011\u0017bAA\u001cs\t1A+\u001e9mKJBq!a\u000f\u0006\u0001\u0004\ti$\u0001\u0006tc2\u001cuN\u001c;fqR\u0004B!a\u0010\u0002B5\tQ&C\u0002\u0002D5\u0012!bU)M\u0007>tG/\u001a=u\u0011\u00199X\u00011\u0001\u0002HA!\u0001(!\u0013c\u0013\r\tY%\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005=S\u00011\u0001\u0002\u001a\u0005a\u0001O]8wS\u0012,'OT1nK\"9\u00111K\u0003A\u0002\u0005U\u0013A\u00039be\u0006lW\r^3sgBA\u00111DA,\u00033\tI\"\u0003\u0003\u0002\u0018\u00055\u0012\u0001D2sK\u0006$XmU8ve\u000e,G\u0003DA/\u0003[\ny'a\u001d\u0002v\u0005]\u0004\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\ngR\u0014X-Y7j]\u001eT1!a\u001a.\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002l\u0005\u0005$AB*pkJ\u001cW\rC\u0004\u0002<\u0019\u0001\r!!\u0010\t\u000f\u0005Ed\u00011\u0001\u0002\u001a\u0005aQ.\u001a;bI\u0006$\u0018\rU1uQ\"1qO\u0002a\u0001\u0003\u000fBq!a\u0014\u0007\u0001\u0004\tI\u0002C\u0004\u0002T\u0019\u0001\r!!\u0016\u0002\u0015\r\u0014X-\u0019;f'&t7\u000e\u0006\u0006\u0002~\u0005\r\u0015QQAD\u0003;\u0003B!a\u0018\u0002\u0000%!\u0011\u0011QA1\u0005\u0011\u0019\u0016N\\6\t\u000f\u0005mr\u00011\u0001\u0002>!9\u00111K\u0004A\u0002\u0005U\u0003bBAE\u000f\u0001\u0007\u00111R\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u0004b!!$\u0002\u0018\u0006ea\u0002BAH\u0003'sA!a\b\u0002\u0012&\t!(C\u0002\u0002\u0016f\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001a\u0006m%aA*fc*\u0019\u0011QS\u001d\t\u000f\u0005}u\u00011\u0001\u0002\"\u0006Qq.\u001e;qkRlu\u000eZ3\u0011\t\u0005\r\u0016qU\u0007\u0003\u0003KS1!a\u0019.\u0013\u0011\tI+!*\u0003\u0015=+H\u000f];u\u001b>$W-\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\u0015\u0005=\u0016QWA\\\u0003\u0003\f\u0019\rE\u0002?\u0003cK1!a-@\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u001d\tY\u0004\u0003a\u0001\u0003{Aq!!/\t\u0001\u0004\tY,\u0001\u0003n_\u0012,\u0007\u0003BA \u0003{K1!a0.\u0005!\u0019\u0016M^3N_\u0012,\u0007bBA*\u0011\u0001\u0007\u0011Q\u000b\u0005\b\u0003\u000bD\u0001\u0019AAd\u0003\u0011!\u0017\r^1\u0011\t\u0005%\u0017Q\u001c\b\u0005\u0003\u0017\fYN\u0004\u0003\u0002N\u0006eg\u0002BAh\u0003/tA!!5\u0002V:!\u0011qDAj\u0013\u0005!\u0014B\u0001\u001a4\u0013\t\u0001\u0014'\u0003\u0002/_%\u0019\u0011QS\u0017\n\t\u0005}\u0017\u0011\u001d\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!&.)\u0019\ty+!:\u0002h\"9\u00111H\u0005A\u0002\u0005u\u0002bBA*\u0013\u0001\u0007\u0011QK\u0001\ng\"|'\u000f\u001e(b[\u0016$\"!!\u0007\u0002\u001f\u0011+G\u000e^1ECR\f7k\\;sG\u0016\u0004\"a\u0018\u0007\u0014\t19\u00141\u001f\t\u0005\u0003k\u0014\u0019!\u0004\u0002\u0002x*\u0019a.!?\u000b\u0007A\nYP\u0003\u0003\u0002~\u0006}\u0018A\u00033bi\u0006\u0014'/[2lg*\u0011!\u0011A\u0001\u0004G>l\u0017\u0002\u0002B\u0003\u0003o\u0014\u0011\u0003R1uC\n\u0014\u0018nY6t\u0019><w-\u001b8h)\t\ty/A\u0004g_Jl\u0017\r^:\u0016\u0005\t5!#\u0002B\bo\tuaA\u0002B\t\u0001\u0001\u0011iA\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0003\u0003\n\tU\u0011\u0002\u0002B\f\u00053\u0011QbU3sS\u0006d\u0017N_1uS>t'b\u0001B\u000eg\u00051!n]8oiM\u0004BAa\b\u0003\"5\u0011!\u0011D\u0005\u0005\u0005G\u0011IBA\u0004G_Jl\u0017\r^:\t\u0015\t\u001d\"q\u0002b\u0001\n\u0003\u0011I#\u0001\u0006eCR,gi\u001c:nCR,\"Aa\u000b\u0011\t\t}!QF\u0005\u0005\u0005_\u0011IB\u0001\u0006ECR,gi\u001c:nCRD!Ba\r\u0003\u0010\t\u0007I\u0011\tB\u001b\u0003%!\u0018\u0010]3IS:$8/\u0006\u0002\u00038A!!q\u0004B\u001d\u0013\u0011\u0011YD!\u0007\u0003\u0013QK\b/\u001a%j]R\u001c\u0018\u0001\u00034pe6\fGo\u001d\u0011\u0002-QKU*R0U%\u00063V\tT0T\u001fV\u00136)R0L\u000bf+\"Aa\u0011\u0010\u0005\t\u0015\u0013E\u0001B$\u0003Yyv\f^5nK~#(/\u0019<fY~\u001bx.\u001e:dK~{\u0016a\u0006+J\u001b\u0016{FKU!W\u000b2{6kT+S\u0007\u0016{6*R-!\u0003e!\u0016*T#`)J\u000be+\u0012'`)&kUi\u0015+B\u001bB{6*R-\u0016\u0005\t=sB\u0001B)C\t\u0011\u0019&A\u0007uS6,7\u000f^1na\u0006\u001bxJZ\u0001\u001b)&kUi\u0018+S\u0003Z+Ej\u0018+J\u001b\u0016\u001bF+Q'Q?.+\u0015\fI\u0001\u0018)&kUi\u0018+S\u0003Z+Ej\u0018,F%NKuJT0L\u000bf+\"Aa\u0017\u0010\u0005\tu\u0013E\u0001B0\u0003-1XM]:j_:\f5o\u00144\u00021QKU*R0U%\u00063V\tT0W\u000bJ\u001b\u0016j\u0014(`\u0017\u0016K\u0006%A\u000bD\t\u000e{6\u000bV!S)~3VIU*J\u001f:{6*R-\u0016\u0005\t\u001dtB\u0001B5C\t\u0011Y'A\bti\u0006\u0014H/\u001b8h-\u0016\u00148/[8o\u0003Y\u0019EiQ0T)\u0006\u0013Fk\u0018,F%NKuJT0L\u000bf\u0003\u0013aF\"E\u0007~\u001bF+\u0011*U?RKU*R*U\u00036\u0003vlS#Z+\t\u0011\u0019h\u0004\u0002\u0003v\u0005\u0012!qO\u0001\u0012gR\f'\u000f^5oORKW.Z:uC6\u0004\u0018\u0001G\"E\u0007~\u001bF+\u0011*U?RKU*R*U\u00036\u0003vlS#ZA\u0005\u00192\tR\"`\u000b:#uLV#S'&{ejX&F3V\u0011!qP\b\u0003\u0005\u0003\u000b#Aa!\u0002\u001b\u0015tG-\u001b8h-\u0016\u00148/[8o\u0003Q\u0019EiQ0F\u001d\u0012{f+\u0012*T\u0013>sulS#ZA\u0005)2\tR\"`\u000b:#u\fV%N\u000bN#\u0016)\u0014)`\u0017\u0016KVC\u0001BF\u001f\t\u0011i)\t\u0002\u0003\u0010\u0006yQM\u001c3j]\u001e$\u0016.\\3ti\u0006l\u0007/\u0001\fD\t\u000e{VI\u0014#`)&kUi\u0015+B\u001bB{6*R-!\u0003=\u0019EiQ0F\u001d\u0006\u0013E*\u0012#`\u0017\u0016KVC\u0001BL\u001f\t\u0011I*\t\u0002\u0003\u001c\u0006q!/Z1e\u0007\"\fgnZ3GK\u0016$\u0017\u0001E\"E\u0007~+e*\u0011\"M\u000b\u0012{6*R-!\u0003Y\u0019EiQ0F\u001d\u0006\u0013E*\u0012#`\u0017\u0016Kv\fT#H\u0003\u000eKVC\u0001BR\u001f\t\u0011)+\t\u0002\u0003(\u0006q!/Z1e\u0007\"\fgnZ3ECR\f\u0017aF\"E\u0007~+e*\u0011\"M\u000b\u0012{6*R-`\u0019\u0016;\u0015iQ-!\u0003e)gnY8eKB\u000b'\u000f^5uS>t\u0017N\\4D_2,XN\\:\u0015\t\u0005e!q\u0016\u0005\b\u0005c\u0013\u0003\u0019AAF\u0003\u001d\u0019w\u000e\\;n]N\f\u0011\u0004Z3d_\u0012,\u0007+\u0019:uSRLwN\\5oO\u000e{G.^7ogR!\u00111\u0012B\\\u0011\u001d\u0011Il\ta\u0001\u00033\t1a\u001d;s\u0003A)\u0007\u0010\u001e:bGR$U\r\u001c;b!\u0006$\b\u000e\u0006\u0003\u0003@\n\u0005\u0007#\u0002\u001d\u0002J\u0005e\u0001b\u0002BbI\u0001\u0007!QY\u0001\bI\u0006$\u0018m]3ua\u0011\u00119M!5\u0011\r\u0005}\"\u0011\u001aBg\u0013\r\u0011Y-\f\u0002\b\t\u0006$\u0018m]3u!\u0011\u0011yM!5\r\u0001\u0011a!1\u001bBa\u0003\u0003\u0005\tQ!\u0001\u0003V\n\u0019q\fJ\u0019\u0012\t\t]'Q\u001c\t\u0004q\te\u0017b\u0001Bns\t9aj\u001c;iS:<\u0007c\u0001\u001d\u0003`&\u0019!\u0011]\u001d\u0003\u0007\u0005s\u00170A\nqCJ\u001cX\rU1uQ&#WM\u001c;jM&,'\u000f\u0006\u0005\u0003h\u000e-11CB\f!%A$\u0011\u001eBw\u0005{\u001c\t!C\u0002\u0003lf\u0012a\u0001V;qY\u0016\u001c\u0004\u0003\u0002Bx\u0005sl!A!=\u000b\t\tM(Q_\u0001\u0003MNT1Aa>2\u0003\u0019A\u0017\rZ8pa&!!1 By\u0005\u0011\u0001\u0016\r\u001e5\u0011\r\u00055\u0015q\u0013B\u0000!\u001dA\u0014QGA\r\u00033\u0001R\u0001OA%\u0007\u0007\u0001Ba!\u0002\u0004\b5\t1&C\u0002\u0004\n-\u00121\u0003R3mi\u0006$\u0016.\\3Ue\u00064X\r\\*qK\u000eDa\u0001M\u0013A\u0002\r5\u0001\u0003BA \u0007\u001fI1a!\u0005.\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\u0019)\"\na\u0001\u00033\t\u0001\"^:feB\u000bG\u000f\u001b\u0005\u0007U\u0016\u0002\r!!\u0016\u0002?Y,'/\u001b4z\u0003:$7I]3bi\u0016\u0004\u0016M\u001d;ji&|gNR5mi\u0016\u00148\u000f\u0006\u0005\u0004\u001e\r52qFB\u001d!\u0019\ti)a&\u0004 A!1\u0011EB\u0015\u001b\t\u0019\u0019C\u0003\u0003\u0002\u0002\r\u0015\"bAB\u0014[\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0004,\r\r\"AC#yaJ,7o]5p]\"91Q\u0003\u0014A\u0002\u0005e\u0001bBB\u0019M\u0001\u000711G\u0001\tg:\f\u0007o\u001d5piB!1QAB\u001b\u0013\r\u00199d\u000b\u0002\t':\f\u0007o\u001d5pi\"911\b\u0014A\u0002\tu\u0018\u0001\u00059beRLG/[8o\r&dG/\u001a:t\u0003Q9W\r\u001e+j[\u0016$&/\u0019<fYZ+'o]5p]R!1\u0011AB!\u0011\u001d\t\u0019f\na\u0001\u0003+\u0002")
public class DeltaDataSource
implements RelationProvider,
StreamSourceProvider,
StreamSinkProvider,
CreatableRelationProvider,
DataSourceRegister,
TableProvider,
DeltaLogging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<DeltaTimeTravelSpec> getTimeTravelVersion(scala.collection.immutable.Map<String, String> map) {
        return DeltaDataSource$.MODULE$.getTimeTravelVersion(map);
    }

    public static Seq<Expression> verifyAndCreatePartitionFilters(String string, Snapshot snapshot, Seq<Tuple2<String, String>> seq) {
        return DeltaDataSource$.MODULE$.verifyAndCreatePartitionFilters(string, snapshot, seq);
    }

    public static Tuple3<Path, Seq<Tuple2<String, String>>, Option<DeltaTimeTravelSpec>> parsePathIdentifier(SparkSession sparkSession, String string, scala.collection.immutable.Map<String, String> map) {
        return DeltaDataSource$.MODULE$.parsePathIdentifier(sparkSession, string, map);
    }

    public static Option<String> extractDeltaPath(Dataset<?> dataset) {
        return DeltaDataSource$.MODULE$.extractDeltaPath(dataset);
    }

    public static Seq<String> decodePartitioningColumns(String string) {
        return DeltaDataSource$.MODULE$.decodePartitioningColumns(string);
    }

    public static String encodePartitioningColumns(Seq<String> seq) {
        return DeltaDataSource$.MODULE$.encodePartitioningColumns(seq);
    }

    public static String CDC_ENABLED_KEY_LEGACY() {
        return DeltaDataSource$.MODULE$.CDC_ENABLED_KEY_LEGACY();
    }

    public static String CDC_ENABLED_KEY() {
        return DeltaDataSource$.MODULE$.CDC_ENABLED_KEY();
    }

    public static String CDC_END_TIMESTAMP_KEY() {
        return DeltaDataSource$.MODULE$.CDC_END_TIMESTAMP_KEY();
    }

    public static String CDC_END_VERSION_KEY() {
        return DeltaDataSource$.MODULE$.CDC_END_VERSION_KEY();
    }

    public static String CDC_START_TIMESTAMP_KEY() {
        return DeltaDataSource$.MODULE$.CDC_START_TIMESTAMP_KEY();
    }

    public static String CDC_START_VERSION_KEY() {
        return DeltaDataSource$.MODULE$.CDC_START_VERSION_KEY();
    }

    public static String TIME_TRAVEL_VERSION_KEY() {
        return DeltaDataSource$.MODULE$.TIME_TRAVEL_VERSION_KEY();
    }

    public static String TIME_TRAVEL_TIMESTAMP_KEY() {
        return DeltaDataSource$.MODULE$.TIME_TRAVEL_TIMESTAMP_KEY();
    }

    public static String TIME_TRAVEL_SOURCE_KEY() {
        return DeltaDataSource$.MODULE$.TIME_TRAVEL_SOURCE_KEY();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public boolean supportsExternalMetadata() {
        return super.supportsExternalMetadata();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StructType inferSchema() {
        return new StructType();
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return this.inferSchema();
    }

    public Table getTable(StructType schema, Transform[] partitioning, java.util.Map<String, String> properties) {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap(properties);
        String path = options.get((Object)"path");
        if (path == null) {
            throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
        }
        return new DeltaTableV2(SparkSession$.MODULE$.active(), new Path(path), DeltaTableV2$.MODULE$.apply$default$3(), DeltaTableV2$.MODULE$.apply$default$4(), DeltaTableV2$.MODULE$.apply$default$5(), DeltaTableV2$.MODULE$.apply$default$6(), DeltaTableV2$.MODULE$.apply$default$7());
    }

    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, scala.collection.immutable.Map<String, String> parameters) {
        Snapshot snapshot;
        Option maybeTimeTravel;
        if (schema.nonEmpty() && ((TraversableOnce)schema.get()).nonEmpty()) {
            throw DeltaErrors$.MODULE$.specifySchemaAtReadTimeException();
        }
        String path = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
        });
        Tuple2<String, Option<DeltaTimeTravelSpec>> tuple2 = DeltaTableUtils$.MODULE$.extractIfPathContainsTimeTravel(sqlContext.sparkSession(), path, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = maybeTimeTravel = (Option)tuple2._2();
        Option maybeTimeTravel2 = option;
        if (maybeTimeTravel2.isDefined()) {
            throw DeltaErrors$.MODULE$.timeTravelNotSupportedException();
        }
        if (DeltaDataSource$.MODULE$.getTimeTravelVersion(parameters).isDefined()) {
            throw DeltaErrors$.MODULE$.timeTravelNotSupportedException();
        }
        Tuple2<DeltaLog, Snapshot> tuple22 = DeltaLog$.MODULE$.forTableWithSnapshot(sqlContext.sparkSession(), path);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        Snapshot snapshot2 = snapshot = (Snapshot)tuple22._2();
        Snapshot snapshot3 = snapshot2;
        StructType readSchema = snapshot3.schema();
        StructType schemaToUse = ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions(readSchema, ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions$default$2(), ColumnWithDefaultExprUtils$.MODULE$.removeDefaultExpressions$default$3());
        if (schemaToUse.isEmpty()) {
            throw DeltaErrors$.MODULE$.schemaNotSetException();
        }
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(parameters).asJava());
        return CDCReader$.MODULE$.isCDCRead(options) ? new Tuple2((Object)this.shortName(), (Object)CDCReader$.MODULE$.cdcReadSchema(schemaToUse)) : new Tuple2((Object)this.shortName(), (Object)schemaToUse);
    }

    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, scala.collection.immutable.Map<String, String> parameters) {
        if (schema.nonEmpty() && ((TraversableOnce)schema.get()).nonEmpty()) {
            throw DeltaErrors$.MODULE$.specifySchemaAtReadTimeException();
        }
        String path = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
        });
        DeltaOptions options = new DeltaOptions(parameters, sqlContext.sparkSession().sessionState().conf());
        Tuple2<DeltaLog, Snapshot> tuple2 = DeltaLog$.MODULE$.forTableWithSnapshot(sqlContext.sparkSession(), path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DeltaLog deltaLog = (DeltaLog)tuple2._1();
        Snapshot snapshot = (Snapshot)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deltaLog, (Object)snapshot);
        Tuple2 tuple23 = tuple22;
        DeltaLog deltaLog2 = (DeltaLog)tuple23._1();
        Snapshot snapshot2 = (Snapshot)tuple23._2();
        StructType readSchema = snapshot2.schema();
        if (readSchema.isEmpty()) {
            throw DeltaErrors$.MODULE$.schemaNotSetException();
        }
        return new DeltaSource(sqlContext.sparkSession(), deltaLog2, options, snapshot2, DeltaSource$.MODULE$.apply$default$5());
    }

    public Sink createSink(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        String path = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
        });
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        if (outputMode2 == null ? outputMode3 != null : !outputMode2.equals(outputMode3)) {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Complete();
            if (outputMode4 == null ? outputMode5 != null : !outputMode4.equals(outputMode5)) {
                throw DeltaErrors$.MODULE$.outputModeNotSupportedException(this.getClass().getName(), outputMode.toString());
            }
        }
        DeltaOptions deltaOptions = new DeltaOptions(parameters, sqlContext.sparkSession().sessionState().conf());
        return new DeltaSink(sqlContext, new Path(path), partitionColumns, outputMode, deltaOptions);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        String path = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
        });
        Seq partitionColumns = (Seq)parameters.get((Object)DeltaSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()).map((Function1 & Serializable & scala.Serializable)str -> DeltaDataSource$.MODULE$.decodePartitioningColumns((String)str)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        DeltaLog deltaLog = DeltaLog$.MODULE$.forTable(sqlContext.sparkSession(), path, parameters);
        new WriteIntoDelta(deltaLog, mode, new DeltaOptions(parameters, sqlContext.sparkSession().sessionState().conf()), (Seq<String>)partitionColumns, DeltaConfigs$.MODULE$.validateConfigurations((scala.collection.immutable.Map<String, String>)parameters.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("delta."))).toMap(Predef$.MODULE$.$conforms())), data, WriteIntoDelta$.MODULE$.apply$default$7()).run(sqlContext.sparkSession());
        return deltaLog.createRelation(deltaLog.createRelation$default$1(), deltaLog.createRelation$default$2(), deltaLog.createRelation$default$3(), deltaLog.createRelation$default$4());
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        return (BaseRelation)this.recordFrameProfile("Delta", "DeltaDataSource.createRelation", (Function0 & Serializable & scala.Serializable)() -> {
            String maybePath = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> {
                throw DeltaErrors$.MODULE$.pathNotSpecifiedException();
            });
            DeltaOptions$.MODULE$.verifyOptions((CaseInsensitiveMap<String>)CaseInsensitiveMap$.MODULE$.apply(parameters));
            Option<DeltaTimeTravelSpec> timeTravelByParams = DeltaDataSource$.MODULE$.getTimeTravelVersion(parameters);
            scala.collection.mutable.Map cdcOptions = Map$.MODULE$.empty();
            CaseInsensitiveStringMap caseInsensitiveParams = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)parameters).asJava());
            if (CDCReader$.MODULE$.isCDCRead(caseInsensitiveParams)) {
                cdcOptions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readChangeFeed"), (Object)"true")}));
                if (caseInsensitiveParams.containsKey((Object)"startingVersion")) {
                    cdcOptions.update((Object)"startingVersion", (Object)caseInsensitiveParams.get((Object)"startingVersion"));
                }
                if (caseInsensitiveParams.containsKey((Object)"startingTimestamp")) {
                    cdcOptions.update((Object)"startingTimestamp", (Object)caseInsensitiveParams.get((Object)"startingTimestamp"));
                }
                if (caseInsensitiveParams.containsKey((Object)"endingVersion")) {
                    cdcOptions.update((Object)"endingVersion", (Object)caseInsensitiveParams.get((Object)"endingVersion"));
                }
                if (caseInsensitiveParams.containsKey((Object)"endingTimestamp")) {
                    cdcOptions.update((Object)"endingTimestamp", (Object)caseInsensitiveParams.get((Object)"endingTimestamp"));
                }
            }
            scala.collection.immutable.Map dfOptions = BoxesRunTime.unboxToBoolean((Object)sqlContext.sparkSession().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOAD_FILE_SYSTEM_CONFIGS_FROM_DATAFRAME_OPTIONS())) ? parameters : Predef$.MODULE$.Map().empty();
            SparkSession x$1 = sqlContext.sparkSession();
            Path x$2 = new Path(maybePath);
            Option<DeltaTimeTravelSpec> x$3 = timeTravelByParams;
            scala.collection.immutable.Map x$4 = dfOptions;
            CaseInsensitiveStringMap x$5 = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(cdcOptions).asJava());
            Option<CatalogTable> x$6 = DeltaTableV2$.MODULE$.apply$default$3();
            Option<String> x$7 = DeltaTableV2$.MODULE$.apply$default$4();
            return new DeltaTableV2(x$1, x$2, x$6, x$7, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5).toBaseRelation();
        });
    }

    public String shortName() {
        return DeltaSourceUtils$.MODULE$.ALT_NAME();
    }

    public DeltaDataSource() {
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

