/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaParquetFileFormat;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeletionVectorBitmapGenerator$;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.TouchedFileWithDV;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class DeleteWithDeletionVectorsHelper$
implements DeltaCommand {
    public static DeleteWithDeletionVectorsHelper$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeleteWithDeletionVectorsHelper$();
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> createTargetDfForScanningForMatches(SparkSession spark, LogicalPlan target, TahoeFileIndex fileIndex) {
        return Dataset$.MODULE$.ofRows(spark, this.replaceFileIndex(target, fileIndex));
    }

    private LogicalPlan replaceFileIndex(LogicalPlan target, TahoeFileIndex fileIndex) {
        String x$1 = DeltaParquetFileFormat$.MODULE$.ROW_INDEX_COLUMN_NAME();
        DataType x$2 = DeltaParquetFileFormat$.MODULE$.ROW_INDEX_STRUCT_FILED().dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference rowIndexColumn = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        LogicalPlan newTarget = (LogicalPlan)target.transformDown((PartialFunction)new scala.Serializable(rowIndexColumn, fileIndex){
            public static final long serialVersionUID = 0L;
            private final AttributeReference rowIndexColumn$1;
            private final TahoeFileIndex fileIndex$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                HadoopFsRelation hadoopFsRelation;
                FileFormat format;
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation && (format = (hadoopFsRelation = (HadoopFsRelation)hfsr).fileFormat()) instanceof DeltaParquetFileFormat) {
                    DeltaParquetFileFormat deltaParquetFileFormat = (DeltaParquetFileFormat)format;
                    StructType newDataSchema = StructType$.MODULE$.apply((Seq)hadoopFsRelation.dataSchema()).add(DeltaParquetFileFormat$.MODULE$.ROW_INDEX_STRUCT_FILED());
                    Seq finalOutput = (Seq)logicalRelation.output().$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.rowIndexColumn$1, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
                    boolean x$1 = false;
                    boolean x$2 = true;
                    org.apache.spark.sql.delta.actions.Metadata x$3 = deltaParquetFileFormat.copy$default$1();
                    Option<String> x$4 = deltaParquetFileFormat.copy$default$4();
                    Option<Broadcast<Map<URI, DeletionVectorDescriptor>>> x$5 = deltaParquetFileFormat.copy$default$5();
                    Option<Broadcast<SerializableConfiguration>> x$6 = deltaParquetFileFormat.copy$default$6();
                    DeltaParquetFileFormat newFormat = deltaParquetFileFormat.copy(x$3, x$1, x$2, x$4, x$5, x$6);
                    TahoeFileIndex x$7 = this.fileIndex$1;
                    StructType x$8 = newDataSchema;
                    DeltaParquetFileFormat x$9 = newFormat;
                    StructType x$10 = hadoopFsRelation.copy$default$2();
                    Option x$11 = hadoopFsRelation.copy$default$4();
                    Map x$12 = hadoopFsRelation.copy$default$6();
                    SparkSession x$13 = hadoopFsRelation.sparkSession();
                    HadoopFsRelation newBaseRelation = hadoopFsRelation.copy((FileIndex)x$7, x$10, x$8, x$11, (FileFormat)x$9, x$12, x$13);
                    object = logicalRelation.copy((BaseRelation)newBaseRelation, finalOutput, logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                } else if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    Seq projectList = project.projectList();
                    Seq newProjectList = (Seq)projectList.$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.rowIndexColumn$1, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
                    object = project.copy(newProjectList, project.copy$default$2());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HadoopFsRelation hadoopFsRelation;
                FileFormat format;
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation && (format = (hadoopFsRelation = (HadoopFsRelation)hfsr).fileFormat()) instanceof DeltaParquetFileFormat ? true : logicalPlan instanceof Project;
                return bl;
            }
            {
                this.rowIndexColumn$1 = rowIndexColumn$1;
                this.fileIndex$1 = fileIndex$1;
            }
        });
        return newTarget;
    }

    public Seq<TouchedFileWithDV> findTouchedFiles(SparkSession sparkSession, OptimisticTransaction txn, boolean hasDVsEnabled, DeltaLog deltaLog, Dataset<Row> targetDf, TahoeFileIndex fileIndex, Expression condition) {
        return (Seq)this.recordDeltaOperation(deltaLog, "DELETE.findTouchedFiles", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            TahoeFileIndex tahoeFileIndex = fileIndex;
            if (!(tahoeFileIndex instanceof TahoeBatchFileIndex)) {
                throw new IllegalArgumentException("Unexpected file index found!");
            }
            TahoeBatchFileIndex tahoeBatchFileIndex = (TahoeBatchFileIndex)tahoeFileIndex;
            Seq<AddFile> seq = tahoeBatchFileIndex.addFiles();
            Seq<AddFile> candidateFiles = seq;
            Seq<DeletionVectorResult> matchedRowIndexSets = DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition(sparkSession, txn, hasDVsEnabled, targetDf, candidateFiles, condition);
            Map<String, AddFile> nameToAddFileMap = MODULE$.generateCandidateFileMap(txn.deltaLog().dataPath(), candidateFiles);
            return MODULE$.findFilesWithMatchingRows(txn, nameToAddFileMap, matchedRowIndexSets);
        });
    }

    private Seq<TouchedFileWithDV> findFilesWithMatchingRows(OptimisticTransaction txn, Map<String, AddFile> nameToAddFileMap, Seq<DeletionVectorResult> matchedFileRowIndexSets) {
        Path dataPath = txn.deltaLog().dataPath();
        Seq touchedFilesWithMatchedRowIndices = (Seq)matchedFileRowIndexSets.map((Function1 & Serializable & scala.Serializable)fileRowIndex -> {
            String filePath = fileRowIndex.filePath();
            AddFile addFile = MODULE$.getTouchedFile(dataPath, filePath, nameToAddFileMap);
            return new TouchedFileWithDV(filePath, addFile, fileRowIndex.deletionVector(), fileRowIndex.matchedRowCount());
        }, Seq$.MODULE$.canBuildFrom());
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("findTouchedFiles: matched files:\n\t").append(((TraversableOnce)touchedFilesWithMatchedRowIndices.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.inputFilePath(), Seq$.MODULE$.canBuildFrom())).mkString("\n\t")).toString());
        return (Seq)touchedFilesWithMatchedRowIndices.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isUnchanged()));
    }

    public Seq<FileAction> processUnmodifiedData(Seq<TouchedFileWithDV> touchedFiles) {
        Tuple2 tuple2 = touchedFiles.partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isFullyReplaced()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq fullyRemovedFiles = (Seq)tuple2._1();
        Seq notFullyRemovedFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fullyRemovedFiles, (Object)notFullyRemovedFiles);
        Tuple2 tuple23 = tuple22;
        Seq fullyRemovedFiles2 = (Seq)tuple23._1();
        Seq notFullyRemovedFiles2 = (Seq)tuple23._2();
        long timestamp = System.currentTimeMillis();
        Seq fullyRemoved = (Seq)fullyRemovedFiles2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.fileLogEntry().removeWithTimestamp(timestamp, x$5.fileLogEntry().removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
        Seq dvUpdates = (Seq)notFullyRemovedFiles2.map((Function1 & Serializable & scala.Serializable)fileWithDVInfo -> fileWithDVInfo.fileLogEntry().removeRows(fileWithDVInfo.newDeletionVector(), fileWithDVInfo.fileLogEntry().removeRows$default$2()), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple24 = dvUpdates.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq filesWithDeletedRows = (Seq)tuple24._1();
        Seq newFilesWithDVs = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)filesWithDeletedRows, (Object)newFilesWithDVs);
        Tuple2 tuple26 = tuple25;
        Seq filesWithDeletedRows2 = (Seq)tuple26._1();
        Seq newFilesWithDVs2 = (Seq)tuple26._2();
        return (Seq)((TraversableLike)fullyRemoved.$plus$plus((GenTraversableOnce)filesWithDeletedRows2, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)newFilesWithDVs2, Seq$.MODULE$.canBuildFrom());
    }

    private DeleteWithDeletionVectorsHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
    }
}

