/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.util.HashFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HashFunctionTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testChecksum() throws IOException {
        String mainDir = this.temporaryFolder.getRoot() + "/testChecksum";
        File checkSumFile = new File(mainDir, "a.txt");
        FileUtils.writeStringToFile((File)checkSumFile, (String)"1111");
        byte[] md5 = HashFunction.MD5.checksum(checkSumFile);
        byte[] sha1 = HashFunction.SHA1.checksum(checkSumFile);
        byte[] sha256 = HashFunction.SHA256.checksum(checkSumFile);
        byte[] sha512 = HashFunction.SHA512.checksum(checkSumFile);
        Assert.assertEquals((Object)"B59C67BF196A4758191E42F76670CEBA", (Object)DatatypeConverter.printHexBinary((byte[])md5));
        Assert.assertEquals((Object)"011C945F30CE2CBAFC452F39840F025693339C42", (Object)DatatypeConverter.printHexBinary((byte[])sha1));
        Assert.assertEquals((Object)"0FFE1ABD1A08215353C233D6E009613E95EEC4253832A761AF28FF37AC5A150C", (Object)DatatypeConverter.printHexBinary((byte[])sha256));
        Assert.assertEquals((Object)"33275A8AA48EA918BD53A9181AA975F15AB0D0645398F5918A006D08675C1CB27D5C645DBD084EEE56E675E25BA4019F2ECEA37CA9E2995B49FCB12C096A032E", (Object)DatatypeConverter.printHexBinary((byte[])sha512));
    }
}

