/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.loader.AddToClassPathAction;
import org.apache.kylin.loader.ParserClassLoader;
import org.apache.kylin.loader.utils.ClassLoaderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddToClassPathActionTest
extends NLocalFileMetadataTestCase {
    private static final String JAR_NAME = "custom_parser.jar";

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void teardown() {
        this.cleanupTestMetadata();
    }

    @Test
    public void testRun() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Path metaPath = new Path(kylinConfig.getMetadataUrl().toString());
        Path jarPath = new Path(String.format("%s/%s/%s", metaPath.getParent().toString(), "jars", JAR_NAME));
        String jarAbsPath = new File(jarPath.toString()).toURI().toString();
        HashSet newPaths = Sets.newHashSet((Object[])new String[]{jarAbsPath});
        AddToClassPathAction action1 = new AddToClassPathAction(Thread.currentThread().getContextClassLoader(), (Collection)newPaths);
        ParserClassLoader parserClassLoader1 = action1.run();
        Assert.assertNotNull((Object)parserClassLoader1);
        AddToClassPathAction action2 = new AddToClassPathAction((ClassLoader)parserClassLoader1, (Collection)newPaths);
        ParserClassLoader parserClassLoader2 = action2.run();
        Assert.assertNotNull((Object)parserClassLoader2);
        ParserClassLoader parserClassLoader3 = new ParserClassLoader((URL[])newPaths.stream().map(ClassLoaderUtils::urlFromPathString).toArray(URL[]::new));
        try {
            parserClassLoader3.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ParserClassLoader parserClassLoader4 = new ParserClassLoader((URL[])newPaths.stream().map(ClassLoaderUtils::urlFromPathString).toArray(URL[]::new));
        try {
            parserClassLoader4.close();
            parserClassLoader4.addURL(ClassLoaderUtils.urlFromPathString((String)jarAbsPath));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> new AddToClassPathAction(null, (Collection)newPaths));
    }
}

