/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class OverwritePropExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{OverwritePropExtension.class});
    private static final String OVERWRITE_PROP_BEFORE_ALL_KEY = "OverwriteProp_all";
    private static final String OVERWRITE_PROP_BEFORE_EACH_KEY = "OverwriteProp_each";
    private static final String OVERWRITTEN_PROP_KEY = "OverwrittenProp";

    public void beforeAll(ExtensionContext context) throws Exception {
        this.readFromAnnotation(context, OVERWRITE_PROP_BEFORE_ALL_KEY);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.readFromAnnotation(context, OVERWRITE_PROP_BEFORE_EACH_KEY);
        Map overwritten = (Map)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)OVERWRITTEN_PROP_KEY, __ -> Maps.newHashMap(), Map.class);
        Map props = (Map)context.getStore(NAMESPACE).getOrDefault((Object)OVERWRITE_PROP_BEFORE_ALL_KEY, Map.class, (Object)Maps.newHashMap());
        props.forEach((k, v) -> Unsafe.overwriteSystemProp((Map)overwritten, (String)k, (String)v));
        props = (Map)context.getStore(NAMESPACE).getOrDefault((Object)OVERWRITE_PROP_BEFORE_EACH_KEY, Map.class, (Object)Maps.newHashMap());
        props.forEach((k, v) -> Unsafe.overwriteSystemProp((Map)overwritten, (String)k, (String)v));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Map overwritten = (Map)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)OVERWRITTEN_PROP_KEY, __ -> Maps.newHashMap(), Map.class);
        HashSet keys = Sets.newHashSet(overwritten.keySet());
        for (String property : keys) {
            if (!overwritten.containsKey(property) || overwritten.get(property) == null) {
                SystemPropertiesCache.clearProperty((String)property);
                continue;
            }
            SystemPropertiesCache.setProperty((String)property, (String)((String)overwritten.get(property)));
        }
        context.getStore(NAMESPACE).remove((Object)OVERWRITE_PROP_BEFORE_EACH_KEY);
        context.getStore(NAMESPACE).remove((Object)OVERWRITTEN_PROP_KEY);
    }

    private void readFromAnnotation(ExtensionContext context, String key) {
        AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), OverwriteProp.class).forEach(x -> ((Map)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)key, __ -> Maps.newHashMap(), Map.class)).put(x.key(), x.value()));
    }

    public final void restoreSystemProp(Map<String, String> overwritten, String property) {
        if (!overwritten.containsKey(property) || overwritten.get(property) == null) {
            SystemPropertiesCache.clearProperty((String)property);
        } else {
            SystemPropertiesCache.setProperty((String)property, (String)overwritten.get(property));
        }
        overwritten.remove(property);
    }
}

