/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.JdbcInfo;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcMetadataExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext context) throws Exception {
        TestUtils.getTestConfig().setMetadataUrl(this.getTableName(context) + "@jdbc,driverClassName=org.h2.Driver,url=jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1;MODE=MySQL,username=sa,password=");
    }

    public void afterEach(ExtensionContext context) throws Exception {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        jdbcTemplate.batchUpdate(new String[]{"SHUTDOWN;"});
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == JdbcInfo.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        JdbcInfo result = new JdbcInfo();
        result.setJdbcTemplate(this.getJdbcTemplate());
        result.setTableName(this.getTableName(extensionContext));
        return result;
    }

    private String getTableName(ExtensionContext context) {
        return "test_" + context.getTestMethod().map(Method::getName).orElse("") + "_" + context.getDisplayName().replaceAll("[|]|\\W", "_");
    }

    private JdbcTemplate getJdbcTemplate() throws Exception {
        StorageURL url = TestUtils.getTestConfig().getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        return new JdbcTemplate((DataSource)dataSource);
    }
}

