/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.Option;
import org.apache.kylin.common.util.OptionBuilder;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class OptionBuilderTest {
    @Test
    public void testBasic() {
        String argName = "dir";
        String opt = "destDir";
        String desc = "specify the dest dir to save the related information";
        String longOpt = "dest_dir";
        char sep = ',';
        Option option = OptionBuilder.getInstance().withArgName(argName).hasArg().isRequired(true).withDescription(desc).withLongOpt(longOpt).withType(OptionBuilder.class).withValueSeparator(sep).create(opt);
        Assert.assertTrue((boolean)option.isRequired());
        Assert.assertTrue((boolean)option.hasArg());
        Assert.assertEquals((Object)opt, (Object)option.getOpt());
        Assert.assertEquals((Object)argName, (Object)option.getArgName());
        Assert.assertEquals((Object)desc, (Object)option.getDescription());
        Assert.assertEquals((long)sep, (long)option.getValueSeparator());
        Assert.assertEquals((Object)longOpt, (Object)option.getLongOpt());
        Assert.assertEquals(OptionBuilder.class, (Object)option.getType());
        Option optionFalse = OptionBuilder.getInstance().withArgName(argName).hasArg().isRequired(false).withDescription(desc).withLongOpt(longOpt).withType(OptionBuilder.class).withValueSeparator(sep).create(opt);
        Assert.assertFalse((boolean)optionFalse.isRequired());
    }

    @Test
    public void testConcurrent() {
        Thread t1 = new Thread(() -> {
            while (true) {
                org.apache.commons.cli.OptionBuilder.isRequired((boolean)false);
                org.apache.commons.cli.OptionBuilder.create((String)"falseOpt");
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    System.out.println("t1 interrupt");
                    continue;
                }
                break;
            }
        });
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> {
            Option option;
            t1.start();
            do {
                org.apache.commons.cli.OptionBuilder.isRequired((boolean)true);
            } while ((option = org.apache.commons.cli.OptionBuilder.create((String)"trueOpt")).isRequired());
            t1.interrupt();
        });
        Thread t2 = new Thread(() -> {
            while (true) {
                OptionBuilder.getInstance().isRequired(false).create("falseOpt");
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    System.out.println("t2 interrupt");
                    continue;
                }
                break;
            }
        });
        t2.start();
        for (int i = 0; i < 10000; ++i) {
            Option option = OptionBuilder.getInstance().isRequired(true).create("trueOpt");
            Assert.assertTrue((boolean)option.isRequired());
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                System.out.println("t2 interrupt");
            }
        }
        t2.interrupt();
    }
}

