/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.LogOutputTestCase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtilTest
extends LogOutputTestCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceUtilTest.class);

    @Test
    @Ignore
    public void testShutdownGracefully() throws Exception {
        ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
        pool.execute(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.error("thread interrupted.");
            }
        });
        Thread.sleep(2000L);
        ExecutorServiceUtil.shutdownGracefully((ExecutorService)pool, (int)1);
        Assert.assertTrue((boolean)this.containsLog("thread interrupted."));
    }

    @Test
    public void testForceShutdown() {
        ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = pool.schedule(() -> log.info("thread execute"), 10L, TimeUnit.SECONDS);
        ExecutorServiceUtil.forceShutdown((ExecutorService)pool);
        try {
            task.get(60L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof CancellationException));
        }
        Assert.assertFalse((boolean)this.containsLog("thread execute"));
    }
}

