/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.MetadataMapperFactory;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.metadata.mapper.BasicMapper;
import org.apache.kylin.common.persistence.metadata.mapper.BasicSqlTable;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.select.SelectDSLCompleter;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils;
import org.mybatis.spring.SqlSessionTemplate;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
class MetadataMapperFactoryTest {
    KylinConfig config;
    DataSource dataSource;
    SqlSessionTemplate sqlSessionTemplate;

    MetadataMapperFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.config = KylinConfig.getInstanceFromEnv();
        this.dataSource = JdbcDataSource.getDataSource((Properties)JdbcUtil.datasourceParameters((StorageURL)this.config.getMetadataUrl()));
        SqlSessionFactory sqlSessionFactory = MetadataMapperFactory.getSqlSessionFactory((DataSource)this.dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
    }

    @Test
    void testConditionConverter() {
        BasicMapper mapper = MetadataMapperFactory.createFor((MetadataType)MetadataType.PROJECT, (SqlSession)this.sqlSessionTemplate);
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("uuid", Arrays.asList("uuid_p1", "uuid_p2"), RawResourceFilter.Operator.IN);
        filter.addConditions("mvcc", Collections.singletonList(4L), RawResourceFilter.Operator.LT);
        filter.addConditions("mvcc", Collections.singletonList(0L), RawResourceFilter.Operator.LE);
        filter.addConditions("ts", Collections.singletonList(100L), RawResourceFilter.Operator.GT);
        filter.addConditions("ts", Collections.singletonList(100L), RawResourceFilter.Operator.GE);
        filter.addConditions("name", Collections.singletonList("p1"), RawResourceFilter.Operator.EQUAL);
        filter.addConditions("metaKey", Collections.singletonList("p1"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
        filter.addConditions("metaKey", Collections.singletonList("p"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
        SelectDSLCompleter dsl = MetadataMapperFactory.convertConditionsToDSLCompleter((RawResourceFilter)filter, (Map)mapper.getSelectColumnMap());
        SelectStatementProvider provider = MyBatis3Utils.select((BasicColumn[])mapper.getSelectList(), (SqlTable)mapper.getSqlTable(), (SelectDSLCompleter)dsl);
        Assertions.assertEquals((int)9, (int)provider.getParameters().size());
    }

    @Test
    void testInvalidCondition() {
        BasicMapper mapper = MetadataMapperFactory.createFor((MetadataType)MetadataType.PROJECT, (SqlSession)this.sqlSessionTemplate);
        RawResourceFilter filter = RawResourceFilter.equalFilter((String)"undefinedKey", (String)"p1");
        SelectDSLCompleter dsl = MetadataMapperFactory.convertConditionsToDSLCompleter((RawResourceFilter)filter, (Map)mapper.getSelectColumnMap());
        BasicColumn[] cols = mapper.getSelectList();
        BasicSqlTable table = mapper.getSqlTable();
        Assertions.assertThrows(IllegalArgumentException.class, () -> MyBatis3Utils.select((BasicColumn[])cols, (SqlTable)table, (SelectDSLCompleter)dsl));
    }
}

