/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.health;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnEnabledHealthIndicator(value="metaStore")
public class MetaStoreHealthIndicator
implements HealthIndicator,
ApplicationListener<AfterMetadataReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MetaStoreHealthIndicator.class);
    private static final String UNIT_NAME = "_health";
    private static final int MAX_RETRY = 3;
    private static final ScheduledExecutorService META_STORE_HEALTH_EXECUTOR = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("MetaStoreHealthChecker"));
    private volatile boolean isHealth = false;
    private final int warningResponseMs;
    private final int errorResponseMs;

    public MetaStoreHealthIndicator() {
        KapConfig wrappedConfig = KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv());
        this.warningResponseMs = wrappedConfig.getMetaStoreHealthWarningResponseMs();
        this.errorResponseMs = wrappedConfig.getMetaStoreHealthErrorResponseMs();
    }

    private void checkTime(long start, String operation) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long response = System.currentTimeMillis() - start;
        logger.trace("{} took {} ms", (Object)operation, (Object)response);
        if (response > (long)this.errorResponseMs) {
            throw new IllegalStateException("check time is time out");
        }
        if (response > (long)this.warningResponseMs) {
            logger.warn("found warning, {} took {} ms", (Object)operation, (Object)response);
        }
    }

    public void onApplicationEvent(AfterMetadataReadyEvent event) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        META_STORE_HEALTH_EXECUTOR.scheduleWithFixedDelay(() -> this.healthCheck(), 0L, config.getMetadataCheckDuration(), TimeUnit.MILLISECONDS);
    }

    public void healthCheck() {
        Health ret;
        try {
            ret = KylinConfig.getInstanceFromEnv().isJobNode() ? this.allNodeCheck() : this.queryNodeCheck();
        }
        catch (Exception e) {
            logger.error("Failed to check the metastore health", (Throwable)e);
            this.isHealth = false;
            return;
        }
        if (Objects.isNull(ret)) {
            this.isHealth = false;
            return;
        }
        this.isHealth = true;
    }

    @VisibleForTesting
    public Health allNodeCheck() {
        return (Health)UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().skipAuditLog(true).unitName(UNIT_NAME).tempLockName(UNIT_NAME).maxRetry(3).processor(() -> {
            ResourceStore store;
            try {
                store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get meta store", e);
            }
            String uuid = RandomUtil.randomUUIDStr();
            String resourcePath = MetadataType.mergeKeyWithType((String)uuid, (MetadataType)MetadataType.SYSTEM);
            UnitOfWork.get().getCopyForWriteItems().add(resourcePath);
            String op = "Writing metadata (40 bytes)";
            logger.trace(op);
            long start = System.currentTimeMillis();
            try {
                store.checkAndPutResource(resourcePath, (RootPersistentEntity)new StringEntity("health_check", uuid), StringEntity.serializer);
                this.checkTime(start, op);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write metadata", e);
            }
            op = "Reading metadata (40 bytes)";
            logger.trace(op);
            start = System.currentTimeMillis();
            try {
                StringEntity value = (StringEntity)store.getResource(resourcePath, StringEntity.serializer);
                this.checkTime(start, op);
                if (!new StringEntity(uuid).equals((Object)value)) {
                    throw new RuntimeException("Metadata store failed to read a newly created resource.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read metadata", e);
            }
            op = "Deleting metadata (40 bytes)";
            logger.trace(op);
            start = System.currentTimeMillis();
            try {
                store.deleteResource(resourcePath);
                this.checkTime(start, op);
            }
            catch (Exception e) {
                logger.error("Failed to delete metadata", (Throwable)e);
                throw new RuntimeException("Failed to delete metadata", e);
            }
            return Health.up().build();
        }).build());
    }

    private Health queryNodeCheck() {
        return (Health)UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().skipAuditLog(true).readonly(true).unitName(UNIT_NAME).maxRetry(3).processor(() -> {
            ResourceStore store;
            try {
                store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get meta store", e);
            }
            String op = "Reading metadata /UUID";
            logger.trace(op);
            long start = System.currentTimeMillis();
            try {
                StringEntity value = (StringEntity)store.getResource(ResourceStore.METASTORE_UUID_TAG, StringEntity.serializer);
                this.checkTime(start, op);
                if (Objects.isNull(value)) {
                    throw new RuntimeException("Metadata store failed to read a resource.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read metadata", e);
            }
            return Health.up().build();
        }).build());
    }

    public Health health() {
        return this.isHealth ? Health.up().build() : Health.down().build();
    }
}

