/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.discovery;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.discovery.ConditionalOnNodeRegistryZookeeperEnabled;
import org.apache.kylin.rest.discovery.KylinServiceDiscovery;
import org.apache.kylin.rest.discovery.KylinServiceDiscoveryCache;
import org.apache.kylin.rest.discovery.KylinServiceDiscoveryClient;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ConditionalOnZookeeperEnabled
@ConditionalOnNodeRegistryZookeeperEnabled
@Component
public class KylinServiceDiscoveryCache
implements KylinServiceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(KylinServiceDiscoveryCache.class);
    private final Map<ClusterConstant.ServerModeEnum, ServiceCache<ZookeeperInstance>> serverModeCacheMap;
    private final List<ClusterConstant.ServerModeEnum> ALL_CHECK_MODE_LIST = ImmutableList.of((Object)ClusterConstant.ServerModeEnum.ALL, (Object)ClusterConstant.ServerModeEnum.JOB, (Object)ClusterConstant.ServerModeEnum.QUERY);
    @Autowired
    private KylinServiceDiscoveryClient kylinServiceDiscoveryClient;
    @Autowired
    private ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    @Autowired
    private CuratorFramework curatorClient;

    public KylinServiceDiscoveryCache() {
        this.serverModeCacheMap = Maps.newHashMap();
    }

    private static String instance2ServerStr(@Nonnull ServiceInstance<ZookeeperInstance> serviceInstance) {
        Preconditions.checkNotNull(serviceInstance, (Object)"service instance is null");
        return serviceInstance.getAddress() + ":" + serviceInstance.getPort();
    }

    @PostConstruct
    private void init() throws Exception {
        this.registerServiceCache();
        this.startServiceCache();
    }

    @PreDestroy
    private void close() {
        for (ServiceCache serviceCache : this.serverModeCacheMap.values()) {
            IOUtils.closeQuietly((Closeable)serviceCache);
        }
        this.serverModeCacheMap.clear();
    }

    private void registerServiceCache() throws Exception {
        for (ClusterConstant.ServerModeEnum serverModeEnum : this.ALL_CHECK_MODE_LIST) {
            this.registerServiceCacheByMode(serverModeEnum);
        }
    }

    private void registerServiceCacheByMode(ClusterConstant.ServerModeEnum modeEnum) throws Exception {
        switch (2.$SwitchMap$org$apache$kylin$common$util$ClusterConstant$ServerModeEnum[modeEnum.ordinal()]) {
            case 1: {
                this.serverModeCacheMap.put(ClusterConstant.ServerModeEnum.QUERY, this.createServiceCache(this.serviceDiscovery, ClusterConstant.ServerModeEnum.QUERY, () -> {}));
                break;
            }
            case 2: {
                this.serverModeCacheMap.put(ClusterConstant.ServerModeEnum.JOB, this.createServiceCache(this.serviceDiscovery, ClusterConstant.ServerModeEnum.JOB, () -> {}));
                break;
            }
            case 3: {
                this.serverModeCacheMap.put(ClusterConstant.ServerModeEnum.ALL, this.createServiceCache(this.serviceDiscovery, ClusterConstant.ServerModeEnum.ALL, () -> {}));
                break;
            }
        }
    }

    private void startServiceCache() throws Exception {
        for (ServiceCache serviceCache : this.serverModeCacheMap.values()) {
            serviceCache.start();
        }
    }

    private ServiceCache<ZookeeperInstance> createServiceCache(ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ClusterConstant.ServerModeEnum serverMode, KylinServiceDiscovery.Callback action) throws Exception {
        this.createZkNodeIfNeeded(this.getZkPathByModeEnum(serverMode));
        ServiceCache serviceCache = serviceDiscovery.serviceCacheBuilder().name(serverMode.getName()).threadFactory(Executors.defaultThreadFactory()).build();
        serviceCache.addListener((Object)this.getListener(serverMode, action));
        return serviceCache;
    }

    private ServiceCacheListener getListener(ClusterConstant.ServerModeEnum serverMode, KylinServiceDiscovery.Callback action) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ServiceCache<ZookeeperInstance> getServiceCacheByMode(@Nonnull ClusterConstant.ServerModeEnum serverModeEnum) {
        Preconditions.checkNotNull((Object)serverModeEnum, (Object)"server mode is null");
        ServiceCache serviceCache = (ServiceCache)this.serverModeCacheMap.get(serverModeEnum);
        Preconditions.checkNotNull((Object)serviceCache, (Object)("cannot find the server cache :" + serverModeEnum.getName()));
        return serviceCache;
    }

    private List<String> getServerStrByServerMode(@Nonnull ClusterConstant.ServerModeEnum serverModeEnum) {
        Preconditions.checkNotNull((Object)serverModeEnum, (Object)"server mode is null!");
        return this.getServiceCacheByMode(serverModeEnum).getInstances().stream().map(KylinServiceDiscoveryCache::instance2ServerStr).collect(Collectors.toList());
    }

    public List<ServerInfoResponse> getServerInfoByServerMode(ClusterConstant.ServerModeEnum ... serverModeEnums) {
        ArrayList serverInfoResponses = Lists.newArrayList();
        if (ArrayUtils.isEmpty((Object[])serverModeEnums)) {
            return serverInfoResponses;
        }
        for (ClusterConstant.ServerModeEnum serverModeEnum : serverModeEnums) {
            serverInfoResponses.addAll(this.getServiceCacheByMode(serverModeEnum).getInstances().stream().map(serviceIns -> new ServerInfoResponse(KylinServiceDiscoveryCache.instance2ServerStr((ServiceInstance)serviceIns), serverModeEnum.getName())).collect(Collectors.toList()));
        }
        return serverInfoResponses;
    }

    private void createZkNodeIfNeeded(String nodePath) throws Exception {
        try {
            if (this.curatorClient.checkExists().forPath(nodePath) != null) {
                logger.warn("The znode {} is existed", (Object)nodePath);
                return;
            }
            ((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(nodePath);
            logger.info("create znode {} success", (Object)nodePath);
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("The znode {} has been created by others", (Object)nodePath);
        }
        catch (Exception e) {
            logger.error("Fail to check or create znode for {}", (Object)nodePath, (Object)e);
            throw e;
        }
    }

    static /* synthetic */ List access$000(KylinServiceDiscoveryCache x0, ClusterConstant.ServerModeEnum x1) {
        return x0.getServerStrByServerMode(x1);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ KylinServiceDiscoveryClient access$200(KylinServiceDiscoveryCache x0) {
        return x0.kylinServiceDiscoveryClient;
    }
}

