/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.response.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseFilter.class);
    protected static final String API_PREFIX = "/kylin/api";
    protected static final String ROUTED = "routed";
    protected static final String TRUE = "true";
    protected static final String ERROR = "error";
    protected static final String API_ERROR = "/api/error";
    protected static final String FILTER_PASS = "filter_pass";
    protected static final String ERROR_REQUEST_URL = "/kylin/api/error";

    protected KylinException getKylinException(String project, Message msg) {
        ResourceGroupManager manager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        KylinException exception = manager.isResourceGroupEnabled() && !manager.isProjectBindToResourceGroup(project) ? new KylinException((ErrorCodeSupplier)ServerErrorCode.PROJECT_WITHOUT_RESOURCE_GROUP, msg.getProjectWithoutResourceGroup()) : new KylinException((ErrorCodeSupplier)ServerErrorCode.SYSTEM_IS_RECOVER, msg.getLeadersHandleOver());
        return exception;
    }

    protected void setResponseHeaders(HttpHeaders responseHeaders, HttpServletResponse servletResponse) {
        responseHeaders.forEach((k, v) -> {
            if (k.equals("Transfer-Encoding")) {
                return;
            }
            for (String headerValue : v) {
                servletResponse.setHeader(k, headerValue);
            }
        });
    }

    protected void routeAPI(RestTemplate restTemplate, ServletRequest servletRequest, ServletResponse servletResponse, String project) throws ServletException, IOException {
        int responseStatus;
        byte[] responseBody;
        HttpHeaders responseHeaders;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ServletRequestAttributes attributes = new ServletRequestAttributes(httpServletRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        byte[] body = IOUtils.toByteArray((InputStream)servletRequest.getInputStream());
        HttpHeaders headers = new HttpHeaders();
        Collections.list(httpServletRequest.getHeaderNames()).forEach(k -> headers.put(k, Collections.list(httpServletRequest.getHeaders(k))));
        headers.add(ROUTED, TRUE);
        MsgPicker.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
        ErrorCode.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
        try {
            String queryString = StringUtils.isBlank((CharSequence)httpServletRequest.getQueryString()) ? "" : "?" + httpServletRequest.getQueryString();
            ResponseEntity exchange = restTemplate.exchange("http://all" + httpServletRequest.getRequestURI() + queryString, HttpMethod.valueOf((String)httpServletRequest.getMethod()), new HttpEntity((Object)body, (MultiValueMap)headers), byte[].class, new Object[0]);
            this.tryCatchUp();
            responseHeaders = exchange.getHeaders();
            responseBody = (byte[])Optional.ofNullable(exchange.getBody()).orElse(new byte[0]);
            responseStatus = exchange.getStatusCodeValue();
        }
        catch (IllegalStateException | ResourceAccessException e) {
            responseStatus = 500;
            Message msg = MsgPicker.getMsg();
            KylinException exception = this.getKylinException(project, msg);
            ErrorResponse errorResponse = new ErrorResponse(httpServletRequest.getRequestURL().toString(), (Throwable)exception);
            responseBody = JsonUtil.writeValueAsBytes((Object)errorResponse);
            responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.APPLICATION_JSON);
            log.error("no job node", e);
        }
        catch (HttpStatusCodeException e) {
            responseStatus = e.getRawStatusCode();
            responseBody = e.getResponseBodyAsByteArray();
            responseHeaders = Optional.ofNullable(e.getResponseHeaders()).orElse(new HttpHeaders());
            log.warn("code {}, error {}", (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("transfer failed", (Throwable)e);
            servletRequest.setAttribute(ERROR, (Object)new KylinException((ErrorCodeSupplier)ServerErrorCode.TRANSFER_FAILED, MsgPicker.getMsg().getTransferFailed()));
            servletRequest.getRequestDispatcher(API_ERROR).forward(servletRequest, servletResponse);
            return;
        }
        httpServletResponse.setStatus(responseStatus);
        this.setResponseHeaders(responseHeaders, httpServletResponse);
        httpServletResponse.getOutputStream().write(responseBody);
    }

    protected void tryCatchUp() {
        try {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.getAuditLogStore().catchupWithTimeout();
        }
        catch (Exception e) {
            log.error("Failed to catchup manually.", (Throwable)e);
        }
    }
}

