/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.util;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.job.execution.AbstractExecutable;

public class ExecutableParaUtil {
    public static String getOutputMetaUrl(AbstractExecutable buildTask) {
        return buildTask.getParam("outputMetaUrl");
    }

    public static String getDataflowId(AbstractExecutable buildTask) {
        return buildTask.getParam("dataflowId");
    }

    public static Set<String> getSegmentIds(AbstractExecutable buildTask) {
        return Stream.of(StringUtils.split((String)buildTask.getParam("segmentIds"), (String)",")).collect(Collectors.toSet());
    }

    public static Set<Long> getLayoutIds(AbstractExecutable buildTask) {
        return Stream.of(StringUtils.split((String)buildTask.getParam("layoutIds"), (String)",")).map(Long::parseLong).collect(Collectors.toSet());
    }

    public static Set<Long> getPartitionIds(AbstractExecutable buildTask) {
        if (CollectionUtils.isEmpty(buildTask.getTargetPartitions())) {
            return new HashSet<Long>();
        }
        return buildTask.getTargetPartitions();
    }

    public static String getToBeDeletedLayoutIdsStr(AbstractExecutable buildTask) {
        return buildTask.getParam("toBeDeletedLayoutIds");
    }

    public static boolean needBuildSnapshots(AbstractExecutable buildTask) {
        String param = buildTask.getParam("needBuildSnapshots");
        return StringUtils.isBlank((CharSequence)param) || Boolean.parseBoolean(param);
    }

    public static String getTableIdentity(AbstractExecutable buildTask) {
        return buildTask.getParam("table");
    }

    public static String getSelectPartCol(AbstractExecutable buildTask) {
        return buildTask.getParam("selectedPartitionCol");
    }

    public static boolean isIncrementBuild(AbstractExecutable buildTask) {
        return "true".equals(buildTask.getParam("incrementalBuild"));
    }
}

