/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnumToDisplay;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentUtil.class);

    public static Segments<NDataSegment> getSegmentsExcludeRefreshingAndMerging(Segments<NDataSegment> segments) {
        Segments result = new Segments();
        Set<String> allIndexJobRunningSegments = segments.getFirstSegment() == null ? null : SegmentUtil.getAllIndexJobRunningSegments(((NDataSegment)segments.getFirstSegment()).getModel());
        for (NDataSegment seg : segments) {
            SegmentStatusEnumToDisplay status = SegmentUtil.getSegmentStatusToDisplay(segments, seg, null, allIndexJobRunningSegments);
            if (Objects.equals(SegmentStatusEnumToDisplay.REFRESHING, status) || Objects.equals(SegmentStatusEnumToDisplay.MERGING, status)) continue;
            result.add((Object)seg);
        }
        return result;
    }

    public static <T extends ISegment> SegmentStatusEnumToDisplay getSegmentStatusToDisplay(Segments segments, T segment, List<AbstractExecutable> executables, Set<String> allIndexJobRunningSegments) {
        Segments overlapSegs = segments.getSegmentsByRange(segment.getSegRange());
        overlapSegs.remove(segment);
        if (SegmentStatusEnum.NEW == segment.getStatus()) {
            if (!CollectionUtils.isEmpty((Collection)overlapSegs) && ((ISegment)overlapSegs.get(0)).getSegRange().entireOverlaps(segment.getSegRange())) {
                return SegmentStatusEnumToDisplay.REFRESHING;
            }
            if (CollectionUtils.isEmpty((Collection)overlapSegs) || SegmentUtil.anyIncSegmentJobRunning(segment)) {
                return SegmentStatusEnumToDisplay.LOADING;
            }
            return SegmentStatusEnumToDisplay.MERGING;
        }
        if (SegmentUtil.isAnyPartitionLoading(segment)) {
            return SegmentStatusEnumToDisplay.LOADING;
        }
        if (SegmentUtil.isAnyPartitionRefreshing(segment)) {
            return SegmentStatusEnumToDisplay.REFRESHING;
        }
        if (CollectionUtils.isNotEmpty((Collection)overlapSegs)) {
            if (CollectionUtils.isEmpty((Collection)overlapSegs.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.NEW}))) {
                return SegmentStatusEnumToDisplay.OVERLAP;
            }
            return SegmentStatusEnumToDisplay.LOCKED;
        }
        if (SegmentUtil.anyIndexJobRunning(segment, executables, allIndexJobRunningSegments)) {
            return SegmentStatusEnumToDisplay.LOADING;
        }
        if (SegmentStatusEnum.WARNING == segment.getStatus()) {
            return SegmentStatusEnumToDisplay.WARNING;
        }
        return SegmentStatusEnumToDisplay.ONLINE;
    }

    protected static <T extends ISegment> boolean anyIndexJobRunning(T segment) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execManager = ExecutableManager.getInstance(kylinConfig, segment.getModel().getProject());
        List<AbstractExecutable> executables = execManager.listExecByModelAndStatus(segment.getModel().getId(), ExecutableState::isRunning, JobTypeEnum.INDEX_BUILD, JobTypeEnum.SUB_PARTITION_BUILD);
        return executables.stream().anyMatch(task -> task.getSegmentIds().contains(segment.getId()));
    }

    protected static <T extends ISegment> boolean anyIncSegmentJobRunning(T segment) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execManager = ExecutableManager.getInstance(kylinConfig, segment.getModel().getProject());
        List<AbstractExecutable> executables = execManager.listExecByModelAndStatus(segment.getModel().getId(), ExecutableState::isRunning, JobTypeEnum.INC_BUILD);
        return executables.stream().anyMatch(task -> task.getSegmentIds().contains(segment.getId()));
    }

    protected static <T extends ISegment> boolean anyIndexJobRunning(T segment, List<AbstractExecutable> executables, Set<String> allIndexJobRunningSegments) {
        if (Objects.isNull(executables)) {
            return allIndexJobRunningSegments == null ? SegmentUtil.anyIndexJobRunning(segment) : allIndexJobRunningSegments.contains(segment.getId());
        }
        return executables.stream().anyMatch(task -> task.getSegmentIds().contains(segment.getId()));
    }

    public static Set<String> getAllIndexJobRunningSegments(NDataModel model) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execManager = ExecutableManager.getInstance(kylinConfig, model.getProject());
        List<AbstractExecutable> executables = execManager.listExecByModelAndStatus(model.getId(), ExecutableState::isRunning, JobTypeEnum.INDEX_BUILD, JobTypeEnum.SUB_PARTITION_BUILD);
        return executables.stream().flatMap(task -> task.getSegmentIds().stream()).collect(Collectors.toSet());
    }

    private static <T extends ISegment> boolean isAnyPartitionLoading(T segment) {
        Preconditions.checkArgument((boolean)(segment instanceof NDataSegment));
        List partitions = ((NDataSegment)segment).getMultiPartitions();
        if (CollectionUtils.isEmpty((Collection)partitions)) {
            return false;
        }
        SegmentPartition loadingPartition = partitions.stream().filter(partition -> PartitionStatusEnum.NEW == partition.getStatus()).findAny().orElse(null);
        return loadingPartition != null;
    }

    private static <T extends ISegment> boolean isAnyPartitionRefreshing(T segment) {
        Preconditions.checkArgument((boolean)(segment instanceof NDataSegment));
        List partitions = ((NDataSegment)segment).getMultiPartitions();
        if (CollectionUtils.isEmpty((Collection)partitions)) {
            return false;
        }
        SegmentPartition refreshPartition = partitions.stream().filter(partition -> PartitionStatusEnum.REFRESH == partition.getStatus()).findAny().orElse(null);
        return refreshPartition != null;
    }

    public static Segments<NDataSegment> getValidSegments(String modelId, String project) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataflow(modelId);
        JobMapperFilter jobMapperFilter = new JobMapperFilter();
        jobMapperFilter.setProject(project);
        jobMapperFilter.setModelIds(Lists.newArrayList((Object[])new String[]{modelId}));
        jobMapperFilter.setStatuses(ExecutableState.getNotFinalStates());
        List<JobInfo> runningJobInfoList = JobContextUtil.getJobInfoDao(KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(jobMapperFilter);
        ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        List executables = runningJobInfoList.stream().map(jobInfo -> executableManager.fromPO(JobInfoUtil.deserializeExecutablePO(jobInfo))).collect(Collectors.toList());
        Segments runningSegs = new Segments();
        executables.stream().filter(e -> e.getTargetSegments() != null).flatMap(e -> e.getTargetSegments().stream()).distinct().filter(segId -> df.getSegment(segId) != null).forEach(segId -> runningSegs.add((Object)df.getSegment(segId)));
        return SegmentUtil.getSegmentsByTime((Segments<NDataSegment>)df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING}), (Segments<NDataSegment>)runningSegs);
    }

    public static Segments<NDataSegment> getSegmentsByTime(Segments<NDataSegment> targetSegments, Segments<NDataSegment> checkSegments) {
        Segments filterSegs = new Segments();
        for (NDataSegment targetSeg : targetSegments) {
            boolean isOverLap = false;
            for (NDataSegment relatedSeg : checkSegments) {
                if (!targetSeg.getSegRange().overlaps(relatedSeg.getSegRange())) continue;
                isOverLap = true;
                break;
            }
            if (isOverLap) continue;
            filterSegs.add((Object)targetSeg);
        }
        return filterSegs;
    }

    public static Set<Long> intersectionLayouts(Segments<NDataSegment> segments) {
        HashSet<Long> layoutIds = Sets.newHashSet();
        if (segments.isEmpty()) {
            return layoutIds;
        }
        layoutIds = new HashSet<Long>(((NDataSegment)segments.get(0)).getLayoutsMap().keySet());
        for (NDataSegment segment : segments) {
            if (segment.getLayoutsMap().size() == 0) {
                layoutIds.clear();
                break;
            }
            layoutIds.retainAll(segment.getLayoutsMap().keySet());
        }
        return layoutIds;
    }
}

