/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.utils.JobMetrics;
import org.apache.kylin.engine.spark.utils.Metrics$;
import org.apache.kylin.engine.spark.utils.Repartitioner;
import org.apache.kylin.engine.spark.utils.StorageUtils$;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.LayoutFormatWriter;
import org.apache.spark.sql.datasource.storage.StorageListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class LayoutFormatWriter$
implements Logging {
    public static LayoutFormatWriter$ MODULE$;
    private final String TEMP_FLAG;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new LayoutFormatWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TEMP_FLAG() {
        return this.TEMP_FLAG;
    }

    public LayoutFormatWriter.OutputSpec write(Dataset<Row> dataFrame, LayoutEntity layout, Path outputPath, KapConfig kapConfig, Option<StorageListener> storageListener) {
        LayoutFormatWriter.OutputSpec outputSpec;
        SparkSession ss = dataFrame.sparkSession();
        Configuration hadoopConf = ss.sparkContext().hadoopConfiguration();
        FileSystem fs = outputPath.getFileSystem(hadoopConf);
        ImmutableSet dims = layout.getOrderedDimensions().keySet();
        Column[] sortColumns = NSparkCubingUtil.getColumns(new Set[]{dims});
        if (kapConfig.isAggIndexAdaptiveBuildEnabled() && this.unNeedRepartitionByShardCols(layout)) {
            Dataset df = dataFrame.repartition((Seq)Nil$.MODULE$).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortColumns));
            JobMetrics metrics = StorageUtils$.MODULE$.writeWithMetrics((Dataset<Row>)df, outputPath.toString());
            long rowCount = metrics.getMetrics(Metrics$.MODULE$.CUBOID_ROWS_CNT());
            outputSpec = new LayoutFormatWriter.OutputSpec(metrics, rowCount, hadoopConf, -1);
        } else {
            String tempPath = new StringBuilder(0).append(outputPath.toString()).append(this.TEMP_FLAG()).append(System.currentTimeMillis()).toString();
            Dataset df = dataFrame.sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortColumns));
            JobMetrics metrics = StorageUtils$.MODULE$.writeWithMetrics((Dataset<Row>)df, tempPath);
            long rowCount = metrics.getMetrics(Metrics$.MODULE$.CUBOID_ROWS_CNT());
            storageListener.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.onPersistBeforeRepartition((Dataset<Row>)df, layout);
                return BoxedUnit.UNIT;
            });
            int bucketNum = StorageUtils$.MODULE$.calculateBucketNum(tempPath, layout, rowCount, kapConfig);
            ContentSummary summary = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(tempPath));
            long repartitionThresholdSize = StorageUtils$.MODULE$.findCountDistinctMeasure(layout) ? kapConfig.getParquetStorageCountDistinctShardSizeRowCount() : kapConfig.getParquetStorageShardSizeRowCount();
            Repartitioner repartitioner = new Repartitioner(kapConfig.getParquetStorageShardSizeMB(), kapConfig.getParquetStorageRepartitionThresholdSize(), this.needResetRowGroup(rowCount, summary, kapConfig), kapConfig.getParquetBlockSize(), kapConfig.getParquetPageSizeRowCheckMax(), rowCount, repartitionThresholdSize, summary, layout.getShardByColumns(), (List<Integer>)layout.getOrderedDimensions().keySet().asList(), kapConfig.optimizeShardEnabled());
            repartitioner.doRepartition(outputPath.toString(), tempPath, bucketNum, ss);
            storageListener.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.onPersistAfterRepartition((Dataset<Row>)ss.read().parquet(outputPath.toString()), layout);
                return BoxedUnit.UNIT;
            });
            outputSpec = new LayoutFormatWriter.OutputSpec(metrics, rowCount, hadoopConf, bucketNum);
        }
        return outputSpec;
    }

    public boolean unNeedRepartitionByShardCols(LayoutEntity layout) {
        return layout.getShardByColumns() == null || layout.getShardByColumns().isEmpty();
    }

    public boolean needResetRowGroup(long totalRowCount, ContentSummary contentSummary, KapConfig kapConfig) {
        return kapConfig.isResetParquetBlockSize() && (double)totalRowCount / ((double)contentSummary.getLength() * 1.0 / (double)StorageUtils$.MODULE$.MB()) > (double)kapConfig.getParquetRowCountPerMb();
    }

    private LayoutFormatWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.TEMP_FLAG = "_temp_";
    }
}

