/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.common.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.spark.utils.SparkHadoopUtils;

public abstract class AbstractHdfsLogAppender
extends AbstractOutputStreamAppender<HdfsManager> {
    public static final long ROLLING_BYTE_SIZE_DEFAULT = 524288000L;
    private static final double QUEUE_FLUSH_THRESHOLD = 0.2;
    private final Object flushLogLock = new Object();
    private final Object initWriterLock = new Object();
    private final Object closeLock = new Object();
    private final Object fileSystemLock = new Object();
    private volatile FSDataOutputStream outStream = null;
    private volatile FileSystem fileSystem = null;
    private ExecutorService appendHdfsService = null;
    private BlockingDeque<LogEvent> logBufferQue = null;
    private int logQueueCapacity = 8192;
    private int flushInterval = 5000;
    private String workingDir;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private long start = System.currentTimeMillis();

    protected AbstractHdfsLogAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, HdfsManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
        StatusLogger.getLogger().warn("{} starting ...", (Object)this.getAppenderName());
        StatusLogger.getLogger().warn("hdfsWorkingDir -> {}", (Object)this.getWorkingDir());
        this.init();
        this.logBufferQue = new LinkedBlockingDeque<LogEvent>(this.getLogQueueCapacity());
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("logger-thread-%d").build();
        this.appendHdfsService = Executors.newSingleThreadExecutor(factory);
        this.appendHdfsService.submit(this::checkAndFlushLog);
        ShutdownHookManager.get().addShutdownHook(() -> {
            this.stop();
            this.closeWriter();
        }, 20);
        StatusLogger.getLogger().warn("{} started ...", (Object)this.getAppenderName());
    }

    public FileSystem getFileSystem() {
        if (null == this.fileSystem) {
            return this.getFileSystem(SparkHadoopUtils.newConfiguration());
        }
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystem(Configuration conf) {
        Object object = this.fileSystemLock;
        synchronized (object) {
            if (null == this.fileSystem) {
                try {
                    if (Objects.isNull(this.workingDir) || this.workingDir.isEmpty()) {
                        this.workingDir = System.getProperty("kylin.hdfs.working.dir");
                        StatusLogger.getLogger().warn("hdfsWorkingDir -> " + this.getWorkingDir());
                    }
                    this.fileSystem = FileSystem.newInstance((URI)new Path(this.workingDir).toUri(), (Configuration)conf);
                }
                catch (IOException e) {
                    StatusLogger.getLogger().error("Failed to create the file system, ", (Throwable)e);
                    throw new KylinRuntimeException("Failed to create the file system, ", (Throwable)e);
                }
            }
        }
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriterInited() {
        Object object = this.initWriterLock;
        synchronized (object) {
            return null != this.outStream;
        }
    }

    abstract void init();

    abstract String getAppenderName();

    public void append(LogEvent loggingEvent) {
        try {
            boolean offered = this.logBufferQue.offer(loggingEvent, 10L, TimeUnit.SECONDS);
            if (!offered) {
                StatusLogger.getLogger().error("LogEvent cannot put into the logBufferQue, log event content:");
                this.printLoggingEvent(loggingEvent);
            }
        }
        catch (InterruptedException e) {
            StatusLogger.getLogger().warn("Append logging event interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isStopped()) {
                this.finished.set(true);
                try {
                    if (this.appendHdfsService != null && !this.appendHdfsService.isShutdown()) {
                        ExecutorServiceUtil.shutdownGracefully((ExecutorService)this.appendHdfsService, (int)60);
                    }
                }
                catch (Exception e) {
                    try {
                        while (!this.getLogBufferQue().isEmpty()) {
                            this.printLoggingEvent(this.getLogBufferQue().take());
                        }
                    }
                    catch (Exception ie) {
                        StatusLogger.getLogger().error("clear the logging buffer queue failed!", (Throwable)ie);
                    }
                    StatusLogger.getLogger().error(String.format(Locale.ROOT, "close %s failed!", this.getAppenderName()), (Throwable)e);
                }
                StatusLogger.getLogger().warn("{} closed ...", (Object)this.getAppenderName());
            }
        }
    }

    private void closeWriter() {
        ((HdfsManager)this.getManager()).close();
        this.outStream = null;
    }

    abstract boolean isSkipCheckAndFlushLog();

    private void clearLogBufferQueueWhenBlocked() {
        if (this.logBufferQue.size() >= this.getLogQueueCapacity()) {
            for (int removeNum = this.getLogQueueCapacity() / 5; removeNum > 0; --removeNum) {
                try {
                    LogEvent loggingEvent = this.logBufferQue.take();
                    this.printLoggingEvent(loggingEvent);
                    continue;
                }
                catch (Exception ex) {
                    StatusLogger.getLogger().error("Take event interrupted!", (Throwable)ex);
                }
            }
        }
    }

    private void printLoggingEvent(LogEvent loggingEvent) {
        try {
            this.getLayout().encode((Object)loggingEvent, (ByteBufferDestination)this.getManager());
            if (null != loggingEvent.getThrown()) {
                for (StackTraceElement stack : loggingEvent.getThrown().getStackTrace()) {
                    StatusLogger.getLogger().error((Object)stack);
                }
            }
        }
        catch (Exception e) {
            StatusLogger.getLogger().error("print logging event failed!", (Throwable)e);
        }
    }

    protected void checkAndFlushLog() {
        do {
            ArrayList transaction = Lists.newArrayList();
            try {
                if (this.isSkipCheckAndFlushLog()) continue;
                int eventSize = this.getLogBufferQue().size();
                if (this.finished.get()) {
                    if (eventSize <= 0) break;
                    this.flushLog(eventSize, transaction);
                    break;
                }
                if ((double)eventSize > (double)this.getLogQueueCapacity() * 0.2 || System.currentTimeMillis() - this.start > (long)this.getFlushInterval()) {
                    this.start = System.currentTimeMillis();
                    this.flushLog(eventSize, transaction);
                    continue;
                }
                Thread.sleep(this.getFlushInterval() / 100);
            }
            catch (Exception e) {
                transaction.forEach(this::printLoggingEvent);
                this.clearLogBufferQueueWhenBlocked();
                StatusLogger.getLogger().error("Error occurred when consume event", (Throwable)e);
            }
        } while (!this.isStopped());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initHdfsWriter(Path outPath, Configuration conf) {
        Object object = this.initWriterLock;
        synchronized (object) {
            StatusLogger.getLogger().warn("init hdfs writer...");
            this.closeWriter();
            int retry = 10;
            while (retry-- > 0) {
                try {
                    this.fileSystem = this.getFileSystem(conf);
                    this.outStream = this.fileSystem.exists(outPath) ? this.fileSystem.append(outPath, 8192) : this.fileSystem.create(outPath, false);
                    break;
                }
                catch (Exception e) {
                    StatusLogger.getLogger().error("fail to create stream for path: " + outPath, (Throwable)e);
                    try {
                        this.initWriterLock.wait(1000L);
                    }
                    catch (InterruptedException e2) {
                        StatusLogger.getLogger().warn("Init writer interrupted!", (Throwable)e2);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (null != this.outStream) {
                ((HdfsManager)this.getManager()).setOutputStream((OutputStream)this.outStream);
                return true;
            }
        }
        return false;
    }

    protected void writeLogEvent(LogEvent loggingEvent) {
        if (null != loggingEvent) {
            this.getLayout().encode((Object)loggingEvent, (ByteBufferDestination)this.getManager());
        }
    }

    abstract void doWriteLog(int var1, List<LogEvent> var2) throws IOException, InterruptedException;

    private void flush() {
        ((HdfsManager)this.getManager()).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushLog(int eventSize, List<LogEvent> transaction) throws IOException, InterruptedException {
        if (eventSize <= 0) {
            return;
        }
        Object object = this.flushLogLock;
        synchronized (object) {
            if (eventSize > this.getLogBufferQue().size()) {
                eventSize = this.getLogBufferQue().size();
            }
            this.doWriteLog(eventSize, transaction);
            this.flush();
        }
    }

    protected boolean needRollingFile(String logPath, Long rollingMaxSize) throws IOException {
        Path pathProcess = new Path(logPath);
        FileSystem fs = this.getFileSystem();
        StatusLogger.getLogger().debug("log file path {}, {}", (Object)logPath, (Object)fs.exists(pathProcess));
        if (!fs.exists(pathProcess)) {
            return false;
        }
        ContentSummary contentSummary = fs.getContentSummary(pathProcess);
        long length = contentSummary.getLength();
        StatusLogger.getLogger().debug("log file length {}", (Object)length);
        return length > rollingMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String updateOutPutPath(String logPath) throws IOException {
        Object object = this.initWriterLock;
        synchronized (object) {
            StatusLogger.getLogger().debug("start rolling log file {}", (Object)logPath);
            Path pathProcess = new Path(logPath);
            Path pathDone = new Path(this.getLogPathRollingDone(logPath));
            this.getFileSystem().rename(pathProcess, pathDone);
            String currentProcessPath = this.getLogPathAfterRolling(logPath);
            this.outStream = null;
            StatusLogger.getLogger().debug("end rolling log file {}", (Object)currentProcessPath);
            return currentProcessPath;
        }
    }

    abstract String getLogPathAfterRolling(String var1);

    abstract String getLogPathRollingDone(String var1);

    @Generated
    public BlockingDeque<LogEvent> getLogBufferQue() {
        return this.logBufferQue;
    }

    @Generated
    public int getLogQueueCapacity() {
        return this.logQueueCapacity;
    }

    @Generated
    public void setLogQueueCapacity(int logQueueCapacity) {
        this.logQueueCapacity = logQueueCapacity;
    }

    @Generated
    public int getFlushInterval() {
        return this.flushInterval;
    }

    @Generated
    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    @Generated
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Generated
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public static class HdfsManager
    extends OutputStreamManager {
        protected HdfsManager(String streamName, Layout<?> layout) {
            super(null, streamName, layout, false);
        }

        private OutputStream getOutputStreamQuietly() {
            try {
                return this.getOutputStream();
            }
            catch (Exception e) {
                return null;
            }
        }

        protected synchronized void flushDestination() {
            OutputStream stream = this.getOutputStreamQuietly();
            if (stream != null) {
                try {
                    if (stream instanceof HdfsDataOutputStream) {
                        ((HdfsDataOutputStream)stream).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
                        return;
                    }
                    ((FSDataOutputStream)stream).hflush();
                }
                catch (IOException ex) {
                    throw new AppenderLoggingException("Error flushing stream " + this.getName(), (Throwable)ex);
                }
            }
        }

        protected synchronized boolean closeOutputStream() {
            super.flush();
            OutputStream stream = this.getOutputStreamQuietly();
            if (stream == null || stream == System.out || stream == System.err) {
                return true;
            }
            try {
                ((FSDataOutputStream)stream).hsync();
                stream.close();
                LOGGER.debug("OutputStream closed");
            }
            catch (IOException ex) {
                this.logError("Unable to close stream", ex);
                return false;
            }
            return true;
        }

        public void setOutputStream(OutputStream os) {
            super.setOutputStream(os);
        }
    }
}

