/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.expressions.Expression;
import io.delta.standalone.internal.CurrentTransactionInfo;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.IsolationLevel;
import io.delta.standalone.internal.Serializable$;
import io.delta.standalone.internal.SnapshotIsolation$;
import io.delta.standalone.internal.WinningCommitSummary;
import io.delta.standalone.internal.actions.Action;
import io.delta.standalone.internal.actions.Action$;
import io.delta.standalone.internal.actions.AddFile;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.actions.RemoveFile;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.Implicits$;
import io.delta.standalone.internal.util.PartitionUtils$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\f\u0019\u0001a\u0001\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011M\u0002!\u0011!Q\u0001\nQB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)q\t\u0001C\u0001\u0011\"9a\n\u0001b\u0001\n\u0013y\u0005B\u0002-\u0001A\u0003%\u0001\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007\"B3\u0001\t\u00031\u0007\"\u00026\u0001\t\u0013Y\u0007\"\u00027\u0001\t\u00131\u0007\"B7\u0001\t\u00131\u0007\"\u00028\u0001\t\u00131\u0007\"B8\u0001\t\u00131\u0007\"\u00029\u0001\t\u00131\u0007\"B9\u0001\t\u00131\u0007\"\u0002:\u0001\t\u0013\u0019\b\"B=\u0001\t\u0013Q\bBBA\u0010\u0001\u0011%aMA\bD_:4G.[2u\u0007\",7m[3s\u0015\tI\"$\u0001\u0005j]R,'O\\1m\u0015\tYB$\u0001\u0006ti\u0006tG-\u00197p]\u0016T!!\b\u0010\u0002\u000b\u0011,G\u000e^1\u000b\u0003}\t!![8\u0014\u0007\u0001\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003Ua\tq\u0001\\8hO&tw-\u0003\u0002-S\t9Aj\\4hS:<\u0017AF2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0004\u0001A\u0011\u0001'M\u0007\u00021%\u0011!\u0007\u0007\u0002\u0017\u0007V\u0014(/\u001a8u)J\fgn]1di&|g.\u00138g_\u0006!r/\u001b8oS:<7i\\7nSR4VM]:j_:\u0004\"AI\u001b\n\u0005Y\u001a#\u0001\u0002'p]\u001e\fa\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000e\u0005\u00021s%\u0011!\b\u0007\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u00031awn\u001a)sK\u001aL\u0007p\u0015;s!\tiDI\u0004\u0002?\u0005B\u0011qhI\u0007\u0002\u0001*\u0011\u0011IL\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u001b\u0013A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\u0012\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\t\u0001\u0004\u0001C\u0003.\u000b\u0001\u0007q\u0006C\u00034\u000b\u0001\u0007A\u0007C\u00038\u000b\u0001\u0007\u0001\bC\u0003<\u000b\u0001\u0007A(A\u0006uS6LgnZ*uCR\u001cX#\u0001)\u0011\tE3F\bN\u0007\u0002%*\u00111\u000bV\u0001\b[V$\u0018M\u00197f\u0015\t)6%\u0001\u0006d_2dWm\u0019;j_:L!a\u0016*\u0003\u000f!\u000b7\u000f['ba\u0006aA/[7j]\u001e\u001cF/\u0019;tA\u0005AA-\u001a7uC2{w-F\u0001\\!\t\u0001D,\u0003\u0002^1\taA)\u001a7uC2{w-S7qY\u0006IA-\u001a7uC2{w\rI\u0001\u0015o&tg.\u001b8h\u0007>lW.\u001b;Tk6l\u0017M]=\u0016\u0003\u0005\u0004\"\u0001\r2\n\u0005\rD\"\u0001F,j]:LgnZ\"p[6LGoU;n[\u0006\u0014\u00180A\u000bxS:t\u0017N\\4D_6l\u0017\u000e^*v[6\f'/\u001f\u0011\u0002\u001d\rDWmY6D_:4G.[2ugR\tq\r\u0005\u0002#Q&\u0011\u0011n\t\u0002\u0005+:LG/\u0001\u000ede\u0016\fG/Z,j]:LgnZ\"p[6LGoU;n[\u0006\u0014\u0018\u0010F\u0001b\u0003i\u0019\u0007.Z2l!J|Go\\2pY\u000e{W\u000e]1uS\nLG.\u001b;z\u0003Y\u0019\u0007.Z2l\u001d>lU\r^1eCR\fW\u000b\u001d3bi\u0016\u001c\u0018\u0001N2iK\u000e\\gi\u001c:BI\u0012,GMR5mKN$\u0006.\u0019;TQ>,H\u000e\u001a%bm\u0016\u0014U-\u001a8SK\u0006$')_\"veJ,g\u000e\u001e+y]\u0006q3\r[3dW\u001a{'\u000fR3mKR,GMR5mKN\fu-Y5ogR\u001cUO\u001d:f]R$\u0006P\u001c*fC\u00124\u0015\u000e\\3t\u0003E\u001a\u0007.Z2l\r>\u0014H)\u001a7fi\u0016$g)\u001b7fg\u0006;\u0017-\u001b8ti\u000e+(O]3oiRCh\u000eR3mKR,GMR5mKN\fqh\u00195fG.4uN]+qI\u0006$X\rZ!qa2L7-\u0019;j_:$&/\u00198tC\u000e$\u0018n\u001c8JIN$\u0006.\u0019;DkJ\u0014XM\u001c;Uq:$U\r]3oIN|e.A\rhKR\u0004&/\u001a;usB\u000b'\u000f^5uS>tW*Z:tC\u001e,GC\u0001\u001fu\u0011\u0015)H\u00031\u0001w\u0003=\u0001\u0018M\u001d;ji&|gNV1mk\u0016\u001c\b\u0003B\u001fxyqJ!\u0001\u001f$\u0003\u00075\u000b\u0007/\u0001\u0006sK\u000e|'\u000f\u001a+j[\u0016,\"a_@\u0015\u0007q\fY\u0002F\u0002~\u0003#\u0001\"A`@\r\u0001\u00119\u0011\u0011A\u000bC\u0002\u0005\r!!\u0001+\u0012\t\u0005\u0015\u00111\u0002\t\u0004E\u0005\u001d\u0011bAA\u0005G\t9aj\u001c;iS:<\u0007c\u0001\u0012\u0002\u000e%\u0019\u0011qB\u0012\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0014U!\t\u0019AA\u000b\u0003\u00051\u0007\u0003\u0002\u0012\u0002\u0018uL1!!\u0007$\u0005!a$-\u001f8b[\u0016t\u0004BBA\u000f+\u0001\u0007A(A\u0003qQ\u0006\u001cX-A\u0007sKB|'\u000f^'fiJL7m\u001d")
public class ConflictChecker
implements Logging {
    private final CurrentTransactionInfo currentTransactionInfo;
    private final long winningCommitVersion;
    private final IsolationLevel isolationLevel;
    private final String logPrefixStr;
    private final HashMap<String, Object> timingStats;
    private final DeltaLogImpl deltaLog;
    private final WinningCommitSummary winningCommitSummary;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    private HashMap<String, Object> timingStats() {
        return this.timingStats;
    }

    private DeltaLogImpl deltaLog() {
        return this.deltaLog;
    }

    private WinningCommitSummary winningCommitSummary() {
        return this.winningCommitSummary;
    }

    public void checkConflicts() {
        this.checkProtocolCompatibility();
        this.checkNoMetadataUpdates();
        this.checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn();
        this.checkForDeletedFilesAgainstCurrentTxnReadFiles();
        this.checkForDeletedFilesAgainstCurrentTxnDeletedFiles();
        this.checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn();
        this.reportMetrics();
    }

    private WinningCommitSummary createWinningCommitSummary() {
        return (WinningCommitSummary)this.recordTime("initialize-old-commit", (Function0 & Serializable & scala.Serializable)() -> {
            DeltaLogImpl deltaLog = $this.currentTransactionInfo.deltaLog();
            Action[] winningCommitActions = (Action[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Implicits$.MODULE$.DeltaStorageCloseableIteratorOps(deltaLog.store().read(FileNames$.MODULE$.deltaFile(deltaLog.logPath(), $this.winningCommitVersion), deltaLog.hadoopConf()), ClassTag$.MODULE$.apply(String.class)).toArray())).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Action.class)));
            return new WinningCommitSummary((Seq<Action>)Predef$.MODULE$.wrapRefArray((Object[])winningCommitActions), $this.winningCommitVersion);
        });
    }

    private void checkProtocolCompatibility() {
        block0: {
            if (!this.winningCommitSummary().protocol().nonEmpty()) break block0;
            this.winningCommitSummary().protocol().foreach((Function1 & Serializable & scala.Serializable)p -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$1(this, p);
                return BoxedUnit.UNIT;
            });
            this.currentTransactionInfo.actions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void checkNoMetadataUpdates() {
        if (this.winningCommitSummary().metadataUpdates().nonEmpty()) {
            throw DeltaErrors$.MODULE$.metadataChangedException(this.winningCommitSummary().commitInfo());
        }
    }

    private void checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn() {
        this.recordTime("checked-appends", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            IsolationLevel isolationLevel = $this.isolationLevel;
            if (Serializable$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)this.winningCommitSummary().changedDataAddedFiles().$plus$plus(this.winningCommitSummary().blindAppendAddedFiles(), Seq$.MODULE$.canBuildFrom());
            } else if (SnapshotIsolation$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)isolationLevel);
            }
            Seq addedFilesToCheckForConflicts = seq;
            Option predicatesMatchingAddedFiles = ((TraversableLike)$this.currentTransactionInfo.readPredicates().flatMap((Function1 & Serializable & scala.Serializable)p -> {
                Option conflictingFile = PartitionUtils$.MODULE$.filterFileList($this.currentTransactionInfo.metadata().partitionSchema(), (Seq<AddFile>)addedFilesToCheckForConflicts, (Expression)p).headOption();
                return Option$.MODULE$.option2Iterable(conflictingFile.map((Function1 & Serializable & scala.Serializable)f -> this.getPrettyPartitionMessage(f.partitionValues())));
            }, Seq$.MODULE$.canBuildFrom())).headOption();
            if (predicatesMatchingAddedFiles.isDefined()) {
                throw DeltaErrors$.MODULE$.concurrentAppendException(this.winningCommitSummary().commitInfo(), (String)predicatesMatchingAddedFiles.get());
            }
        });
    }

    private void checkForDeletedFilesAgainstCurrentTxnReadFiles() {
        this.recordTime("checked-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map readFilePaths = ((TraversableOnce)$this.currentTransactionInfo.readFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), f.partitionValues()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Option deleteReadOverlap = this.winningCommitSummary().removedFiles().find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)readFilePaths.contains((Object)r.path())));
            if (deleteReadOverlap.nonEmpty()) {
                String filePath = ((RemoveFile)deleteReadOverlap.get()).path();
                String partition = this.getPrettyPartitionMessage((Map<String, String>)((Map)readFilePaths.apply((Object)filePath)));
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), new StringBuilder(4).append(filePath).append(" in ").append(partition).toString());
            }
            if (this.winningCommitSummary().removedFiles().nonEmpty() && $this.currentTransactionInfo.readWholeTable()) {
                String filePath = ((RemoveFile)this.winningCommitSummary().removedFiles().head()).path();
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), String.valueOf(filePath));
            }
        });
    }

    private void checkForDeletedFilesAgainstCurrentTxnDeletedFiles() {
        this.recordTime("checked-2x-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set txnDeletes = ((TraversableOnce)((TraversableLike)$this.currentTransactionInfo.actions().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        object = removeFile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    boolean bl = action instanceof RemoveFile;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.path(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set deleteOverlap = (Set)((TraversableOnce)this.winningCommitSummary().removedFiles().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.path(), Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)txnDeletes);
            if (deleteOverlap.nonEmpty()) {
                throw DeltaErrors$.MODULE$.concurrentDeleteDeleteException(this.winningCommitSummary().commitInfo(), (String)deleteOverlap.head());
            }
        });
    }

    private void checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn() {
        Set txnOverlap = (Set)((TraversableOnce)this.winningCommitSummary().appLevelTransactions().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.appId(), Seq$.MODULE$.canBuildFrom())).toSet().intersect(this.currentTransactionInfo.readAppIds());
        if (txnOverlap.nonEmpty()) {
            throw DeltaErrors$.MODULE$.concurrentTransactionException(this.winningCommitSummary().commitInfo());
        }
    }

    private String getPrettyPartitionMessage(Map<String, String> partitionValues) {
        String string;
        Seq<String> partitionColumns = this.currentTransactionInfo.metadata().partitionColumns();
        if (partitionColumns.isEmpty()) {
            string = "the root of the table";
        } else {
            String partition = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append((String)name).append("=").append(partitionValues.apply(name)).toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
            string = new StringBuilder(10).append("partition ").append(partition).toString();
        }
        return string;
    }

    private <T> T recordTime(String phase, Function0<T> f) {
        long startTimeNs = System.nanoTime();
        Object ret = f.apply();
        long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
        this.timingStats().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase), (Object)BoxesRunTime.boxToLong((long)timeTakenMs)));
        return (T)ret;
    }

    private void reportMetrics() {
        LazyRef timingStr$lzy = new LazyRef();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("[").append($this.logPrefixStr).append("] Timing stats against ").append($this.winningCommitVersion).append(" [").append(this.timingStr$1(timingStr$lzy)).append("]").toString());
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$1(ConflictChecker $this, Protocol p) {
        $this.deltaLog().assertProtocolRead(p);
        $this.deltaLog().assertProtocolWrite(p);
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$2(ConflictChecker $this, Action x0$1) {
        Action action = x0$1;
        if (action instanceof Protocol) {
            throw DeltaErrors$.MODULE$.protocolChangedException($this.winningCommitSummary().commitInfo());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final /* synthetic */ String timingStr$lzycompute$1(LazyRef timingStr$lzy$1) {
        String string;
        LazyRef lazyRef = timingStr$lzy$1;
        synchronized (lazyRef) {
            string = timingStr$lzy$1.initialized() ? (String)timingStr$lzy$1.value() : (String)timingStr$lzy$1.initialize((Object)((TraversableOnce)((TraversableLike)this.timingStats().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(this.timingStats().apply(k)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        }
        return string;
    }

    private final String timingStr$1(LazyRef timingStr$lzy$1) {
        return timingStr$lzy$1.initialized() ? (String)timingStr$lzy$1.value() : this.timingStr$lzycompute$1(timingStr$lzy$1);
    }

    public ConflictChecker(CurrentTransactionInfo currentTransactionInfo, long winningCommitVersion, IsolationLevel isolationLevel, String logPrefixStr) {
        this.currentTransactionInfo = currentTransactionInfo;
        this.winningCommitVersion = winningCommitVersion;
        this.isolationLevel = isolationLevel;
        this.logPrefixStr = logPrefixStr;
        Logging.$init$(this);
        this.timingStats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deltaLog = currentTransactionInfo.deltaLog();
        this.winningCommitSummary = this.createWinningCommitSummary();
    }
}

