/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.response.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
@Order
public class SegmentsRequestFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentsRequestFilter.class);
    public static final Pattern REQUEST_URI_PATTERN = Pattern.compile("(/kylin/api/models/)\\S+(/segments)");
    public static final String BUILD_ALL_SUB_PARTITIONS_PARAMETER_NAME = "build_all_sub_partitions";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (request != null && httpServletRequest.getMethod().equals("POST") && REQUEST_URI_PATTERN.matcher(httpServletRequest.getRequestURI()).matches()) {
            try {
                JsonNode bodyNode = JsonUtil.readValueAsTree((String)IOUtils.toString((InputStream)httpServletRequest.getInputStream(), (Charset)StandardCharsets.UTF_8));
                HashSet bodyKeys = Sets.newHashSet((Iterator)bodyNode.fieldNames());
                if (bodyKeys.contains(BUILD_ALL_SUB_PARTITIONS_PARAMETER_NAME)) {
                    this.checkBooleanArg(BUILD_ALL_SUB_PARTITIONS_PARAMETER_NAME, bodyNode.get(BUILD_ALL_SUB_PARTITIONS_PARAMETER_NAME).asText());
                }
            }
            catch (KylinException e) {
                MsgPicker.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
                ErrorCode.setMsg((String)httpServletRequest.getHeader("Accept-Language"));
                ErrorResponse errorResponse = new ErrorResponse(httpServletRequest.getRequestURL().toString(), (Throwable)e);
                byte[] responseBody = JsonUtil.writeValueAsBytes((Object)errorResponse);
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.setStatus(500);
                httpServletResponse.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
                httpServletResponse.getOutputStream().write(responseBody);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void checkRequiredArg(String fieldName, Object fieldValue) {
        if (fieldValue == null || StringUtils.isEmpty((CharSequence)String.valueOf(fieldValue))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    public void checkBooleanArg(String fieldName, Object fieldValue) {
        this.checkRequiredArg(fieldName, fieldValue);
        String booleanString = String.valueOf(fieldValue);
        if (!String.valueOf(true).equalsIgnoreCase(booleanString) && !String.valueOf(false).equalsIgnoreCase(booleanString)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, new Object[]{booleanString, "Boolean"});
        }
    }

    public void destroy() {
    }
}

