/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.rest.annotation.OpSwagger;

public class OpSwaggerAnnotation {
    public static final OpSwagger DEFAULT = OpSwaggerAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(OpSwagger a) {
        return a == null || DEFAULT.equals(a);
    }

    public static boolean notEmpty(OpSwagger a) {
        return !OpSwaggerAnnotation.empty(a);
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        private String deprecated = "";
        private String operationId = "";
        private String[] consumes = new String[0];
        private String[] parameters = new String[0];
        private String[] produces = new String[0];
        private String[] responses = new String[0];
        private String[] schemes = new String[0];
        private String[] summary = new String[0];
        private String[] tags = new String[0];
        private String[] value = new String[0];

        protected Builder() {
            super(OpSwagger.class);
        }

        public OpSwagger build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder consumes(String ... value) {
            this.consumes = value;
            return this;
        }

        public Builder deprecated(String value) {
            this.deprecated = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder operationId(String value) {
            this.operationId = value;
            return this;
        }

        public Builder parameters(String ... value) {
            this.parameters = value;
            return this;
        }

        public Builder produces(String ... value) {
            this.produces = value;
            return this;
        }

        public Builder responses(String ... value) {
            this.responses = value;
            return this;
        }

        public Builder schemes(String ... value) {
            this.schemes = value;
            return this;
        }

        public Builder summary(String ... value) {
            this.summary = value;
            return this;
        }

        public Builder tags(String ... value) {
            this.tags = value;
            return this;
        }

        public Builder value(String ... value) {
            this.value = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements OpSwagger {
        private final String[] description;
        private final ExternalDocs externalDocs;
        private final String deprecated;
        private final String operationId;
        private final String[] consumes;
        private final String[] parameters;
        private final String[] produces;
        private final String[] responses;
        private final String[] schemes;
        private final String[] summary;
        private final String[] tags;
        private final String[] value;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.consumes = CollectionUtils.copyOf(b.consumes);
            this.deprecated = b.deprecated;
            this.externalDocs = b.externalDocs;
            this.operationId = b.operationId;
            this.parameters = CollectionUtils.copyOf(b.parameters);
            this.produces = CollectionUtils.copyOf(b.produces);
            this.responses = CollectionUtils.copyOf(b.responses);
            this.schemes = CollectionUtils.copyOf(b.schemes);
            this.summary = CollectionUtils.copyOf(b.summary);
            this.tags = CollectionUtils.copyOf(b.tags);
            this.value = CollectionUtils.copyOf(b.value);
        }

        @Override
        public String[] consumes() {
            return this.consumes;
        }

        @Override
        public String deprecated() {
            return this.deprecated;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public String[] parameters() {
            return this.parameters;
        }

        @Override
        public String[] produces() {
            return this.produces;
        }

        @Override
        public String[] responses() {
            return this.responses;
        }

        @Override
        public String[] schemes() {
            return this.schemes;
        }

        @Override
        public String[] summary() {
            return this.summary;
        }

        @Override
        public String[] tags() {
            return this.tags;
        }

        @Override
        public String[] value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

