/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidlCmdHandler
extends AbstractPOP3CommandHandler
implements CapaCapability {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidlCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"UIDL");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"UIDL");
    private final MetricFactory metricFactory;
    private final POP3MessageCommandDelegate commandDelegate;

    @Inject
    public UidlCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.commandDelegate = new POP3MessageCommandDelegate(this, COMMANDS){

            @Override
            protected Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) throws IOException {
                String identifier = session.getUserMailbox().getIdentifier();
                return new POP3Response("+OK", args.getMessageNumber() + " " + data.getUid(identifier));
            }
        };
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-uidl", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "UIDL").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.handleMessageRequest(session, request)));
    }

    private Response handleMessageRequest(POP3Session session, Request request) {
        LOGGER.trace("UIDL command received");
        if (request.getArgument() != null) {
            return this.commandDelegate.handleMessageRequest(session, request);
        }
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
            try {
                String identifier = session.getUserMailbox().getIdentifier();
                POP3Response response = new POP3Response("+OK", "unique-id listing follows");
                for (int i = 0; i < uidList.size(); ++i) {
                    MessageMetaData metadata = (MessageMetaData)uidList.get(i);
                    if (deletedUidList.contains(metadata.getUid())) continue;
                    response.appendLine(i + 1 + " " + metadata.getUid(identifier));
                }
                response.appendLine(".");
                return response;
            }
            catch (IOException ioe) {
                return POP3Response.ERR;
            }
        }
        return POP3Response.ERR;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.getHandlerState() == 2) {
            return CAPS;
        }
        return Collections.emptySet();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

