/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.activemq.BlobMessage;
import org.apache.james.queue.activemq.ActiveMQSupport;
import org.apache.james.server.core.MimeMessageSource;

public class MimeMessageBlobMessageSource
implements MimeMessageSource,
ActiveMQSupport {
    private final String sourceId;
    private final BlobMessage message;

    public MimeMessageBlobMessageSource(BlobMessage message) throws JMSException {
        this.message = message;
        this.sourceId = message.getJMSMessageID();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.message.getInputStream();
        }
        catch (JMSException e) {
            throw new IOException("Unable to open stream", e);
        }
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public long getMessageSize() throws IOException {
        try {
            long size = this.message.getLongProperty("JAMES_MAIL_MESSAGE_SIZE");
            if (size == -1L) {
                super.getMessageSize();
            }
            return size;
        }
        catch (JMSException e) {
            throw new IOException("Unable to get message size", e);
        }
    }
}

