/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.user;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.List;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.table.CassandraSubscriptionTable;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private final CqlSession session;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement insertStatement;
    private final CassandraAsyncExecutor executor;

    public CassandraSubscriptionMapper(CqlSession session) {
        this.session = session;
        this.executor = new CassandraAsyncExecutor(session);
        this.deleteStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"subscription").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraSubscriptionTable.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSubscriptionTable.USER)), (Relation)Relation.column((CqlIdentifier)CassandraSubscriptionTable.MAILBOX).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSubscriptionTable.MAILBOX))})).build());
        this.selectStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"subscription").column(CassandraSubscriptionTable.MAILBOX).where((Relation)Relation.column((CqlIdentifier)CassandraSubscriptionTable.USER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSubscriptionTable.USER)))).build());
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"subscription").value(CassandraSubscriptionTable.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSubscriptionTable.USER)).value(CassandraSubscriptionTable.MAILBOX, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSubscriptionTable.MAILBOX)).build());
    }

    public void delete(Subscription subscription) {
        this.deleteReactive(subscription).block();
    }

    public List<Subscription> findSubscriptionsForUser(Username user) {
        return (List)Flux.from((Publisher)this.session.executeReactive((Statement)this.selectStatement.bind(new Object[0]).setString(CassandraSubscriptionTable.USER, user.asString()))).map(row -> new Subscription(user, row.getString(CassandraSubscriptionTable.MAILBOX))).collectList().block();
    }

    public Flux<Subscription> findSubscriptionsForUserReactive(Username user) {
        return this.executor.executeRows((Statement)this.selectStatement.bind(new Object[0]).setString(CassandraSubscriptionTable.USER, user.asString())).map(row -> new Subscription(user, row.getString(CassandraSubscriptionTable.MAILBOX)));
    }

    public void save(Subscription subscription) {
        this.saveReactive(subscription).block();
    }

    public Mono<Void> saveReactive(Subscription subscription) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraSubscriptionTable.USER, subscription.getUser().asString())).setString(CassandraSubscriptionTable.MAILBOX, subscription.getMailbox()));
    }

    public Mono<Void> deleteReactive(Subscription subscription) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setString(CassandraSubscriptionTable.USER, subscription.getUser().asString())).setString(CassandraSubscriptionTable.MAILBOX, subscription.getMailbox()));
    }
}

