/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.terms.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericModifier
implements Modifier,
ConfigurationEnabled {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericModifier.class);
    private String host;

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        LOGGER.debug("Processing modifier: {}", (Object)this);
        DNSLookupContinuation res = this.checkSPFLogged(spfData);
        LOGGER.debug("Processed modifier: {} resulted in {} ", (Object)this, (Object)(res == null ? spfData.getCurrentResult() : "dns continuation..."));
        return res;
    }

    protected abstract DNSLookupContinuation checkSPFLogged(SPFSession var1) throws PermErrorException, TempErrorException, NeutralException, NoneException;

    @Override
    public boolean enforceSingleInstance() {
        return true;
    }

    @Override
    public synchronized void config(Configuration params) throws PermErrorException {
        if (params.groupCount() > 0) {
            this.host = params.group(1);
        }
    }

    protected synchronized String getHost() {
        return this.host;
    }
}

